/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.netty.NettyServerHandler;
import io.grpc.netty.ProtocolNegotiator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;

class NettyServerTransport
implements ServerTransport {
    private static final Logger log = Logger.getLogger(NettyServerTransport.class.getName());
    private final Channel channel;
    private final ProtocolNegotiator protocolNegotiator;
    private final DecompressorRegistry decompressorRegistry;
    private final CompressorRegistry compressorRegistry;
    private final int maxStreams;
    private ServerTransportListener listener;
    private boolean terminated;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;

    NettyServerTransport(Channel channel, ProtocolNegotiator protocolNegotiator, DecompressorRegistry decompressorRegistry, CompressorRegistry compressorRegistry, int maxStreams, int flowControlWindow, int maxMessageSize, int maxHeaderListSize) {
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.protocolNegotiator = (ProtocolNegotiator)Preconditions.checkNotNull((Object)protocolNegotiator, (Object)"protocolNegotiator");
        this.maxStreams = maxStreams;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.decompressorRegistry = (DecompressorRegistry)Preconditions.checkNotNull((Object)decompressorRegistry, (Object)"decompressorRegistry");
        this.compressorRegistry = (CompressorRegistry)Preconditions.checkNotNull((Object)compressorRegistry, (Object)"compressorRegistry");
    }

    public void start(ServerTransportListener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Handler already registered");
        this.listener = listener;
        final NettyServerHandler grpcHandler = this.createHandler(listener);
        this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                NettyServerTransport.this.notifyTerminated(grpcHandler.connectionError());
            }
        });
        ProtocolNegotiator.Handler negotiationHandler = this.protocolNegotiator.newHandler(grpcHandler);
        this.channel.pipeline().addLast(new ChannelHandler[]{negotiationHandler});
    }

    public void shutdown() {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }

    Channel channel() {
        return this.channel;
    }

    private void notifyTerminated(Throwable t) {
        if (t != null) {
            log.log(Level.SEVERE, "Transport failed", t);
        }
        if (!this.terminated) {
            this.terminated = true;
            this.listener.transportTerminated();
        }
    }

    private NettyServerHandler createHandler(ServerTransportListener transportListener) {
        return NettyServerHandler.newHandler(transportListener, this.decompressorRegistry, this.compressorRegistry, this.maxStreams, this.flowControlWindow, this.maxHeaderListSize, this.maxMessageSize);
    }
}

