/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.internal.TransportFrameUtil;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.util.AsciiString;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

class Utils {
    public static final AsciiString STATUS_OK = AsciiString.of((CharSequence)"200");
    public static final AsciiString HTTP_METHOD = AsciiString.of((CharSequence)"POST");
    public static final AsciiString HTTPS = AsciiString.of((CharSequence)"https");
    public static final AsciiString HTTP = AsciiString.of((CharSequence)"http");
    public static final AsciiString CONTENT_TYPE_HEADER = AsciiString.of((CharSequence)GrpcUtil.CONTENT_TYPE_KEY.name());
    public static final AsciiString CONTENT_TYPE_GRPC = AsciiString.of((CharSequence)"application/grpc");
    public static final AsciiString TE_HEADER = AsciiString.of((CharSequence)"te");
    public static final AsciiString TE_TRAILERS = AsciiString.of((CharSequence)"trailers");
    public static final AsciiString USER_AGENT = AsciiString.of((CharSequence)GrpcUtil.USER_AGENT_KEY.name());
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_BOSS_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(1, "grpc-default-boss-ELG");
    public static final SharedResourceHolder.Resource<EventLoopGroup> DEFAULT_WORKER_EVENT_LOOP_GROUP = new DefaultEventLoopGroupResource(0, "grpc-default-worker-ELG");

    public static Metadata convertHeaders(Http2Headers http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    private static byte[][] convertHeadersToArray(Http2Headers http2Headers) {
        byte[][] headerValues = new byte[http2Headers.size() * 2][];
        int i = 0;
        for (Map.Entry entry : http2Headers) {
            headerValues[i++] = Utils.bytes((CharSequence)entry.getKey());
            headerValues[i++] = Utils.bytes((CharSequence)entry.getValue());
        }
        return TransportFrameUtil.toRawSerializedHeaders((byte[][])headerValues);
    }

    private static byte[] bytes(CharSequence seq) {
        if (seq instanceof AsciiString) {
            return ((AsciiString)seq).array();
        }
        return seq.toString().getBytes(CharsetUtil.UTF_8);
    }

    public static Http2Headers convertClientHeaders(Metadata headers, AsciiString scheme, AsciiString defaultPath, AsciiString defaultAuthority) {
        Preconditions.checkNotNull((Object)defaultPath, (Object)"defaultPath");
        Preconditions.checkNotNull((Object)defaultAuthority, (Object)"defaultAuthority");
        Http2Headers http2Headers = Utils.convertMetadata(headers);
        ((Http2Headers)http2Headers.authority((CharSequence)defaultAuthority).path((CharSequence)defaultPath).method((CharSequence)HTTP_METHOD).scheme((CharSequence)scheme).set((Object)CONTENT_TYPE_HEADER, (Object)CONTENT_TYPE_GRPC)).set((Object)TE_HEADER, (Object)TE_TRAILERS);
        if (headers.containsKey(GrpcUtil.AUTHORITY_KEY)) {
            http2Headers.authority((CharSequence)new AsciiString(((String)headers.get(GrpcUtil.AUTHORITY_KEY)).getBytes(CharsetUtil.UTF_8)));
        }
        String userAgent = GrpcUtil.getGrpcUserAgent((String)"netty", (String)((String)headers.get(GrpcUtil.USER_AGENT_KEY)));
        http2Headers.set((Object)USER_AGENT, (Object)new AsciiString(userAgent.getBytes(CharsetUtil.UTF_8)));
        return http2Headers;
    }

    public static Http2Headers convertServerHeaders(Metadata headers) {
        Http2Headers http2Headers = Utils.convertMetadata(headers);
        http2Headers.set((Object)CONTENT_TYPE_HEADER, (Object)CONTENT_TYPE_GRPC);
        http2Headers.status((CharSequence)STATUS_OK);
        return http2Headers;
    }

    public static Metadata convertTrailers(Http2Headers http2Headers) {
        return new Metadata(Utils.convertHeadersToArray(http2Headers));
    }

    public static Http2Headers convertTrailers(Metadata trailers, boolean headersSent) {
        Http2Headers http2Trailers = Utils.convertMetadata(trailers);
        if (!headersSent) {
            http2Trailers.set((Object)CONTENT_TYPE_HEADER, (Object)CONTENT_TYPE_GRPC);
            http2Trailers.status((CharSequence)STATUS_OK);
        }
        return http2Trailers;
    }

    private static Http2Headers convertMetadata(Metadata headers) {
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        DefaultHttp2Headers http2Headers = new DefaultHttp2Headers();
        byte[][] serializedHeaders = TransportFrameUtil.toHttp2Headers((Metadata)headers);
        for (int i = 0; i < serializedHeaders.length; i += 2) {
            AsciiString name = new AsciiString(serializedHeaders[i], false);
            AsciiString value = new AsciiString(serializedHeaders[i + 1], false);
            http2Headers.add((Object)name, (Object)value);
        }
        return http2Headers;
    }

    public static Status statusFromThrowable(Throwable t) {
        Status s = Status.fromThrowable((Throwable)t);
        if (s.getCode() != Status.Code.UNKNOWN) {
            return s;
        }
        if (t instanceof IOException) {
            return Status.UNAVAILABLE.withCause(t);
        }
        if (t instanceof Http2Exception) {
            return Status.INTERNAL.withCause(t);
        }
        return s;
    }

    private Utils() {
    }

    private static class DefaultEventLoopGroupResource
    implements SharedResourceHolder.Resource<EventLoopGroup> {
        private final String name;
        private final int numEventLoops;

        DefaultEventLoopGroupResource(int numEventLoops, String name) {
            this.name = name;
            this.numEventLoops = numEventLoops;
        }

        public EventLoopGroup create() {
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat(this.name + "-%d").build();
            int parallelism = this.numEventLoops == 0 ? Runtime.getRuntime().availableProcessors() * 2 : this.numEventLoops;
            final ExecutorService executor = Executors.newFixedThreadPool(parallelism, threadFactory);
            NioEventLoopGroup nioEventLoopGroup = new NioEventLoopGroup(parallelism, (Executor)executor);
            nioEventLoopGroup.terminationFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Object>>(){

                public void operationComplete(Future<Object> future) throws Exception {
                    executor.shutdown();
                }
            });
            return nioEventLoopGroup;
        }

        public void close(EventLoopGroup instance) {
            instance.shutdownGracefully(0L, 0L, TimeUnit.SECONDS);
        }

        public String toString() {
            return this.name;
        }
    }
}

