/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.Http2Ping;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.WithLogId;
import io.grpc.netty.ClientTransportLifecycleManager;
import io.grpc.netty.ForcefulCloseCommand;
import io.grpc.netty.GracefulCloseCommand;
import io.grpc.netty.NettyClientHandler;
import io.grpc.netty.NettyClientStream;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.SendPingCommand;
import io.grpc.netty.Utils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

class NettyClientTransport
implements ConnectionClientTransport {
    private final SocketAddress address;
    private final Class<? extends Channel> channelType;
    private final EventLoopGroup group;
    private final ProtocolNegotiator negotiator;
    private final AsciiString authority;
    private final AsciiString userAgent;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private ProtocolNegotiator.Handler negotiationHandler;
    private NettyClientHandler handler;
    private Channel channel;
    private ClientTransportLifecycleManager lifecycleManager;

    NettyClientTransport(SocketAddress address, Class<? extends Channel> channelType, EventLoopGroup group, ProtocolNegotiator negotiator, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, String authority, @Nullable String userAgent) {
        this.negotiator = (ProtocolNegotiator)Preconditions.checkNotNull((Object)negotiator, (Object)"negotiator");
        this.address = (SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.group = (EventLoopGroup)Preconditions.checkNotNull((Object)group, (Object)"group");
        this.channelType = (Class)Preconditions.checkNotNull(channelType, (Object)"channelType");
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.authority = new AsciiString((CharSequence)authority);
        this.userAgent = new AsciiString((CharSequence)GrpcUtil.getGrpcUserAgent((String)"netty", (String)userAgent));
    }

    public void ping(final ClientTransport.PingCallback callback, final Executor executor) {
        ChannelFutureListener failureListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Status s = NettyClientTransport.this.statusFromFailedFuture(future);
                    Http2Ping.notifyFailed((ClientTransport.PingCallback)callback, (Executor)executor, (Throwable)s.asException());
                }
            }
        };
        this.handler.getWriteQueue().enqueue(new SendPingCommand(callback, executor), true).addListener((GenericFutureListener)failureListener);
    }

    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        return new NettyClientStream(method, headers, this.channel, this.handler, this.maxMessageSize, this.authority, this.negotiationHandler.scheme(), this.userAgent){

            @Override
            protected Status statusFromFailedFuture(ChannelFuture f) {
                return NettyClientTransport.this.statusFromFailedFuture(f);
            }
        };
    }

    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        return this.newStream(method, headers, CallOptions.DEFAULT);
    }

    public void start(ManagedClientTransport.Listener transportListener) {
        this.lifecycleManager = new ClientTransportLifecycleManager((ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)transportListener, (Object)"listener"));
        this.handler = this.newHandler();
        this.negotiationHandler = this.negotiator.newHandler(this.handler);
        Bootstrap b = new Bootstrap();
        b.group(this.group);
        b.channel(this.channelType);
        if (NioSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        b.handler((ChannelHandler)this.negotiationHandler);
        this.channel = b.connect(this.address).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ChannelHandlerContext ctx = future.channel().pipeline().context((ChannelHandler)NettyClientTransport.this.handler);
                    if (ctx != null) {
                        ctx.fireExceptionCaught(future.cause());
                    }
                    future.channel().pipeline().fireExceptionCaught(future.cause());
                }
            }
        }).channel();
        this.handler.startWriteQueue(this.channel);
        this.channel.write(NettyClientHandler.NOOP_MESSAGE).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(Utils.statusFromThrowable(future.cause()));
                }
            }
        });
        this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                NettyClientTransport.this.lifecycleManager.notifyTerminated(Status.INTERNAL.withDescription("Connection closed with unknown cause"));
            }
        });
    }

    public void shutdown() {
        if (this.channel.isOpen()) {
            Status status = Status.UNAVAILABLE.withDescription("Channel requested transport to shut down");
            this.handler.getWriteQueue().enqueue(new GracefulCloseCommand(status), true);
        }
    }

    public void shutdownNow(Status reason) {
        if (this.channel != null && this.channel.isOpen()) {
            this.handler.getWriteQueue().enqueue(new ForcefulCloseCommand(reason), true);
        }
    }

    public String toString() {
        return this.getLogId() + "(" + this.address + ")";
    }

    public String getLogId() {
        return GrpcUtil.getLogId((WithLogId)this);
    }

    public Attributes getAttrs() {
        return Attributes.EMPTY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Status statusFromFailedFuture(ChannelFuture f) {
        Throwable t = f.cause();
        if (t instanceof ClosedChannelException) {
            NettyClientTransport nettyClientTransport = this;
            synchronized (nettyClientTransport) {
                Status shutdownStatus = this.lifecycleManager.getShutdownStatus();
                if (shutdownStatus == null) {
                    return Status.UNKNOWN.withDescription("Channel closed but for unknown reason");
                }
                return shutdownStatus;
            }
        }
        return Utils.statusFromThrowable(t);
    }

    private NettyClientHandler newHandler() {
        return NettyClientHandler.newHandler(this.lifecycleManager, this.flowControlWindow, this.maxHeaderListSize, Ticker.systemTicker());
    }
}

