/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.InternalChannelz;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

@CheckReturnValue
final class ProtocolNegotiationEvent {
    public static final ProtocolNegotiationEvent DEFAULT = new ProtocolNegotiationEvent(Attributes.EMPTY, null);
    private final Attributes attributes;
    @Nullable
    private final InternalChannelz.Security security;

    private ProtocolNegotiationEvent(Attributes attributes, @Nullable InternalChannelz.Security security) {
        this.attributes = (Attributes)Preconditions.checkNotNull((Object)attributes, (Object)"attributes");
        this.security = security;
    }

    @Nullable
    public InternalChannelz.Security getSecurity() {
        return this.security;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public ProtocolNegotiationEvent withAttributes(Attributes attributes) {
        return new ProtocolNegotiationEvent(attributes, this.security);
    }

    public ProtocolNegotiationEvent withSecurity(@Nullable InternalChannelz.Security security) {
        return new ProtocolNegotiationEvent(this.attributes, security);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("attributes", (Object)this.attributes).add("security", (Object)this.security).toString();
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.attributes, this.security});
    }

    public boolean equals(Object other) {
        if (!(other instanceof ProtocolNegotiationEvent)) {
            return false;
        }
        ProtocolNegotiationEvent that = (ProtocolNegotiationEvent)other;
        return Objects.equal((Object)this.attributes, (Object)that.attributes) && Objects.equal((Object)this.security, (Object)that.security);
    }
}

