/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import io.grpc.Attributes;
import io.grpc.CallOptions;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.Http2Ping;
import io.grpc.internal.KeepAliveManager;
import io.grpc.internal.LogId;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.StatsTraceContext;
import io.grpc.netty.ClientTransportLifecycleManager;
import io.grpc.netty.ForcefulCloseCommand;
import io.grpc.netty.GracefulCloseCommand;
import io.grpc.netty.HandlerSettings;
import io.grpc.netty.NettyClientHandler;
import io.grpc.netty.NettyClientStream;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.SendPingCommand;
import io.grpc.netty.Utils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.http2.StreamBufferingEncoder;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

class NettyClientTransport
implements ConnectionClientTransport {
    private final LogId logId = LogId.allocate((String)this.getClass().getName());
    private final Map<ChannelOption<?>, ?> channelOptions;
    private final SocketAddress address;
    private final Class<? extends Channel> channelType;
    private final EventLoopGroup group;
    private final ProtocolNegotiator negotiator;
    private final AsciiString authority;
    private final AsciiString userAgent;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private KeepAliveManager keepAliveManager;
    private boolean enableKeepAlive;
    private long keepAliveDelayNanos;
    private long keepAliveTimeoutNanos;
    private ProtocolNegotiator.Handler negotiationHandler;
    private NettyClientHandler handler;
    private Channel channel;
    private ClientTransportLifecycleManager lifecycleManager;

    NettyClientTransport(SocketAddress address, Class<? extends Channel> channelType, Map<ChannelOption<?>, ?> channelOptions, EventLoopGroup group, ProtocolNegotiator negotiator, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, String authority, @Nullable String userAgent) {
        this.negotiator = (ProtocolNegotiator)Preconditions.checkNotNull((Object)negotiator, (Object)"negotiator");
        this.address = (SocketAddress)Preconditions.checkNotNull((Object)address, (Object)"address");
        this.group = (EventLoopGroup)Preconditions.checkNotNull((Object)group, (Object)"group");
        this.channelType = (Class)Preconditions.checkNotNull(channelType, (Object)"channelType");
        this.channelOptions = (Map)Preconditions.checkNotNull(channelOptions, (Object)"channelOptions");
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.authority = new AsciiString((CharSequence)authority);
        this.userAgent = new AsciiString((CharSequence)GrpcUtil.getGrpcUserAgent((String)"netty", (String)userAgent));
    }

    void enableKeepAlive(boolean enable, long keepAliveDelayNanos, long keepAliveTimeoutNanos) {
        this.enableKeepAlive = enable;
        this.keepAliveDelayNanos = keepAliveDelayNanos;
        this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
    }

    public void ping(final ClientTransport.PingCallback callback, final Executor executor) {
        ChannelFutureListener failureListener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    Status s = NettyClientTransport.this.statusFromFailedFuture(future);
                    Http2Ping.notifyFailed((ClientTransport.PingCallback)callback, (Executor)executor, (Throwable)s.asException());
                }
            }
        };
        this.handler.getWriteQueue().enqueue(new SendPingCommand(callback, executor), true).addListener((GenericFutureListener)failureListener);
    }

    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers, CallOptions callOptions, StatsTraceContext statsTraceCtx) {
        Preconditions.checkNotNull(method, (Object)"method");
        Preconditions.checkNotNull((Object)headers, (Object)"headers");
        Preconditions.checkNotNull((Object)statsTraceCtx, (Object)"statsTraceCtx");
        return new NettyClientStream(new NettyClientStream.TransportState(this.handler, this.maxMessageSize, statsTraceCtx){

            @Override
            protected Status statusFromFailedFuture(ChannelFuture f) {
                return NettyClientTransport.this.statusFromFailedFuture(f);
            }
        }, method, headers, this.channel, this.authority, this.negotiationHandler.scheme(), this.userAgent, statsTraceCtx);
    }

    public ClientStream newStream(MethodDescriptor<?, ?> method, Metadata headers) {
        return this.newStream(method, headers, CallOptions.DEFAULT, StatsTraceContext.NOOP);
    }

    public Runnable start(ManagedClientTransport.Listener transportListener) {
        this.lifecycleManager = new ClientTransportLifecycleManager((ManagedClientTransport.Listener)Preconditions.checkNotNull((Object)transportListener, (Object)"listener"));
        this.handler = this.newHandler();
        HandlerSettings.setAutoWindow(this.handler);
        this.negotiationHandler = this.negotiator.newHandler(this.handler);
        Bootstrap b = new Bootstrap();
        b.group(this.group);
        b.channel(this.channelType);
        if (NioSocketChannel.class.isAssignableFrom(this.channelType)) {
            b.option(ChannelOption.SO_KEEPALIVE, (Object)true);
        }
        for (Map.Entry<ChannelOption<?>, ?> entry : this.channelOptions.entrySet()) {
            b.option(entry.getKey(), entry.getValue());
        }
        b.handler((ChannelHandler)this.negotiationHandler);
        this.channel = b.register().channel();
        this.channel.connect(this.address).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    ChannelHandlerContext ctx = future.channel().pipeline().context((ChannelHandler)NettyClientTransport.this.handler);
                    if (ctx != null) {
                        ctx.fireExceptionCaught(future.cause());
                    }
                    future.channel().pipeline().fireExceptionCaught(future.cause());
                }
            }
        });
        this.handler.startWriteQueue(this.channel);
        this.channel.write(NettyClientHandler.NOOP_MESSAGE).addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                if (!future.isSuccess()) {
                    NettyClientTransport.this.lifecycleManager.notifyTerminated(Utils.statusFromThrowable(future.cause()));
                }
            }
        });
        this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                NettyClientTransport.this.lifecycleManager.notifyTerminated(Status.INTERNAL.withDescription("Connection closed with unknown cause"));
            }
        });
        if (this.enableKeepAlive) {
            this.keepAliveManager = new KeepAliveManager((ManagedClientTransport)this, (ScheduledExecutorService)this.channel.eventLoop(), this.keepAliveDelayNanos, this.keepAliveTimeoutNanos);
        }
        return null;
    }

    public void shutdown() {
        if (this.channel.isOpen()) {
            Status status = Status.UNAVAILABLE.withDescription("Channel requested transport to shut down");
            this.handler.getWriteQueue().enqueue(new GracefulCloseCommand(status), true);
        }
    }

    public void shutdownNow(Status reason) {
        if (this.channel != null && this.channel.isOpen()) {
            this.handler.getWriteQueue().enqueue(new ForcefulCloseCommand(reason), true);
        }
    }

    public String toString() {
        return this.getLogId() + "(" + this.address + ")";
    }

    public LogId getLogId() {
        return this.logId;
    }

    public Attributes getAttributes() {
        return Attributes.EMPTY;
    }

    @VisibleForTesting
    Channel channel() {
        return this.channel;
    }

    @VisibleForTesting
    KeepAliveManager keepAliveManager() {
        return this.keepAliveManager;
    }

    private Status statusFromFailedFuture(ChannelFuture f) {
        Throwable t = f.cause();
        if (t instanceof ClosedChannelException || t instanceof StreamBufferingEncoder.Http2ChannelClosedException) {
            Status shutdownStatus = this.lifecycleManager.getShutdownStatus();
            if (shutdownStatus == null) {
                return Status.UNKNOWN.withDescription("Channel closed but for unknown reason");
            }
            return shutdownStatus;
        }
        return Utils.statusFromThrowable(t);
    }

    private NettyClientHandler newHandler() {
        return NettyClientHandler.newHandler(this.lifecycleManager, this.keepAliveManager, this.flowControlWindow, this.maxHeaderListSize, Ticker.systemTicker());
    }
}

