/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.Attributes;
import io.grpc.Grpc;
import io.grpc.InternalChannelz;
import io.grpc.SecurityLevel;
import io.grpc.Status;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import io.grpc.netty.GrpcHttp2ConnectionHandler;
import io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.JettyTlsUtil;
import io.grpc.netty.ProtocolNegotiationEvent;
import io.grpc.netty.ProtocolNegotiator;
import io.grpc.netty.Utils;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpClientUpgradeHandler;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2ClientUpgradeCodec;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyConnectionEvent;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSession;

final class ProtocolNegotiators {
    private static final Logger log = Logger.getLogger(ProtocolNegotiators.class.getName());

    private ProtocolNegotiators() {
    }

    public static ProtocolNegotiator serverPlaintext() {
        return new ProtocolNegotiator(){

            @Override
            public ChannelHandler newHandler(final GrpcHttp2ConnectionHandler handler) {
                class PlaintextHandler
                extends ChannelHandlerAdapter {
                    PlaintextHandler() {
                    }

                    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                        handler.handleProtocolNegotiationCompleted(Attributes.newBuilder().set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)ctx.channel().remoteAddress()).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)ctx.channel().localAddress()).build(), null);
                        ctx.pipeline().replace((ChannelHandler)this, null, (ChannelHandler)handler);
                    }
                }
                return new PlaintextHandler();
            }

            @Override
            public void close() {
            }

            @Override
            public AsciiString scheme() {
                return Utils.HTTP;
            }
        };
    }

    public static ProtocolNegotiator serverTls(final SslContext sslContext) {
        Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
        return new ProtocolNegotiator(){

            @Override
            public ChannelHandler newHandler(GrpcHttp2ConnectionHandler handler) {
                return new ServerTlsHandler(sslContext, handler);
            }

            @Override
            public void close() {
            }

            @Override
            public AsciiString scheme() {
                return Utils.HTTPS;
            }
        };
    }

    public static ProtocolNegotiator httpProxy(final SocketAddress proxyAddress, final @Nullable String proxyUsername, final @Nullable String proxyPassword, final ProtocolNegotiator negotiator) {
        final AsciiString scheme = negotiator.scheme();
        Preconditions.checkNotNull((Object)proxyAddress, (Object)"proxyAddress");
        Preconditions.checkNotNull((Object)negotiator, (Object)"negotiator");
        class ProxyNegotiator
        implements ProtocolNegotiator {
            ProxyNegotiator() {
            }

            @Override
            public ChannelHandler newHandler(GrpcHttp2ConnectionHandler http2Handler) {
                HttpProxyHandler proxyHandler = proxyUsername == null || proxyPassword == null ? new HttpProxyHandler(proxyAddress) : new HttpProxyHandler(proxyAddress, proxyUsername, proxyPassword);
                return new BufferUntilProxyTunnelledHandler((ProxyHandler)proxyHandler, negotiator.newHandler(http2Handler));
            }

            @Override
            public AsciiString scheme() {
                return scheme;
            }

            @Override
            public void close() {
                negotiator.close();
            }
        }
        return new ProxyNegotiator();
    }

    @VisibleForTesting
    static HostPort parseAuthority(String authority) {
        int port;
        String host;
        URI uri = GrpcUtil.authorityToUri((String)((String)Preconditions.checkNotNull((Object)authority, (Object)"authority")));
        if (uri.getHost() != null) {
            host = uri.getHost();
            port = uri.getPort();
        } else {
            host = authority;
            port = -1;
        }
        return new HostPort(host, port);
    }

    public static ProtocolNegotiator tls(SslContext sslContext) {
        return new ClientTlsProtocolNegotiator(sslContext);
    }

    public static ProtocolNegotiator plaintextUpgrade() {
        return new PlaintextUpgradeProtocolNegotiator();
    }

    public static ProtocolNegotiator plaintext() {
        return new PlaintextProtocolNegotiator();
    }

    private static RuntimeException unavailableException(String msg) {
        return Status.UNAVAILABLE.withDescription(msg).asRuntimeException();
    }

    @VisibleForTesting
    static void logSslEngineDetails(Level level, ChannelHandlerContext ctx, String msg, @Nullable Throwable t) {
        if (!log.isLoggable(level)) {
            return;
        }
        SslHandler sslHandler = (SslHandler)ctx.pipeline().get(SslHandler.class);
        SSLEngine engine = sslHandler.engine();
        StringBuilder builder = new StringBuilder(msg);
        builder.append("\nSSLEngine Details: [\n");
        if (engine instanceof OpenSslEngine) {
            builder.append("    OpenSSL, ");
            builder.append("Version: 0x").append(Integer.toHexString(OpenSsl.version()));
            builder.append(" (").append(OpenSsl.versionString()).append("), ");
            builder.append("ALPN supported: ").append(OpenSsl.isAlpnSupported());
        } else if (JettyTlsUtil.isJettyAlpnConfigured()) {
            builder.append("    Jetty ALPN");
        } else if (JettyTlsUtil.isJettyNpnConfigured()) {
            builder.append("    Jetty NPN");
        } else if (JettyTlsUtil.isJava9AlpnAvailable()) {
            builder.append("    JDK9 ALPN");
        }
        builder.append("\n    TLS Protocol: ");
        builder.append(engine.getSession().getProtocol());
        builder.append("\n    Application Protocol: ");
        builder.append(sslHandler.applicationProtocol());
        builder.append("\n    Need Client Auth: ");
        builder.append(engine.getNeedClientAuth());
        builder.append("\n    Want Client Auth: ");
        builder.append(engine.getWantClientAuth());
        builder.append("\n    Supported protocols=");
        builder.append(Arrays.toString(engine.getSupportedProtocols()));
        builder.append("\n    Enabled protocols=");
        builder.append(Arrays.toString(engine.getEnabledProtocols()));
        builder.append("\n    Supported ciphers=");
        builder.append(Arrays.toString(engine.getSupportedCipherSuites()));
        builder.append("\n    Enabled ciphers=");
        builder.append(Arrays.toString(engine.getEnabledCipherSuites()));
        builder.append("\n]");
        log.log(level, builder.toString(), t);
    }

    static final class WaitUntilActiveHandler
    extends ChannelInboundHandlerAdapter {
        private final ChannelHandler next;
        private ProtocolNegotiationEvent pne = ProtocolNegotiationEvent.DEFAULT;

        public WaitUntilActiveHandler(ChannelHandler next) {
            this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            if (ctx.channel().isActive()) {
                ctx.pipeline().replace(ctx.name(), null, this.next);
                this.fireProtocolNegotiationEvent(ctx);
            }
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            ctx.pipeline().replace(ctx.name(), null, this.next);
            super.channelActive(ctx);
            this.fireProtocolNegotiationEvent(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                this.pne = (ProtocolNegotiationEvent)evt;
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }

        private void fireProtocolNegotiationEvent(ChannelHandlerContext ctx) {
            Attributes attrs = this.pne.getAttributes().toBuilder().set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)ctx.channel().localAddress()).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)ctx.channel().remoteAddress()).set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.NONE).build();
            ctx.fireUserEventTriggered((Object)this.pne.withAttributes(attrs));
        }
    }

    static final class PlaintextProtocolNegotiator
    implements ProtocolNegotiator {
        PlaintextProtocolNegotiator() {
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            GrpcNegotiationHandler grpcNegotiationHandler = new GrpcNegotiationHandler(grpcHandler);
            WaitUntilActiveHandler activeHandler = new WaitUntilActiveHandler((ChannelHandler)grpcNegotiationHandler);
            return activeHandler;
        }

        @Override
        public void close() {
        }

        @Override
        public AsciiString scheme() {
            return Utils.HTTP;
        }
    }

    static final class GrpcNegotiationHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler next;

        public GrpcNegotiationHandler(GrpcHttp2ConnectionHandler next) {
            this.next = (GrpcHttp2ConnectionHandler)((Object)Preconditions.checkNotNull((Object)((Object)next), (Object)"next"));
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                ProtocolNegotiationEvent protocolNegotiationEvent = (ProtocolNegotiationEvent)evt;
                ctx.pipeline().replace(ctx.name(), null, (ChannelHandler)this.next);
                this.next.handleProtocolNegotiationCompleted(protocolNegotiationEvent.getAttributes(), protocolNegotiationEvent.getSecurity());
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }

    public static abstract class AbstractBufferingHandler
    extends ChannelDuplexHandler {
        private ChannelHandler[] handlers;
        private Queue<ChannelWrite> bufferedWrites = new ArrayDeque<ChannelWrite>();
        private boolean writing;
        private boolean flushRequested;
        private Throwable failCause;

        protected AbstractBufferingHandler(ChannelHandler ... handlers) {
            this.handlers = handlers;
        }

        public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
            if (this.handlers != null && this.handlers.length > 0) {
                for (ChannelHandler handler : this.handlers) {
                    ctx.pipeline().addBefore(ctx.name(), null, handler);
                }
                ChannelHandler handler0 = this.handlers[0];
                ChannelHandlerContext handler0Ctx = ctx.pipeline().context(this.handlers[0]);
                this.handlers = null;
                if (handler0Ctx != null) {
                    if (handler0 instanceof ChannelInboundHandler) {
                        ((ChannelInboundHandler)handler0).channelRegistered(handler0Ctx);
                    } else {
                        handler0Ctx.fireChannelRegistered();
                    }
                }
            } else {
                super.channelRegistered(ctx);
            }
        }

        public void connect(final ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (!future.isSuccess()) {
                        AbstractBufferingHandler.this.fail(ctx, future.cause());
                    }
                }
            });
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.fail(ctx, cause);
        }

        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.fail(ctx, ProtocolNegotiators.unavailableException("Connection broken while performing protocol negotiation"));
            super.channelInactive(ctx);
        }

        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
            if (this.failCause != null) {
                promise.setFailure(this.failCause);
                ReferenceCountUtil.release((Object)msg);
            } else if (this.bufferedWrites == null) {
                super.write(ctx, msg, promise);
            } else {
                this.bufferedWrites.add(new ChannelWrite(msg, promise));
            }
        }

        public void flush(ChannelHandlerContext ctx) {
            if (this.bufferedWrites == null) {
                ctx.flush();
            } else {
                this.flushRequested = true;
            }
        }

        public void close(ChannelHandlerContext ctx, ChannelPromise future) throws Exception {
            if (ctx.channel().isActive()) {
                this.fail(ctx, ProtocolNegotiators.unavailableException("Channel closed while performing protocol negotiation"));
            }
            super.close(ctx, future);
        }

        protected final void fail(ChannelHandlerContext ctx, Throwable cause) {
            if (this.failCause == null) {
                this.failCause = cause;
            }
            if (this.bufferedWrites != null) {
                while (!this.bufferedWrites.isEmpty()) {
                    ChannelWrite write = this.bufferedWrites.poll();
                    write.promise.setFailure(cause);
                    ReferenceCountUtil.release((Object)write.msg);
                }
                this.bufferedWrites = null;
            }
            ctx.fireExceptionCaught(cause);
        }

        protected final void writeBufferedAndRemove(ChannelHandlerContext ctx) {
            if (!ctx.channel().isActive() || this.writing) {
                return;
            }
            this.writing = true;
            while (!this.bufferedWrites.isEmpty()) {
                ChannelWrite write = this.bufferedWrites.poll();
                ctx.write(write.msg, write.promise);
            }
            assert (this.bufferedWrites.isEmpty());
            this.bufferedWrites = null;
            if (this.flushRequested) {
                ctx.flush();
            }
            ctx.pipeline().remove((ChannelHandler)this);
        }

        private static class ChannelWrite {
            Object msg;
            ChannelPromise promise;

            ChannelWrite(Object msg, ChannelPromise promise) {
                this.msg = msg;
                this.promise = promise;
            }
        }
    }

    static final class Http2UpgradeAndGrpcHandler
    extends ChannelInboundHandlerAdapter {
        private final String authority;
        private final GrpcHttp2ConnectionHandler next;
        private ProtocolNegotiationEvent pne = ProtocolNegotiationEvent.DEFAULT;

        Http2UpgradeAndGrpcHandler(String authority, GrpcHttp2ConnectionHandler next) {
            this.authority = (String)Preconditions.checkNotNull((Object)authority, (Object)"authority");
            this.next = (GrpcHttp2ConnectionHandler)((Object)Preconditions.checkNotNull((Object)((Object)next), (Object)"next"));
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            HttpClientCodec httpClientCodec = new HttpClientCodec();
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)httpClientCodec);
            Http2ClientUpgradeCodec upgradeCodec = new Http2ClientUpgradeCodec((Http2ConnectionHandler)this.next);
            HttpClientUpgradeHandler upgrader = new HttpClientUpgradeHandler((HttpClientUpgradeHandler.SourceCodec)httpClientCodec, (HttpClientUpgradeHandler.UpgradeCodec)upgradeCodec, 1000);
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)upgrader);
            DefaultHttpRequest upgradeTrigger = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.GET, "/");
            upgradeTrigger.headers().add((CharSequence)HttpHeaderNames.HOST, (Object)this.authority);
            ctx.writeAndFlush((Object)upgradeTrigger).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
            super.handlerAdded(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                this.pne = (ProtocolNegotiationEvent)evt;
            } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_SUCCESSFUL) {
                ctx.pipeline().remove(ctx.name());
                this.next.handleProtocolNegotiationCompleted(this.pne.getAttributes(), this.pne.getSecurity());
            } else if (evt == HttpClientUpgradeHandler.UpgradeEvent.UPGRADE_REJECTED) {
                ctx.fireExceptionCaught((Throwable)ProtocolNegotiators.unavailableException("HTTP/2 upgrade rejected"));
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }
    }

    static final class PlaintextUpgradeProtocolNegotiator
    implements ProtocolNegotiator {
        PlaintextUpgradeProtocolNegotiator() {
        }

        @Override
        public AsciiString scheme() {
            return Utils.HTTP;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            Http2UpgradeAndGrpcHandler upgradeHandler = new Http2UpgradeAndGrpcHandler(grpcHandler.getAuthority(), grpcHandler);
            WaitUntilActiveHandler wuah = new WaitUntilActiveHandler((ChannelHandler)upgradeHandler);
            return wuah;
        }

        @Override
        public void close() {
        }
    }

    @VisibleForTesting
    static final class HostPort {
        final String host;
        final int port;

        public HostPort(String host, int port) {
            this.host = host;
            this.port = port;
        }
    }

    static final class ClientTlsHandler
    extends ChannelDuplexHandler {
        private final ChannelHandler next;
        private final SslContext sslContext;
        private final String host;
        private final int port;
        private ProtocolNegotiationEvent pne = ProtocolNegotiationEvent.DEFAULT;

        ClientTlsHandler(ChannelHandler next, SslContext sslContext, String authority) {
            this.next = (ChannelHandler)Preconditions.checkNotNull((Object)next, (Object)"next");
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
            HostPort hostPort = ProtocolNegotiators.parseAuthority(authority);
            this.host = hostPort.host;
            this.port = hostPort.port;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc(), this.host, this.port);
            SSLParameters sslParams = sslEngine.getSSLParameters();
            sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            sslEngine.setSSLParameters(sslParams);
            ctx.pipeline().addBefore(ctx.name(), null, (ChannelHandler)new SslHandler(sslEngine, false));
            super.handlerAdded(ctx);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProtocolNegotiationEvent) {
                this.pne = (ProtocolNegotiationEvent)evt;
            } else if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvent.isSuccess()) {
                    SslHandler handler = (SslHandler)ctx.pipeline().get(SslHandler.class);
                    if (GrpcSslContexts.NEXT_PROTOCOL_VERSIONS.contains(handler.applicationProtocol())) {
                        ProtocolNegotiators.logSslEngineDetails(Level.FINER, ctx, "TLS negotiation succeeded.", null);
                        ctx.pipeline().replace(ctx.name(), null, this.next);
                        this.fireProtocolNegotiationEvent(ctx, handler.engine().getSession());
                    } else {
                        RuntimeException ex = ProtocolNegotiators.unavailableException("Failed ALPN negotiation: Unable to find compatible protocol");
                        ProtocolNegotiators.logSslEngineDetails(Level.FINE, ctx, "TLS negotiation failed.", ex);
                        ctx.fireExceptionCaught((Throwable)ex);
                    }
                } else {
                    ctx.fireExceptionCaught(handshakeEvent.cause());
                }
            } else {
                super.userEventTriggered(ctx, evt);
            }
        }

        private void fireProtocolNegotiationEvent(ChannelHandlerContext ctx, SSLSession session) {
            InternalChannelz.Security security = new InternalChannelz.Security(new InternalChannelz.Tls(session));
            Attributes attrs = this.pne.getAttributes().toBuilder().set(GrpcAttributes.ATTR_SECURITY_LEVEL, (Object)SecurityLevel.PRIVACY_AND_INTEGRITY).set(Grpc.TRANSPORT_ATTR_SSL_SESSION, (Object)session).build();
            ctx.fireUserEventTriggered((Object)this.pne.withAttributes(attrs).withSecurity(security));
        }
    }

    static final class ClientTlsProtocolNegotiator
    implements ProtocolNegotiator {
        private final SslContext sslContext;

        public ClientTlsProtocolNegotiator(SslContext sslContext) {
            this.sslContext = (SslContext)Preconditions.checkNotNull((Object)sslContext, (Object)"sslContext");
        }

        @Override
        public AsciiString scheme() {
            return Utils.HTTPS;
        }

        @Override
        public ChannelHandler newHandler(GrpcHttp2ConnectionHandler grpcHandler) {
            GrpcNegotiationHandler gnh = new GrpcNegotiationHandler(grpcHandler);
            ClientTlsHandler cth = new ClientTlsHandler((ChannelHandler)gnh, this.sslContext, grpcHandler.getAuthority());
            WaitUntilActiveHandler wuah = new WaitUntilActiveHandler((ChannelHandler)cth);
            return wuah;
        }

        @Override
        public void close() {
        }
    }

    static final class BufferUntilProxyTunnelledHandler
    extends AbstractBufferingHandler {
        public BufferUntilProxyTunnelledHandler(ProxyHandler proxyHandler, ChannelHandler handler) {
            super(new ChannelHandler[]{proxyHandler, handler});
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof ProxyConnectionEvent) {
                this.writeBufferedAndRemove(ctx);
            }
            super.userEventTriggered(ctx, evt);
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) throws Exception {
            this.fail(ctx, ProtocolNegotiators.unavailableException("Connection broken while trying to CONNECT through proxy"));
            super.channelInactive(ctx);
        }

        @Override
        public void close(ChannelHandlerContext ctx, ChannelPromise future) throws Exception {
            if (ctx.channel().isActive()) {
                this.fail(ctx, ProtocolNegotiators.unavailableException("Channel closed while trying to CONNECT through proxy"));
            }
            super.close(ctx, future);
        }
    }

    @VisibleForTesting
    static final class ServerTlsHandler
    extends ChannelInboundHandlerAdapter {
        private final GrpcHttp2ConnectionHandler grpcHandler;
        private final SslContext sslContext;

        ServerTlsHandler(SslContext sslContext, GrpcHttp2ConnectionHandler grpcHandler) {
            this.sslContext = sslContext;
            this.grpcHandler = grpcHandler;
        }

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            SSLEngine sslEngine = this.sslContext.newEngine(ctx.alloc());
            ctx.pipeline().addFirst(new ChannelHandler[]{new SslHandler(sslEngine, false)});
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            this.fail(ctx, cause);
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof SslHandshakeCompletionEvent) {
                SslHandshakeCompletionEvent handshakeEvent = (SslHandshakeCompletionEvent)evt;
                if (handshakeEvent.isSuccess()) {
                    if (GrpcSslContexts.NEXT_PROTOCOL_VERSIONS.contains(this.sslHandler(ctx.pipeline()).applicationProtocol())) {
                        SSLSession session = this.sslHandler(ctx.pipeline()).engine().getSession();
                        this.grpcHandler.handleProtocolNegotiationCompleted(Attributes.newBuilder().set(Grpc.TRANSPORT_ATTR_SSL_SESSION, (Object)session).set(Grpc.TRANSPORT_ATTR_REMOTE_ADDR, (Object)ctx.channel().remoteAddress()).set(Grpc.TRANSPORT_ATTR_LOCAL_ADDR, (Object)ctx.channel().localAddress()).build(), new InternalChannelz.Security(new InternalChannelz.Tls(session)));
                        ctx.pipeline().replace((ChannelHandler)this, null, (ChannelHandler)this.grpcHandler);
                    } else {
                        this.fail(ctx, ProtocolNegotiators.unavailableException("Failed protocol negotiation: Unable to find compatible protocol"));
                    }
                } else {
                    this.fail(ctx, handshakeEvent.cause());
                }
            }
            super.userEventTriggered(ctx, evt);
        }

        private SslHandler sslHandler(ChannelPipeline pipeline) {
            return (SslHandler)pipeline.get(SslHandler.class);
        }

        private void fail(ChannelHandlerContext ctx, Throwable exception) {
            ProtocolNegotiators.logSslEngineDetails(Level.FINE, ctx, "TLS negotiation failed for new client.", exception);
            ctx.close();
        }
    }
}

