/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.netty;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.internal.LogId;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import io.grpc.internal.TransportTracer;
import io.grpc.netty.ForcefulCloseCommand;
import io.grpc.netty.NettyHandlerSettings;
import io.grpc.netty.NettyServerHandler;
import io.grpc.netty.ProtocolNegotiator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.logging.Level;
import java.util.logging.Logger;

class NettyServerTransport
implements ServerTransport {
    private static final Logger log = Logger.getLogger(NettyServerTransport.class.getName());
    private static final Logger connectionLog = Logger.getLogger(String.format("%s.connections", NettyServerTransport.class.getName()));
    private static final ImmutableList<String> QUIET_ERRORS = ImmutableList.of((Object)"Connection reset by peer", (Object)"An existing connection was forcibly closed by the remote host");
    private final LogId logId = LogId.allocate((String)this.getClass().getName());
    private final Channel channel;
    private final ProtocolNegotiator protocolNegotiator;
    private final int maxStreams;
    private ServerTransportListener listener;
    private boolean terminated;
    private final int flowControlWindow;
    private final int maxMessageSize;
    private final int maxHeaderListSize;
    private final long keepAliveTimeInNanos;
    private final long keepAliveTimeoutInNanos;
    private final long maxConnectionIdleInNanos;
    private final long maxConnectionAgeInNanos;
    private final long maxConnectionAgeGraceInNanos;
    private final boolean permitKeepAliveWithoutCalls;
    private final long permitKeepAliveTimeInNanos;
    private final List<ServerStreamTracer.Factory> streamTracerFactories;
    private final TransportTracer transportTracer;

    NettyServerTransport(Channel channel, ProtocolNegotiator protocolNegotiator, List<ServerStreamTracer.Factory> streamTracerFactories, int maxStreams, int flowControlWindow, int maxMessageSize, int maxHeaderListSize, long keepAliveTimeInNanos, long keepAliveTimeoutInNanos, long maxConnectionIdleInNanos, long maxConnectionAgeInNanos, long maxConnectionAgeGraceInNanos, boolean permitKeepAliveWithoutCalls, long permitKeepAliveTimeInNanos) {
        this.channel = (Channel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.protocolNegotiator = (ProtocolNegotiator)Preconditions.checkNotNull((Object)protocolNegotiator, (Object)"protocolNegotiator");
        this.streamTracerFactories = (List)Preconditions.checkNotNull(streamTracerFactories, (Object)"streamTracerFactories");
        this.maxStreams = maxStreams;
        this.flowControlWindow = flowControlWindow;
        this.maxMessageSize = maxMessageSize;
        this.maxHeaderListSize = maxHeaderListSize;
        this.keepAliveTimeInNanos = keepAliveTimeInNanos;
        this.keepAliveTimeoutInNanos = keepAliveTimeoutInNanos;
        this.maxConnectionIdleInNanos = maxConnectionIdleInNanos;
        this.maxConnectionAgeInNanos = maxConnectionAgeInNanos;
        this.maxConnectionAgeGraceInNanos = maxConnectionAgeGraceInNanos;
        this.permitKeepAliveWithoutCalls = permitKeepAliveWithoutCalls;
        this.permitKeepAliveTimeInNanos = permitKeepAliveTimeInNanos;
        this.transportTracer = new TransportTracer();
    }

    public void start(ServerTransportListener listener) {
        Preconditions.checkState((this.listener == null ? 1 : 0) != 0, (Object)"Handler already registered");
        this.listener = listener;
        final NettyServerHandler grpcHandler = this.createHandler(listener);
        NettyHandlerSettings.setAutoWindow(grpcHandler);
        this.channel.closeFuture().addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                NettyServerTransport.this.notifyTerminated(grpcHandler.connectionError());
            }
        });
        ProtocolNegotiator.Handler negotiationHandler = this.protocolNegotiator.newHandler(grpcHandler);
        this.channel.pipeline().addLast(new ChannelHandler[]{negotiationHandler});
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.channel.eventLoop();
    }

    public void shutdown() {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
    }

    public void shutdownNow(Status reason) {
        if (this.channel.isOpen()) {
            this.channel.writeAndFlush((Object)new ForcefulCloseCommand(reason));
        }
    }

    public LogId getLogId() {
        return this.logId;
    }

    Channel channel() {
        return this.channel;
    }

    @VisibleForTesting
    static Level getLogLevel(Throwable t) {
        if (t instanceof IOException && t.getMessage() != null) {
            for (String msg : QUIET_ERRORS) {
                if (!t.getMessage().equals(msg)) continue;
                return Level.FINE;
            }
        }
        return Level.INFO;
    }

    private void notifyTerminated(Throwable t) {
        if (t != null) {
            connectionLog.log(NettyServerTransport.getLogLevel(t), "Transport failed", t);
        }
        if (!this.terminated) {
            this.terminated = true;
            this.listener.transportTerminated();
        }
    }

    public Future<TransportTracer.Stats> getTransportStats() {
        if (this.channel.eventLoop().inEventLoop()) {
            SettableFuture result = SettableFuture.create();
            result.set((Object)this.transportTracer.getStats());
            return result;
        }
        return this.channel.eventLoop().submit((Callable)new Callable<TransportTracer.Stats>(){

            @Override
            public TransportTracer.Stats call() throws Exception {
                return NettyServerTransport.this.transportTracer.getStats();
            }
        });
    }

    private NettyServerHandler createHandler(ServerTransportListener transportListener) {
        return NettyServerHandler.newHandler(transportListener, this.streamTracerFactories, this.transportTracer, this.maxStreams, this.flowControlWindow, this.maxHeaderListSize, this.maxMessageSize, this.keepAliveTimeInNanos, this.keepAliveTimeoutInNanos, this.maxConnectionIdleInNanos, this.maxConnectionAgeInNanos, this.maxConnectionAgeGraceInNanos, this.permitKeepAliveWithoutCalls, this.permitKeepAliveTimeInNanos);
    }
}

