/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.squareup.okhttp.CipherSuite;
import com.squareup.okhttp.ConnectionSpec;
import com.squareup.okhttp.TlsVersion;
import io.grpc.Attributes;
import io.grpc.NameResolver;
import io.grpc.internal.AbstractManagedChannelImplBuilder;
import io.grpc.internal.ClientTransportFactory;
import io.grpc.internal.ConnectionClientTransport;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.okhttp.NegotiationType;
import io.grpc.okhttp.OkHttpClientTransport;
import io.grpc.okhttp.Utils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLSocketFactory;

public class OkHttpChannelBuilder
extends AbstractManagedChannelImplBuilder<OkHttpChannelBuilder> {
    public static final ConnectionSpec DEFAULT_CONNECTION_SPEC = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).cipherSuites(new CipherSuite[]{CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, CipherSuite.TLS_DHE_RSA_WITH_AES_256_GCM_SHA384, CipherSuite.TLS_DHE_DSS_WITH_AES_256_GCM_SHA384}).tlsVersions(new TlsVersion[]{TlsVersion.TLS_1_2}).supportsTlsExtensions(true).build();
    private static final SharedResourceHolder.Resource<ExecutorService> SHARED_EXECUTOR = new SharedResourceHolder.Resource<ExecutorService>(){

        public ExecutorService create() {
            return Executors.newCachedThreadPool(new ThreadFactoryBuilder().setDaemon(true).setNameFormat("grpc-okhttp-%d").build());
        }

        public void close(ExecutorService executor) {
            executor.shutdown();
        }
    };
    private Executor transportExecutor;
    private SSLSocketFactory sslSocketFactory;
    private ConnectionSpec connectionSpec = DEFAULT_CONNECTION_SPEC;
    private NegotiationType negotiationType = NegotiationType.TLS;
    private int maxMessageSize = 0x400000;
    private boolean enableKeepAlive;
    private long keepAliveDelayNanos;
    private long keepAliveTimeoutNanos;

    public static OkHttpChannelBuilder forAddress(String host, int port) {
        return new OkHttpChannelBuilder(host, port);
    }

    public static OkHttpChannelBuilder forTarget(String target) {
        return new OkHttpChannelBuilder(target);
    }

    protected OkHttpChannelBuilder(String host, int port) {
        this(GrpcUtil.authorityFromHostAndPort((String)host, (int)port));
    }

    private OkHttpChannelBuilder(String target) {
        super(target);
    }

    public final OkHttpChannelBuilder transportExecutor(@Nullable Executor transportExecutor) {
        this.transportExecutor = transportExecutor;
        return this;
    }

    public final OkHttpChannelBuilder negotiationType(NegotiationType type) {
        this.negotiationType = (NegotiationType)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        return this;
    }

    public final OkHttpChannelBuilder enableKeepAlive(boolean enable) {
        this.enableKeepAlive = enable;
        if (enable) {
            this.keepAliveDelayNanos = GrpcUtil.DEFAULT_KEEPALIVE_DELAY_NANOS;
            this.keepAliveTimeoutNanos = GrpcUtil.DEFAULT_KEEPALIVE_TIMEOUT_NANOS;
        }
        return this;
    }

    public final OkHttpChannelBuilder enableKeepAlive(boolean enable, long keepAliveDelay, TimeUnit delayUnit, long keepAliveTimeout, TimeUnit timeoutUnit) {
        this.enableKeepAlive = enable;
        if (enable) {
            this.keepAliveDelayNanos = delayUnit.toNanos(keepAliveDelay);
            this.keepAliveTimeoutNanos = timeoutUnit.toNanos(keepAliveTimeout);
        }
        return this;
    }

    public final OkHttpChannelBuilder sslSocketFactory(SSLSocketFactory factory) {
        this.sslSocketFactory = factory;
        this.negotiationType(NegotiationType.TLS);
        return this;
    }

    public final OkHttpChannelBuilder connectionSpec(ConnectionSpec connectionSpec) {
        Preconditions.checkArgument((boolean)connectionSpec.isTls(), (Object)"plaintext ConnectionSpec is not accepted");
        this.connectionSpec = connectionSpec;
        return this;
    }

    public final OkHttpChannelBuilder maxMessageSize(int maxMessageSize) {
        Preconditions.checkArgument((maxMessageSize >= 0 ? 1 : 0) != 0, (Object)"maxMessageSize must be >= 0");
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public final OkHttpChannelBuilder usePlaintext(boolean skipNegotiation) {
        if (!skipNegotiation) {
            throw new IllegalArgumentException("Plaintext negotiation not currently supported");
        }
        this.negotiationType(NegotiationType.PLAINTEXT);
        return this;
    }

    protected final ClientTransportFactory buildTransportFactory() {
        return new OkHttpTransportFactory(this.transportExecutor, this.createSocketFactory(), this.connectionSpec, this.maxMessageSize, this.enableKeepAlive, this.keepAliveDelayNanos, this.keepAliveTimeoutNanos);
    }

    protected Attributes getNameResolverParams() {
        int defaultPort;
        switch (this.negotiationType) {
            case PLAINTEXT: {
                defaultPort = 80;
                break;
            }
            case TLS: {
                defaultPort = 443;
                break;
            }
            default: {
                throw new AssertionError((Object)((Object)((Object)this.negotiationType) + " not handled"));
            }
        }
        return Attributes.newBuilder().set(NameResolver.Factory.PARAMS_DEFAULT_PORT, (Object)defaultPort).build();
    }

    @Nullable
    @VisibleForTesting
    SSLSocketFactory createSocketFactory() {
        switch (this.negotiationType) {
            case TLS: {
                return this.sslSocketFactory == null ? (SSLSocketFactory)SSLSocketFactory.getDefault() : this.sslSocketFactory;
            }
            case PLAINTEXT: {
                return null;
            }
        }
        throw new RuntimeException("Unknown negotiation type: " + (Object)((Object)this.negotiationType));
    }

    static final class OkHttpTransportFactory
    implements ClientTransportFactory {
        private final Executor executor;
        private final boolean usingSharedExecutor;
        @Nullable
        private final SSLSocketFactory socketFactory;
        private final ConnectionSpec connectionSpec;
        private final int maxMessageSize;
        private boolean enableKeepAlive;
        private long keepAliveDelayNanos;
        private long keepAliveTimeoutNanos;
        private boolean closed;

        private OkHttpTransportFactory(Executor executor, @Nullable SSLSocketFactory socketFactory, ConnectionSpec connectionSpec, int maxMessageSize, boolean enableKeepAlive, long keepAliveDelayNanos, long keepAliveTimeoutNanos) {
            this.socketFactory = socketFactory;
            this.connectionSpec = connectionSpec;
            this.maxMessageSize = maxMessageSize;
            this.enableKeepAlive = enableKeepAlive;
            this.keepAliveDelayNanos = keepAliveDelayNanos;
            this.keepAliveTimeoutNanos = keepAliveTimeoutNanos;
            this.usingSharedExecutor = executor == null;
            this.executor = this.usingSharedExecutor ? (Executor)SharedResourceHolder.get((SharedResourceHolder.Resource)SHARED_EXECUTOR) : executor;
        }

        public ConnectionClientTransport newClientTransport(SocketAddress addr, String authority, @Nullable String userAgent) {
            if (this.closed) {
                throw new IllegalStateException("The transport factory is closed.");
            }
            InetSocketAddress inetSocketAddr = (InetSocketAddress)addr;
            OkHttpClientTransport transport = new OkHttpClientTransport(inetSocketAddr, authority, userAgent, this.executor, this.socketFactory, Utils.convertSpec(this.connectionSpec), this.maxMessageSize);
            if (this.enableKeepAlive) {
                transport.enableKeepAlive(true, this.keepAliveDelayNanos, this.keepAliveTimeoutNanos);
            }
            return transport;
        }

        public void close() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (this.usingSharedExecutor) {
                SharedResourceHolder.release((SharedResourceHolder.Resource)SHARED_EXECUTOR, (Object)((ExecutorService)this.executor));
            }
        }
    }
}

