/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.okhttp;

import io.grpc.internal.WritableBuffer;
import okio.Buffer;

class OkHttpWritableBuffer
implements WritableBuffer {
    private final Buffer buffer;
    private int writableBytes;
    private int readableBytes;

    OkHttpWritableBuffer(Buffer buffer, int capacity) {
        this.buffer = buffer;
        this.writableBytes = capacity;
    }

    public void write(byte[] src, int srcIndex, int length) {
        this.buffer.write(src, srcIndex, length);
        this.writableBytes -= length;
        this.readableBytes += length;
    }

    public void write(byte b) {
        this.buffer.writeByte((int)b);
        --this.writableBytes;
        ++this.readableBytes;
    }

    public int writableBytes() {
        return this.writableBytes;
    }

    public int readableBytes() {
        return this.readableBytes;
    }

    public void release() {
    }

    Buffer buffer() {
        return this.buffer;
    }
}

