/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.opentelemetry;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableSet;
import io.grpc.CallOptions;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.ClientInterceptor;
import io.grpc.ClientStreamTracer;
import io.grpc.Deadline;
import io.grpc.ForwardingClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.opentelemetry.OpenTelemetryMetricsResource;
import io.grpc.opentelemetry.internal.OpenTelemetryConstants;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

final class OpenTelemetryMetricsModule {
    private static final Logger logger = Logger.getLogger(OpenTelemetryMetricsModule.class.getName());
    private static final String LOCALITY_LABEL_NAME = "grpc.lb.locality";
    public static final ImmutableSet<String> DEFAULT_PER_CALL_METRICS_SET = ImmutableSet.of((Object)"grpc.client.attempt.started", (Object)"grpc.client.attempt.duration", (Object)"grpc.client.attempt.sent_total_compressed_message_size", (Object)"grpc.client.attempt.rcvd_total_compressed_message_size", (Object)"grpc.client.call.duration", (Object)"grpc.server.call.started", (Object[])new String[]{"grpc.server.call.duration", "grpc.server.call.sent_total_compressed_message_size", "grpc.server.call.rcvd_total_compressed_message_size"});
    private static final double SECONDS_PER_NANO = 1.0E-9;
    private final OpenTelemetryMetricsResource resource;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final boolean localityEnabled;

    OpenTelemetryMetricsModule(Supplier<Stopwatch> stopwatchSupplier, OpenTelemetryMetricsResource resource, Collection<String> optionalLabels) {
        this.resource = (OpenTelemetryMetricsResource)Preconditions.checkNotNull((Object)resource, (Object)"resource");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        this.localityEnabled = optionalLabels.contains(LOCALITY_LABEL_NAME);
    }

    ServerStreamTracer.Factory getServerTracerFactory() {
        return new ServerTracerFactory();
    }

    ClientInterceptor getClientInterceptor(String target) {
        return new MetricsClientInterceptor(target);
    }

    static String recordMethodName(String fullMethodName, boolean isGeneratedMethod) {
        return isGeneratedMethod ? fullMethodName : "other";
    }

    @VisibleForTesting
    final class MetricsClientInterceptor
    implements ClientInterceptor {
        private final String target;

        MetricsClientInterceptor(String target) {
            this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
        }

        public <ReqT, RespT> ClientCall<ReqT, RespT> interceptCall(MethodDescriptor<ReqT, RespT> method, CallOptions callOptions, Channel next) {
            final CallAttemptsTracerFactory tracerFactory = new CallAttemptsTracerFactory(OpenTelemetryMetricsModule.this, this.target, OpenTelemetryMetricsModule.recordMethodName(method.getFullMethodName(), method.isSampledToLocalTracing()));
            ClientCall call = next.newCall(method, callOptions.withStreamTracerFactory((ClientStreamTracer.Factory)tracerFactory));
            return new ForwardingClientCall.SimpleForwardingClientCall<ReqT, RespT>(call){

                public void start(ClientCall.Listener<RespT> responseListener, Metadata headers) {
                    this.delegate().start((ClientCall.Listener)new ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT>(responseListener){

                        public void onClose(Status status, Metadata trailers) {
                            tracerFactory.callEnded(status);
                            super.onClose(status, trailers);
                        }
                    }, headers);
                }
            };
        }
    }

    @VisibleForTesting
    final class ServerTracerFactory
    extends ServerStreamTracer.Factory {
        ServerTracerFactory() {
        }

        public ServerStreamTracer newServerStreamTracer(String fullMethodName, Metadata headers) {
            return new ServerTracer(OpenTelemetryMetricsModule.this, fullMethodName);
        }
    }

    private static final class ServerTracer
    extends ServerStreamTracer {
        @Nullable
        private static final AtomicIntegerFieldUpdater<ServerTracer> streamClosedUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ServerTracer> outboundWireSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ServerTracer> inboundWireSizeUpdater;
        private final OpenTelemetryMetricsModule module;
        private final String fullMethodName;
        private volatile boolean isGeneratedMethod;
        private volatile int streamClosed;
        private final Stopwatch stopwatch;
        private volatile long outboundWireSize;
        private volatile long inboundWireSize;

        ServerTracer(OpenTelemetryMetricsModule module, String fullMethodName) {
            this.module = (OpenTelemetryMetricsModule)Preconditions.checkNotNull((Object)module, (Object)"module");
            this.fullMethodName = fullMethodName;
            this.stopwatch = ((Stopwatch)module.stopwatchSupplier.get()).start();
        }

        public void serverCallStarted(ServerStreamTracer.ServerCallInfo<?, ?> callInfo) {
            boolean isSampledToLocalTracing;
            this.isGeneratedMethod = isSampledToLocalTracing = callInfo.getMethodDescriptor().isSampledToLocalTracing();
            Attributes attribute = Attributes.of(OpenTelemetryConstants.METHOD_KEY, (Object)OpenTelemetryMetricsModule.recordMethodName(this.fullMethodName, isSampledToLocalTracing));
            if (this.module.resource.serverCallCountCounter() != null) {
                this.module.resource.serverCallCountCounter().add(1L, attribute);
            }
        }

        public void outboundWireSize(long bytes) {
            if (outboundWireSizeUpdater != null) {
                outboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.outboundWireSize += bytes;
            }
        }

        public void inboundWireSize(long bytes) {
            if (inboundWireSizeUpdater != null) {
                inboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.inboundWireSize += bytes;
            }
        }

        public void streamClosed(Status status) {
            if (streamClosedUpdater != null) {
                if (streamClosedUpdater.getAndSet(this, 1) != 0) {
                    return;
                }
            } else {
                if (this.streamClosed != 0) {
                    return;
                }
                this.streamClosed = 1;
            }
            this.stopwatch.stop();
            long elapsedTimeNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            Attributes attributes = Attributes.of(OpenTelemetryConstants.METHOD_KEY, (Object)OpenTelemetryMetricsModule.recordMethodName(this.fullMethodName, this.isGeneratedMethod), OpenTelemetryConstants.STATUS_KEY, (Object)status.getCode().toString());
            if (this.module.resource.serverCallDurationCounter() != null) {
                this.module.resource.serverCallDurationCounter().record((double)elapsedTimeNanos * 1.0E-9, attributes);
            }
            if (this.module.resource.serverTotalSentCompressedMessageSizeCounter() != null) {
                this.module.resource.serverTotalSentCompressedMessageSizeCounter().record(this.outboundWireSize, attributes);
            }
            if (this.module.resource.serverTotalReceivedCompressedMessageSizeCounter() != null) {
                this.module.resource.serverTotalReceivedCompressedMessageSizeCounter().record(this.inboundWireSize, attributes);
            }
        }

        static {
            AtomicLongFieldUpdater<ServerTracer> tmpInboundWireSizeUpdater;
            AtomicLongFieldUpdater<ServerTracer> tmpOutboundWireSizeUpdater;
            AtomicIntegerFieldUpdater<ServerTracer> tmpStreamClosedUpdater;
            try {
                tmpStreamClosedUpdater = AtomicIntegerFieldUpdater.newUpdater(ServerTracer.class, "streamClosed");
                tmpOutboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "outboundWireSize");
                tmpInboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ServerTracer.class, "inboundWireSize");
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
                tmpStreamClosedUpdater = null;
                tmpOutboundWireSizeUpdater = null;
                tmpInboundWireSizeUpdater = null;
            }
            streamClosedUpdater = tmpStreamClosedUpdater;
            outboundWireSizeUpdater = tmpOutboundWireSizeUpdater;
            inboundWireSizeUpdater = tmpInboundWireSizeUpdater;
        }
    }

    @VisibleForTesting
    static final class CallAttemptsTracerFactory
    extends ClientStreamTracer.Factory {
        private final OpenTelemetryMetricsModule module;
        private final String target;
        private final Stopwatch attemptStopwatch;
        private final Stopwatch callStopWatch;
        @GuardedBy(value="lock")
        private boolean callEnded;
        private final String fullMethodName;
        private Status status;
        private long callLatencyNanos;
        private final Object lock = new Object();
        private final AtomicLong attemptsPerCall = new AtomicLong();
        @GuardedBy(value="lock")
        private int activeStreams;
        @GuardedBy(value="lock")
        private boolean finishedCallToBeRecorded;

        CallAttemptsTracerFactory(OpenTelemetryMetricsModule module, String target, String fullMethodName) {
            this.module = (OpenTelemetryMetricsModule)Preconditions.checkNotNull((Object)module, (Object)"module");
            this.target = (String)Preconditions.checkNotNull((Object)target, (Object)"target");
            this.fullMethodName = (String)Preconditions.checkNotNull((Object)fullMethodName, (Object)"fullMethodName");
            this.attemptStopwatch = (Stopwatch)module.stopwatchSupplier.get();
            this.callStopWatch = ((Stopwatch)module.stopwatchSupplier.get()).start();
            Attributes attribute = Attributes.of(OpenTelemetryConstants.METHOD_KEY, (Object)fullMethodName, OpenTelemetryConstants.TARGET_KEY, (Object)target);
            if (module.resource.clientAttemptCountCounter() != null) {
                module.resource.clientAttemptCountCounter().add(1L, attribute);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ClientStreamTracer newClientStreamTracer(ClientStreamTracer.StreamInfo info, Metadata metadata) {
            Object object = this.lock;
            synchronized (object) {
                if (this.finishedCallToBeRecorded) {
                    return new ClientStreamTracer(){};
                }
                if (++this.activeStreams == 1 && this.attemptStopwatch.isRunning()) {
                    this.attemptStopwatch.stop();
                }
            }
            if (this.attemptsPerCall.get() > 0L) {
                Attributes attribute = Attributes.of(OpenTelemetryConstants.METHOD_KEY, (Object)this.fullMethodName, OpenTelemetryConstants.TARGET_KEY, (Object)this.target);
                if (this.module.resource.clientAttemptCountCounter() != null) {
                    this.module.resource.clientAttemptCountCounter().add(1L, attribute);
                }
            }
            if (!info.isTransparentRetry()) {
                this.attemptsPerCall.incrementAndGet();
            }
            return new ClientTracer(this, this.module, info, this.target, this.fullMethodName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void attemptEnded() {
            boolean shouldRecordFinishedCall = false;
            Object object = this.lock;
            synchronized (object) {
                if (--this.activeStreams == 0) {
                    this.attemptStopwatch.start();
                    if (this.callEnded && !this.finishedCallToBeRecorded) {
                        shouldRecordFinishedCall = true;
                        this.finishedCallToBeRecorded = true;
                    }
                }
            }
            if (shouldRecordFinishedCall) {
                this.recordFinishedCall();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void callEnded(Status status) {
            this.callStopWatch.stop();
            this.status = status;
            boolean shouldRecordFinishedCall = false;
            Object object = this.lock;
            synchronized (object) {
                if (this.callEnded) {
                    return;
                }
                this.callEnded = true;
                if (this.activeStreams == 0 && !this.finishedCallToBeRecorded) {
                    shouldRecordFinishedCall = true;
                    this.finishedCallToBeRecorded = true;
                }
            }
            if (shouldRecordFinishedCall) {
                this.recordFinishedCall();
            }
        }

        void recordFinishedCall() {
            if (this.attemptsPerCall.get() == 0L) {
                ClientTracer tracer = new ClientTracer(this, this.module, null, this.target, this.fullMethodName);
                tracer.attemptNanos = this.attemptStopwatch.elapsed(TimeUnit.NANOSECONDS);
                tracer.statusCode = this.status.getCode();
                tracer.recordFinishedAttempt();
            }
            this.callLatencyNanos = this.callStopWatch.elapsed(TimeUnit.NANOSECONDS);
            Attributes attribute = Attributes.of(OpenTelemetryConstants.METHOD_KEY, (Object)this.fullMethodName, OpenTelemetryConstants.TARGET_KEY, (Object)this.target, OpenTelemetryConstants.STATUS_KEY, (Object)this.status.getCode().toString());
            if (this.module.resource.clientCallDurationCounter() != null) {
                this.module.resource.clientCallDurationCounter().record((double)this.callLatencyNanos * 1.0E-9, attribute);
            }
        }
    }

    private static final class ClientTracer
    extends ClientStreamTracer {
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> outboundWireSizeUpdater;
        @Nullable
        private static final AtomicLongFieldUpdater<ClientTracer> inboundWireSizeUpdater;
        final Stopwatch stopwatch;
        final CallAttemptsTracerFactory attemptsState;
        final OpenTelemetryMetricsModule module;
        final ClientStreamTracer.StreamInfo info;
        final String target;
        final String fullMethodName;
        volatile long outboundWireSize;
        volatile long inboundWireSize;
        volatile String locality;
        long attemptNanos;
        Status.Code statusCode;

        ClientTracer(CallAttemptsTracerFactory attemptsState, OpenTelemetryMetricsModule module, ClientStreamTracer.StreamInfo info, String target, String fullMethodName) {
            this.attemptsState = attemptsState;
            this.module = module;
            this.info = info;
            this.target = target;
            this.fullMethodName = fullMethodName;
            this.stopwatch = ((Stopwatch)module.stopwatchSupplier.get()).start();
        }

        public void outboundWireSize(long bytes) {
            if (outboundWireSizeUpdater != null) {
                outboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.outboundWireSize += bytes;
            }
        }

        public void inboundWireSize(long bytes) {
            if (inboundWireSizeUpdater != null) {
                inboundWireSizeUpdater.getAndAdd(this, bytes);
            } else {
                this.inboundWireSize += bytes;
            }
        }

        public void addOptionalLabel(String key, String value) {
            if (OpenTelemetryMetricsModule.LOCALITY_LABEL_NAME.equals(key)) {
                this.locality = value;
            }
        }

        public void streamClosed(Status status) {
            this.stopwatch.stop();
            this.attemptNanos = this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            Deadline deadline = this.info.getCallOptions().getDeadline();
            this.statusCode = status.getCode();
            if (this.statusCode == Status.Code.CANCELLED && deadline != null && deadline.isExpired()) {
                this.statusCode = Status.Code.DEADLINE_EXCEEDED;
            }
            this.attemptsState.attemptEnded();
            this.recordFinishedAttempt();
        }

        void recordFinishedAttempt() {
            AttributesBuilder builder = Attributes.builder().put(OpenTelemetryConstants.METHOD_KEY, (Object)this.fullMethodName).put(OpenTelemetryConstants.TARGET_KEY, (Object)this.target).put(OpenTelemetryConstants.STATUS_KEY, (Object)this.statusCode.toString());
            if (this.module.localityEnabled) {
                String savedLocality = this.locality;
                if (savedLocality == null) {
                    savedLocality = "";
                }
                builder.put(OpenTelemetryConstants.LOCALITY_KEY, (Object)savedLocality);
            }
            Attributes attribute = builder.build();
            if (this.module.resource.clientAttemptDurationCounter() != null) {
                this.module.resource.clientAttemptDurationCounter().record((double)this.attemptNanos * 1.0E-9, attribute);
            }
            if (this.module.resource.clientTotalSentCompressedMessageSizeCounter() != null) {
                this.module.resource.clientTotalSentCompressedMessageSizeCounter().record(this.outboundWireSize, attribute);
            }
            if (this.module.resource.clientTotalReceivedCompressedMessageSizeCounter() != null) {
                this.module.resource.clientTotalReceivedCompressedMessageSizeCounter().record(this.inboundWireSize, attribute);
            }
        }

        static {
            AtomicLongFieldUpdater<ClientTracer> tmpInboundWireSizeUpdater;
            AtomicLongFieldUpdater<ClientTracer> tmpOutboundWireSizeUpdater;
            try {
                tmpOutboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "outboundWireSize");
                tmpInboundWireSizeUpdater = AtomicLongFieldUpdater.newUpdater(ClientTracer.class, "inboundWireSize");
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Creating atomic field updaters failed", t);
                tmpOutboundWireSizeUpdater = null;
                tmpInboundWireSizeUpdater = null;
            }
            outboundWireSizeUpdater = tmpOutboundWireSizeUpdater;
            inboundWireSizeUpdater = tmpInboundWireSizeUpdater;
        }
    }
}

