/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import io.grpc.internal.JsonUtil;
import io.grpc.lookup.v1.RouteLookupRequest;
import io.grpc.lookup.v1.RouteLookupResponse;
import io.grpc.rls.RlsProtoData;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class RlsProtoConverters {
    private RlsProtoConverters() {
    }

    private static final class GrpcKeyBuilderConverter {
        private GrpcKeyBuilderConverter() {
        }

        public static List<RlsProtoData.GrpcKeyBuilder> covertAll(List<Map<String, ?>> keyBuilders) {
            ArrayList<RlsProtoData.GrpcKeyBuilder> keyBuilderList = new ArrayList<RlsProtoData.GrpcKeyBuilder>();
            for (Map<String, ?> keyBuilder : keyBuilders) {
                keyBuilderList.add(GrpcKeyBuilderConverter.convert(keyBuilder));
            }
            return keyBuilderList;
        }

        static RlsProtoData.GrpcKeyBuilder convert(Map<String, ?> keyBuilder) {
            List rawNames = JsonUtil.checkObjectList((List)JsonUtil.getList(keyBuilder, (String)"names"));
            ArrayList<RlsProtoData.GrpcKeyBuilder.Name> names = new ArrayList<RlsProtoData.GrpcKeyBuilder.Name>();
            for (Map rawName : rawNames) {
                names.add(new RlsProtoData.GrpcKeyBuilder.Name(JsonUtil.getString((Map)rawName, (String)"service"), JsonUtil.getString((Map)rawName, (String)"method")));
            }
            List rawHeaders = JsonUtil.checkObjectList((List)JsonUtil.getList(keyBuilder, (String)"headers"));
            ArrayList<RlsProtoData.NameMatcher> nameMatchers = new ArrayList<RlsProtoData.NameMatcher>();
            for (Map rawHeader : rawHeaders) {
                RlsProtoData.NameMatcher matcher = new RlsProtoData.NameMatcher(JsonUtil.getString((Map)rawHeader, (String)"key"), (List)rawHeader.get("names"), (Boolean)rawHeader.get("optional"));
                Preconditions.checkArgument((boolean)matcher.isOptional(), (Object)"NameMatcher for GrpcKeyBuilders shouldn't be required");
                nameMatchers.add(matcher);
            }
            return new RlsProtoData.GrpcKeyBuilder(names, nameMatchers);
        }
    }

    static final class RouteLookupConfigConverter
    extends Converter<Map<String, ?>, RlsProtoData.RouteLookupConfig> {
        RouteLookupConfigConverter() {
        }

        protected RlsProtoData.RouteLookupConfig doForward(Map<String, ?> json) {
            List<RlsProtoData.GrpcKeyBuilder> grpcKeyBuilders = GrpcKeyBuilderConverter.covertAll(JsonUtil.checkObjectList((List)JsonUtil.getList(json, (String)"grpcKeyBuilders")));
            String lookupService = JsonUtil.getString(json, (String)"lookupService");
            long timeout = TimeUnit.SECONDS.toMillis(RouteLookupConfigConverter.orDefault(JsonUtil.getNumberAsLong(json, (String)"lookupServiceTimeout"), 0L));
            Long maxAge = RouteLookupConfigConverter.convertTimeIfNotNull(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, JsonUtil.getNumberAsLong(json, (String)"maxAge"));
            Long staleAge = RouteLookupConfigConverter.convertTimeIfNotNull(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, JsonUtil.getNumberAsLong(json, (String)"staleAge"));
            long cacheSize = RouteLookupConfigConverter.orDefault(JsonUtil.getNumberAsLong(json, (String)"cacheSizeBytes"), Long.MAX_VALUE);
            List validTargets = JsonUtil.checkStringList((List)JsonUtil.getList(json, (String)"validTargets"));
            String defaultTarget = JsonUtil.getString(json, (String)"defaultTarget");
            return new RlsProtoData.RouteLookupConfig(grpcKeyBuilders, lookupService, timeout, maxAge, staleAge, cacheSize, validTargets, defaultTarget);
        }

        private static <T> T orDefault(@Nullable T value, T defaultValue) {
            if (value == null) {
                return (T)Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
            }
            return value;
        }

        private static Long convertTimeIfNotNull(TimeUnit from, TimeUnit to, Long value) {
            if (value == null) {
                return null;
            }
            return to.convert(value, from);
        }

        protected Map<String, Object> doBackward(RlsProtoData.RouteLookupConfig routeLookupConfig) {
            throw new UnsupportedOperationException();
        }
    }

    static final class RouteLookupResponseConverter
    extends Converter<RouteLookupResponse, RlsProtoData.RouteLookupResponse> {
        RouteLookupResponseConverter() {
        }

        protected RlsProtoData.RouteLookupResponse doForward(RouteLookupResponse routeLookupResponse) {
            return new RlsProtoData.RouteLookupResponse((List<String>)routeLookupResponse.getTargetsList(), routeLookupResponse.getHeaderData());
        }

        protected RouteLookupResponse doBackward(RlsProtoData.RouteLookupResponse routeLookupResponse) {
            return RouteLookupResponse.newBuilder().addAllTargets((Iterable<String>)routeLookupResponse.getTargets()).setHeaderData(routeLookupResponse.getHeaderData()).build();
        }
    }

    static final class RouteLookupRequestConverter
    extends Converter<RouteLookupRequest, RlsProtoData.RouteLookupRequest> {
        RouteLookupRequestConverter() {
        }

        protected RlsProtoData.RouteLookupRequest doForward(RouteLookupRequest routeLookupRequest) {
            return new RlsProtoData.RouteLookupRequest(routeLookupRequest.getServer(), routeLookupRequest.getPath(), routeLookupRequest.getTargetType(), routeLookupRequest.getKeyMapMap());
        }

        protected RouteLookupRequest doBackward(RlsProtoData.RouteLookupRequest routeLookupRequest) {
            return RouteLookupRequest.newBuilder().setServer(routeLookupRequest.getServer()).setPath(routeLookupRequest.getPath()).setTargetType(routeLookupRequest.getTargetType()).putAllKeyMap((Map<String, String>)routeLookupRequest.getKeyMap()).build();
        }
    }
}

