/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Converter;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Channel;
import io.grpc.ChannelLogger;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Metadata;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.TimeProvider;
import io.grpc.lookup.v1.RouteLookupRequest;
import io.grpc.lookup.v1.RouteLookupResponse;
import io.grpc.lookup.v1.RouteLookupServiceGrpc;
import io.grpc.rls.ChildLoadBalancerHelper;
import io.grpc.rls.LbPolicyConfiguration;
import io.grpc.rls.LinkedHashLruCache;
import io.grpc.rls.LruCache;
import io.grpc.rls.ResolvedAddressFactory;
import io.grpc.rls.RlsProtoConverters;
import io.grpc.rls.RlsProtoData;
import io.grpc.rls.RlsRequestFactory;
import io.grpc.rls.SubchannelStateManagerImpl;
import io.grpc.rls.Throttler;
import io.grpc.stub.StreamObserver;
import io.grpc.util.ForwardingLoadBalancerHelper;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class CachingRlsLbClient {
    private static final Converter<RlsProtoData.RouteLookupRequest, RouteLookupRequest> REQUEST_CONVERTER = new RlsProtoConverters.RouteLookupRequestConverter().reverse();
    private static final Converter<RlsProtoData.RouteLookupResponse, RouteLookupResponse> RESPONSE_CONVERTER = new RlsProtoConverters.RouteLookupResponseConverter().reverse();
    private static final String RLS_ENABLE_OOB_CHANNEL_DIRECTPATH_PROPERTY = "io.grpc.rls.CachingRlsLbClient.enable_oobchannel_directpath";
    @VisibleForTesting
    static boolean enableOobChannelDirectPath = Boolean.parseBoolean(System.getProperty("io.grpc.rls.CachingRlsLbClient.enable_oobchannel_directpath", "false"));
    private final Object lock = new Object();
    @GuardedBy(value="lock")
    private final LinkedHashLruCache<RlsProtoData.RouteLookupRequest, CacheEntry> linkedHashLruCache;
    @GuardedBy(value="lock")
    private final Map<RlsProtoData.RouteLookupRequest, PendingCacheEntry> pendingCallCache = new HashMap<RlsProtoData.RouteLookupRequest, PendingCacheEntry>();
    private final SynchronizationContext synchronizationContext;
    private final ScheduledExecutorService scheduledExecutorService;
    private final TimeProvider timeProvider;
    private final Throttler throttler;
    private final LbPolicyConfiguration lbPolicyConfig;
    private final BackoffPolicy.Provider backoffProvider;
    private final long maxAgeNanos;
    private final long staleAgeNanos;
    private final long callTimeoutNanos;
    private final RlsLbHelper helper;
    private final ManagedChannel rlsChannel;
    private final RouteLookupServiceGrpc.RouteLookupServiceStub rlsStub;
    private final RlsPicker rlsPicker;
    private final ResolvedAddressFactory childLbResolvedAddressFactory;
    private final LbPolicyConfiguration.RefCountedChildPolicyWrapperFactory refCountedChildPolicyWrapperFactory;
    private final ChannelLogger logger;
    @VisibleForTesting
    static final Metadata.Key<String> RLS_DATA_KEY = Metadata.Key.of((String)"X-Google-RLS-Data", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);

    private CachingRlsLbClient(Builder builder) {
        this.helper = new RlsLbHelper((LoadBalancer.Helper)Preconditions.checkNotNull((Object)builder.helper, (Object)"helper"));
        this.scheduledExecutorService = this.helper.getScheduledExecutorService();
        this.synchronizationContext = this.helper.getSynchronizationContext();
        this.lbPolicyConfig = (LbPolicyConfiguration)Preconditions.checkNotNull((Object)builder.lbPolicyConfig, (Object)"lbPolicyConfig");
        RlsProtoData.RouteLookupConfig rlsConfig = this.lbPolicyConfig.getRouteLookupConfig();
        this.maxAgeNanos = rlsConfig.getMaxAgeInNanos();
        this.staleAgeNanos = rlsConfig.getStaleAgeInNanos();
        this.callTimeoutNanos = rlsConfig.getLookupServiceTimeoutInNanos();
        this.timeProvider = (TimeProvider)Preconditions.checkNotNull((Object)builder.timeProvider, (Object)"timeProvider");
        this.throttler = (Throttler)Preconditions.checkNotNull((Object)builder.throttler, (Object)"throttler");
        this.linkedHashLruCache = new RlsAsyncLruCache(rlsConfig.getCacheSizeBytes(), builder.evictionListener, this.scheduledExecutorService, this.timeProvider);
        this.logger = this.helper.getChannelLogger();
        String serverHost = null;
        try {
            serverHost = new URI(null, this.helper.getAuthority(), null, null, null).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        if (serverHost == null) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Can not get hostname from authority: {0}", new Object[]{this.helper.getAuthority()});
            serverHost = this.helper.getAuthority();
        }
        RlsRequestFactory requestFactory = new RlsRequestFactory(this.lbPolicyConfig.getRouteLookupConfig(), serverHost);
        this.rlsPicker = new RlsPicker(requestFactory);
        ManagedChannelBuilder rlsChannelBuilder = this.helper.createResolvingOobChannelBuilder(rlsConfig.getLookupService(), this.helper.getUnsafeChannelCredentials());
        rlsChannelBuilder.overrideAuthority(this.helper.getAuthority());
        if (enableOobChannelDirectPath) {
            ImmutableMap<String, Object> directPathServiceConfig = CachingRlsLbClient.getDirectPathServiceConfig(rlsConfig.getLookupService());
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "RLS channel direct path enabled. RLS channel service config: {0}", new Object[]{directPathServiceConfig});
            rlsChannelBuilder.defaultServiceConfig(directPathServiceConfig);
            rlsChannelBuilder.disableServiceConfigLookUp();
        }
        this.rlsChannel = rlsChannelBuilder.build();
        this.helper.updateBalancingState(ConnectivityState.CONNECTING, this.rlsPicker);
        this.rlsStub = RouteLookupServiceGrpc.newStub((Channel)this.rlsChannel);
        this.childLbResolvedAddressFactory = (ResolvedAddressFactory)Preconditions.checkNotNull((Object)builder.resolvedAddressFactory, (Object)"resolvedAddressFactory");
        this.backoffProvider = builder.backoffProvider;
        ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider childLbHelperProvider = new ChildLoadBalancerHelper.ChildLoadBalancerHelperProvider((LoadBalancer.Helper)this.helper, new SubchannelStateManagerImpl(), this.rlsPicker);
        this.refCountedChildPolicyWrapperFactory = new LbPolicyConfiguration.RefCountedChildPolicyWrapperFactory(childLbHelperProvider, new BackoffRefreshListener());
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "CachingRlsLbClient created");
    }

    private static ImmutableMap<String, Object> getDirectPathServiceConfig(String serviceName) {
        ImmutableMap pickFirstStrategy = ImmutableMap.of((Object)"pick_first", (Object)ImmutableMap.of());
        ImmutableMap childPolicy = ImmutableMap.of((Object)"childPolicy", (Object)ImmutableList.of((Object)pickFirstStrategy), (Object)"serviceName", (Object)serviceName);
        ImmutableMap grpcLbPolicy = ImmutableMap.of((Object)"grpclb", (Object)childPolicy);
        return ImmutableMap.of((Object)"loadBalancingConfig", (Object)ImmutableList.of((Object)grpcLbPolicy));
    }

    @CheckReturnValue
    private ListenableFuture<RlsProtoData.RouteLookupResponse> asyncRlsCall(RlsProtoData.RouteLookupRequest request) {
        final SettableFuture response = SettableFuture.create();
        if (this.throttler.shouldThrottle()) {
            this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Request is throttled");
            response.setException((Throwable)new Throttler.ThrottledException());
            return response;
        }
        RouteLookupRequest routeLookupRequest = (RouteLookupRequest)REQUEST_CONVERTER.convert((Object)request);
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Sending RouteLookupRequest: {0}", new Object[]{routeLookupRequest});
        ((RouteLookupServiceGrpc.RouteLookupServiceStub)this.rlsStub.withDeadlineAfter(this.callTimeoutNanos, TimeUnit.NANOSECONDS)).routeLookup(routeLookupRequest, new StreamObserver<RouteLookupResponse>(){

            public void onNext(RouteLookupResponse value) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Received RouteLookupResponse: {0}", new Object[]{value});
                response.set(RESPONSE_CONVERTER.reverse().convert((Object)value));
            }

            public void onError(Throwable t) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Error looking up route:", new Object[]{t});
                response.setException(t);
                CachingRlsLbClient.this.throttler.registerBackendResponse(false);
                CachingRlsLbClient.this.helper.propagateRlsError();
            }

            public void onCompleted() {
                CachingRlsLbClient.this.throttler.registerBackendResponse(true);
            }
        });
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckReturnValue
    final CachedRouteLookupResponse get(RlsProtoData.RouteLookupRequest request) {
        Object object = this.lock;
        synchronized (object) {
            CacheEntry cacheEntry = this.linkedHashLruCache.read(request);
            if (cacheEntry == null) {
                return this.handleNewRequest(request);
            }
            if (cacheEntry instanceof DataCacheEntry) {
                this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Cache hit for the request");
                DataCacheEntry dataEntry = (DataCacheEntry)cacheEntry;
                if (dataEntry.isStaled(this.timeProvider.currentTimeNanos())) {
                    dataEntry.maybeRefresh();
                }
                return CachedRouteLookupResponse.dataEntry((DataCacheEntry)cacheEntry);
            }
            return CachedRouteLookupResponse.backoffEntry((BackoffCacheEntry)cacheEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "CachingRlsLbClient closed");
        Object object = this.lock;
        synchronized (object) {
            this.linkedHashLruCache.close();
            this.pendingCallCache.clear();
            this.rlsChannel.shutdownNow();
            this.rlsPicker.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedRouteLookupResponse handleNewRequest(RlsProtoData.RouteLookupRequest request) {
        Object object = this.lock;
        synchronized (object) {
            PendingCacheEntry pendingEntry = this.pendingCallCache.get(request);
            if (pendingEntry != null) {
                return CachedRouteLookupResponse.pendingResponse(pendingEntry);
            }
            ListenableFuture<RlsProtoData.RouteLookupResponse> asyncCall = this.asyncRlsCall(request);
            if (!asyncCall.isDone()) {
                pendingEntry = new PendingCacheEntry(request, asyncCall);
                this.pendingCallCache.put(request, pendingEntry);
                return CachedRouteLookupResponse.pendingResponse(pendingEntry);
            }
            try {
                RlsProtoData.RouteLookupResponse response = (RlsProtoData.RouteLookupResponse)asyncCall.get();
                DataCacheEntry dataEntry = new DataCacheEntry(request, response);
                this.linkedHashLruCache.cache(request, dataEntry);
                return CachedRouteLookupResponse.dataEntry(dataEntry);
            }
            catch (Exception e) {
                BackoffCacheEntry backoffEntry = new BackoffCacheEntry(request, Status.fromThrowable((Throwable)e), this.backoffProvider.get());
                this.linkedHashLruCache.cache(request, backoffEntry);
                return CachedRouteLookupResponse.backoffEntry(backoffEntry);
            }
        }
    }

    void requestConnection() {
        this.rlsChannel.getState(true);
    }

    static Builder newBuilder() {
        return new Builder();
    }

    final class RlsPicker
    extends LoadBalancer.SubchannelPicker {
        private final RlsRequestFactory requestFactory;
        private LbPolicyConfiguration.ChildPolicyWrapper fallbackChildPolicyWrapper;

        RlsPicker(RlsRequestFactory requestFactory) {
            this.requestFactory = (RlsRequestFactory)Preconditions.checkNotNull((Object)requestFactory, (Object)"requestFactory");
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            String defaultTarget;
            boolean hasFallback;
            String[] methodName = args.getMethodDescriptor().getFullMethodName().split("/", 2);
            RlsProtoData.RouteLookupRequest request = this.requestFactory.create(methodName[0], methodName[1], args.getHeaders());
            CachedRouteLookupResponse response = CachingRlsLbClient.this.get(request);
            CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Got route lookup cache entry for service={0}, method={1}, headers={2}:\n {3}", new Object[]{methodName[0], methodName[1], args.getHeaders(), response});
            if (response.getHeaderData() != null && !response.getHeaderData().isEmpty()) {
                Metadata headers = args.getHeaders();
                headers.discardAll(RLS_DATA_KEY);
                headers.put(RLS_DATA_KEY, (Object)response.getHeaderData());
            }
            boolean bl = hasFallback = (defaultTarget = CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().getDefaultTarget()) != null && !defaultTarget.isEmpty();
            if (response.hasData()) {
                LbPolicyConfiguration.ChildPolicyWrapper childPolicyWrapper = response.getChildPolicyWrapper();
                LoadBalancer.SubchannelPicker picker = childPolicyWrapper.getPicker();
                if (picker == null) {
                    return LoadBalancer.PickResult.withNoResult();
                }
                LoadBalancer.PickResult result = picker.pickSubchannel(args);
                if (result.getStatus().isOk()) {
                    return result;
                }
                if (hasFallback) {
                    return this.useFallback(args);
                }
                return LoadBalancer.PickResult.withError((Status)result.getStatus());
            }
            if (response.hasError()) {
                if (hasFallback) {
                    return this.useFallback(args);
                }
                return LoadBalancer.PickResult.withError((Status)response.getStatus());
            }
            return LoadBalancer.PickResult.withNoResult();
        }

        private LoadBalancer.PickResult useFallback(LoadBalancer.PickSubchannelArgs args) {
            this.startFallbackChildPolicy();
            LoadBalancer.SubchannelPicker picker = this.fallbackChildPolicyWrapper.getPicker();
            if (picker == null) {
                return LoadBalancer.PickResult.withNoResult();
            }
            return picker.pickSubchannel(args);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void startFallbackChildPolicy() {
            String defaultTarget = CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().getDefaultTarget();
            CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "starting fallback to {0}", new Object[]{defaultTarget});
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                if (this.fallbackChildPolicyWrapper != null) {
                    return;
                }
                this.fallbackChildPolicyWrapper = CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.createOrGet(defaultTarget);
            }
            LoadBalancerProvider lbProvider = CachingRlsLbClient.this.lbPolicyConfig.getLoadBalancingPolicy().getEffectiveLbProvider();
            final LoadBalancer lb = lbProvider.newLoadBalancer((LoadBalancer.Helper)this.fallbackChildPolicyWrapper.getHelper());
            final NameResolver.ConfigOrError lbConfig = lbProvider.parseLoadBalancingPolicyConfig(CachingRlsLbClient.this.lbPolicyConfig.getLoadBalancingPolicy().getEffectiveChildPolicy(defaultTarget));
            CachingRlsLbClient.this.helper.getSynchronizationContext().execute(new Runnable(){

                @Override
                public void run() {
                    lb.handleResolvedAddresses(CachingRlsLbClient.this.childLbResolvedAddressFactory.create(lbConfig.getConfig()));
                    lb.requestConnection();
                }
            });
        }

        void close() {
            if (this.fallbackChildPolicyWrapper != null) {
                CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.release(this.fallbackChildPolicyWrapper);
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)((Object)this)).add("target", (Object)CachingRlsLbClient.this.lbPolicyConfig.getRouteLookupConfig().getLookupService()).toString();
        }
    }

    private final class BackoffRefreshListener
    implements LbPolicyConfiguration.ChildLbStatusListener {
        @Nullable
        private ConnectivityState prevState = null;

        private BackoffRefreshListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStatusChanged(ConnectivityState newState) {
            if (this.prevState == ConnectivityState.TRANSIENT_FAILURE && newState == ConnectivityState.READY) {
                Object object = CachingRlsLbClient.this.lock;
                synchronized (object) {
                    for (CacheEntry value : CachingRlsLbClient.this.linkedHashLruCache.values()) {
                        if (!(value instanceof BackoffCacheEntry)) continue;
                        ((BackoffCacheEntry)value).forceRefresh();
                    }
                }
            }
            this.prevState = newState;
        }
    }

    private static final class RlsAsyncLruCache
    extends LinkedHashLruCache<RlsProtoData.RouteLookupRequest, CacheEntry> {
        RlsAsyncLruCache(long maxEstimatedSizeBytes, @Nullable LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> evictionListener, ScheduledExecutorService ses, TimeProvider timeProvider) {
            super(maxEstimatedSizeBytes, new AutoCleaningEvictionListener(evictionListener), 1, TimeUnit.MINUTES, ses, timeProvider);
        }

        @Override
        protected boolean isExpired(RlsProtoData.RouteLookupRequest key, CacheEntry value, long nowNanos) {
            return value.isExpired();
        }

        @Override
        protected int estimateSizeOf(RlsProtoData.RouteLookupRequest key, CacheEntry value) {
            return value.getSizeBytes();
        }

        @Override
        protected boolean shouldInvalidateEldestEntry(RlsProtoData.RouteLookupRequest eldestKey, CacheEntry eldestValue) {
            return true;
        }
    }

    private static final class HappyThrottler
    implements Throttler {
        private HappyThrottler() {
        }

        @Override
        public boolean shouldThrottle() {
            return false;
        }

        @Override
        public void registerBackendResponse(boolean throttled) {
        }
    }

    private static final class AutoCleaningEvictionListener
    implements LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> {
        private final LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> delegate;

        AutoCleaningEvictionListener(@Nullable LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> delegate) {
            this.delegate = delegate;
        }

        @Override
        public void onEviction(RlsProtoData.RouteLookupRequest key, CacheEntry value, LruCache.EvictionType cause) {
            if (this.delegate != null) {
                this.delegate.onEviction(key, value, cause);
            }
            value.cleanup();
        }
    }

    static final class Builder {
        private LoadBalancer.Helper helper;
        private LbPolicyConfiguration lbPolicyConfig;
        private Throttler throttler = new HappyThrottler();
        private ResolvedAddressFactory resolvedAddressFactory;
        private TimeProvider timeProvider = TimeProvider.SYSTEM_TIME_PROVIDER;
        private LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> evictionListener;
        private BackoffPolicy.Provider backoffProvider = new ExponentialBackoffPolicy.Provider();

        Builder() {
        }

        Builder setHelper(LoadBalancer.Helper helper) {
            this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
            return this;
        }

        Builder setLbPolicyConfig(LbPolicyConfiguration lbPolicyConfig) {
            this.lbPolicyConfig = (LbPolicyConfiguration)Preconditions.checkNotNull((Object)lbPolicyConfig, (Object)"lbPolicyConfig");
            return this;
        }

        Builder setThrottler(Throttler throttler) {
            this.throttler = (Throttler)Preconditions.checkNotNull((Object)throttler, (Object)"throttler");
            return this;
        }

        Builder setResolvedAddressesFactory(ResolvedAddressFactory resolvedAddressFactory) {
            this.resolvedAddressFactory = (ResolvedAddressFactory)Preconditions.checkNotNull((Object)resolvedAddressFactory, (Object)"resolvedAddressFactory");
            return this;
        }

        Builder setTimeProvider(TimeProvider timeProvider) {
            this.timeProvider = (TimeProvider)Preconditions.checkNotNull((Object)timeProvider, (Object)"timeProvider");
            return this;
        }

        Builder setEvictionListener(@Nullable LruCache.EvictionListener<RlsProtoData.RouteLookupRequest, CacheEntry> evictionListener) {
            this.evictionListener = evictionListener;
            return this;
        }

        Builder setBackoffProvider(BackoffPolicy.Provider provider) {
            this.backoffProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)provider, (Object)"provider");
            return this;
        }

        CachingRlsLbClient build() {
            return new CachingRlsLbClient(this);
        }
    }

    private final class BackoffCacheEntry
    extends CacheEntry {
        private final Status status;
        private final SynchronizationContext.ScheduledHandle scheduledHandle;
        private final BackoffPolicy backoffPolicy;
        private final long expireNanos;
        private boolean shutdown;

        BackoffCacheEntry(RlsProtoData.RouteLookupRequest request, Status status, BackoffPolicy backoffPolicy) {
            super(request);
            this.shutdown = false;
            this.status = (Status)Preconditions.checkNotNull((Object)status, (Object)"status");
            this.backoffPolicy = (BackoffPolicy)Preconditions.checkNotNull((Object)backoffPolicy, (Object)"backoffPolicy");
            long delayNanos = backoffPolicy.nextBackoffNanos();
            this.expireNanos = CachingRlsLbClient.this.timeProvider.currentTimeNanos() + delayNanos;
            this.scheduledHandle = CachingRlsLbClient.this.synchronizationContext.schedule(new Runnable(){

                @Override
                public void run() {
                    BackoffCacheEntry.this.transitionToPending();
                }
            }, delayNanos, TimeUnit.NANOSECONDS, CachingRlsLbClient.this.scheduledExecutorService);
        }

        void forceRefresh() {
            if (this.scheduledHandle.isPending()) {
                this.scheduledHandle.cancel();
                this.transitionToPending();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transitionToPending() {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                if (this.shutdown) {
                    return;
                }
                ListenableFuture call = CachingRlsLbClient.this.asyncRlsCall(this.request);
                if (!call.isDone()) {
                    PendingCacheEntry pendingEntry = new PendingCacheEntry(this.request, (ListenableFuture<RlsProtoData.RouteLookupResponse>)call, this.backoffPolicy);
                    CachingRlsLbClient.this.pendingCallCache.put(this.request, pendingEntry);
                    CachingRlsLbClient.this.linkedHashLruCache.invalidate(this.request);
                } else {
                    try {
                        RlsProtoData.RouteLookupResponse response = (RlsProtoData.RouteLookupResponse)call.get();
                        CachingRlsLbClient.this.linkedHashLruCache.cache(this.request, new DataCacheEntry(this.request, response));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        CachingRlsLbClient.this.linkedHashLruCache.cache(this.request, new BackoffCacheEntry(this.request, Status.fromThrowable((Throwable)e), this.backoffPolicy));
                    }
                }
            }
        }

        Status getStatus() {
            return this.status;
        }

        @Override
        int getSizeBytes() {
            return 0;
        }

        @Override
        boolean isExpired(long now) {
            return this.expireNanos <= now;
        }

        @Override
        void cleanup() {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            if (!this.scheduledHandle.isPending()) {
                this.scheduledHandle.cancel();
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).add("status", (Object)this.status).toString();
        }
    }

    final class DataCacheEntry
    extends CacheEntry {
        private final RlsProtoData.RouteLookupResponse response;
        private final long expireTime;
        private final long staleTime;
        private final LbPolicyConfiguration.ChildPolicyWrapper childPolicyWrapper;

        DataCacheEntry(RlsProtoData.RouteLookupRequest request, RlsProtoData.RouteLookupResponse response) {
            super(request);
            this.response = (RlsProtoData.RouteLookupResponse)Preconditions.checkNotNull((Object)response, (Object)"response");
            this.childPolicyWrapper = CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.createOrGet((String)response.getTargets().get(0));
            long now = CachingRlsLbClient.this.timeProvider.currentTimeNanos();
            this.expireTime = now + CachingRlsLbClient.this.maxAgeNanos;
            this.staleTime = now + CachingRlsLbClient.this.staleAgeNanos;
            if (this.childPolicyWrapper.getPicker() != null) {
                this.childPolicyWrapper.refreshState();
            } else {
                this.createChildLbPolicy();
            }
        }

        private void createChildLbPolicy() {
            LbPolicyConfiguration.ChildLoadBalancingPolicy childPolicy = CachingRlsLbClient.this.lbPolicyConfig.getLoadBalancingPolicy();
            LoadBalancerProvider lbProvider = childPolicy.getEffectiveLbProvider();
            NameResolver.ConfigOrError lbConfig = lbProvider.parseLoadBalancingPolicyConfig(childPolicy.getEffectiveChildPolicy(this.childPolicyWrapper.getTarget()));
            LoadBalancer lb = lbProvider.newLoadBalancer((LoadBalancer.Helper)this.childPolicyWrapper.getHelper());
            CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "RLS child lb created. config: {0}", new Object[]{lbConfig.getConfig()});
            lb.handleResolvedAddresses(CachingRlsLbClient.this.childLbResolvedAddressFactory.create(lbConfig.getConfig()));
            lb.requestConnection();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void maybeRefresh() {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                if (CachingRlsLbClient.this.pendingCallCache.containsKey(this.request)) {
                    return;
                }
                ListenableFuture asyncCall = CachingRlsLbClient.this.asyncRlsCall(this.request);
                if (!asyncCall.isDone()) {
                    CachingRlsLbClient.this.pendingCallCache.put(this.request, new PendingCacheEntry(this.request, (ListenableFuture<RlsProtoData.RouteLookupResponse>)asyncCall));
                } else {
                    try {
                        RlsProtoData.RouteLookupResponse response = (RlsProtoData.RouteLookupResponse)asyncCall.get();
                        CachingRlsLbClient.this.linkedHashLruCache.cache(this.request, new DataCacheEntry(this.request, response));
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    catch (Exception e) {
                        BackoffCacheEntry backoffEntry = new BackoffCacheEntry(this.request, Status.fromThrowable((Throwable)e), CachingRlsLbClient.this.backoffProvider.get());
                        CachingRlsLbClient.this.linkedHashLruCache.cache(this.request, backoffEntry);
                    }
                }
            }
        }

        @Nullable
        LbPolicyConfiguration.ChildPolicyWrapper getChildPolicyWrapper() {
            return this.childPolicyWrapper;
        }

        String getHeaderData() {
            return this.response.getHeaderData();
        }

        @Override
        int getSizeBytes() {
            return (((String)this.response.getTargets().get(0)).length() + this.response.getHeaderData().length()) * 2 + 76;
        }

        @Override
        boolean isExpired(long now) {
            return this.expireTime <= now;
        }

        boolean isStaled(long now) {
            return this.staleTime <= now;
        }

        @Override
        void cleanup() {
            CachingRlsLbClient.this.refCountedChildPolicyWrapperFactory.release(this.childPolicyWrapper);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).add("response", (Object)this.response).add("expireTime", this.expireTime).add("staleTime", this.staleTime).add("childPolicyWrapper", (Object)this.childPolicyWrapper).toString();
        }
    }

    abstract class CacheEntry {
        protected final RlsProtoData.RouteLookupRequest request;

        CacheEntry(RlsProtoData.RouteLookupRequest request) {
            this.request = (RlsProtoData.RouteLookupRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        }

        abstract int getSizeBytes();

        final boolean isExpired() {
            return this.isExpired(CachingRlsLbClient.this.timeProvider.currentTimeNanos());
        }

        abstract boolean isExpired(long var1);

        abstract void cleanup();
    }

    final class PendingCacheEntry {
        private final ListenableFuture<RlsProtoData.RouteLookupResponse> pendingCall;
        private final RlsProtoData.RouteLookupRequest request;
        private final BackoffPolicy backoffPolicy;

        PendingCacheEntry(RlsProtoData.RouteLookupRequest request, ListenableFuture<RlsProtoData.RouteLookupResponse> pendingCall) {
            this(request, pendingCall, null);
        }

        PendingCacheEntry(RlsProtoData.RouteLookupRequest request, @Nullable ListenableFuture<RlsProtoData.RouteLookupResponse> pendingCall, BackoffPolicy backoffPolicy) {
            this.request = (RlsProtoData.RouteLookupRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
            this.pendingCall = pendingCall;
            this.backoffPolicy = backoffPolicy == null ? CachingRlsLbClient.this.backoffProvider.get() : backoffPolicy;
            pendingCall.addListener(new Runnable(){

                @Override
                public void run() {
                    PendingCacheEntry.this.handleDoneFuture();
                }
            }, (Executor)CachingRlsLbClient.this.synchronizationContext);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleDoneFuture() {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                CachingRlsLbClient.this.pendingCallCache.remove(this.request);
                if (this.pendingCall.isCancelled()) {
                    return;
                }
                try {
                    this.transitionToDataEntry((RlsProtoData.RouteLookupResponse)this.pendingCall.get());
                }
                catch (Exception e) {
                    if (e instanceof Throttler.ThrottledException) {
                        this.transitionToBackOff(Status.RESOURCE_EXHAUSTED.withCause((Throwable)e));
                    }
                    this.transitionToBackOff(Status.fromThrowable((Throwable)e));
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transitionToDataEntry(RlsProtoData.RouteLookupResponse routeLookupResponse) {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Transition to data cache: routeLookupResponse={0}", new Object[]{routeLookupResponse});
                CachingRlsLbClient.this.linkedHashLruCache.cache(this.request, new DataCacheEntry(this.request, routeLookupResponse));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void transitionToBackOff(Status status) {
            Object object = CachingRlsLbClient.this.lock;
            synchronized (object) {
                CachingRlsLbClient.this.logger.log(ChannelLogger.ChannelLogLevel.DEBUG, "Transition to back off: status={0}", new Object[]{status});
                CachingRlsLbClient.this.linkedHashLruCache.cache(this.request, new BackoffCacheEntry(this.request, status, this.backoffPolicy));
            }
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("request", (Object)this.request).toString();
        }
    }

    static final class CachedRouteLookupResponse {
        @Nullable
        private final DataCacheEntry dataCacheEntry;
        @Nullable
        private final PendingCacheEntry pendingCacheEntry;
        @Nullable
        private final BackoffCacheEntry backoffCacheEntry;

        CachedRouteLookupResponse(DataCacheEntry dataCacheEntry, PendingCacheEntry pendingCacheEntry, BackoffCacheEntry backoffCacheEntry) {
            this.dataCacheEntry = dataCacheEntry;
            this.pendingCacheEntry = pendingCacheEntry;
            this.backoffCacheEntry = backoffCacheEntry;
            Preconditions.checkState((dataCacheEntry != null ^ pendingCacheEntry != null ^ backoffCacheEntry != null && (dataCacheEntry == null || pendingCacheEntry == null || backoffCacheEntry == null) ? 1 : 0) != 0, (Object)"Expected only 1 cache entry value provided");
        }

        static CachedRouteLookupResponse pendingResponse(PendingCacheEntry pendingEntry) {
            return new CachedRouteLookupResponse(null, pendingEntry, null);
        }

        static CachedRouteLookupResponse backoffEntry(BackoffCacheEntry backoffEntry) {
            return new CachedRouteLookupResponse(null, null, backoffEntry);
        }

        static CachedRouteLookupResponse dataEntry(DataCacheEntry dataEntry) {
            return new CachedRouteLookupResponse(dataEntry, null, null);
        }

        boolean hasData() {
            return this.dataCacheEntry != null;
        }

        @Nullable
        LbPolicyConfiguration.ChildPolicyWrapper getChildPolicyWrapper() {
            if (!this.hasData()) {
                return null;
            }
            return this.dataCacheEntry.getChildPolicyWrapper();
        }

        @Nullable
        String getHeaderData() {
            if (!this.hasData()) {
                return null;
            }
            return this.dataCacheEntry.getHeaderData();
        }

        boolean hasError() {
            return this.backoffCacheEntry != null;
        }

        boolean isPending() {
            return this.pendingCacheEntry != null;
        }

        @Nullable
        Status getStatus() {
            if (!this.hasError()) {
                return null;
            }
            return this.backoffCacheEntry.getStatus();
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            if (this.dataCacheEntry != null) {
                toStringHelper.add("dataCacheEntry", (Object)this.dataCacheEntry);
            }
            if (this.pendingCacheEntry != null) {
                toStringHelper.add("pendingCacheEntry", (Object)this.pendingCacheEntry);
            }
            if (this.backoffCacheEntry != null) {
                toStringHelper.add("backoffCacheEntry", (Object)this.backoffCacheEntry);
            }
            return toStringHelper.toString();
        }
    }

    private static final class RlsLbHelper
    extends ForwardingLoadBalancerHelper {
        final LoadBalancer.Helper helper;
        private ConnectivityState state;
        private LoadBalancer.SubchannelPicker picker;

        RlsLbHelper(LoadBalancer.Helper helper) {
            this.helper = helper;
        }

        protected LoadBalancer.Helper delegate() {
            return this.helper;
        }

        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.state = newState;
            this.picker = newPicker;
            super.updateBalancingState(newState, newPicker);
        }

        void propagateRlsError() {
            this.getSynchronizationContext().execute(new Runnable(){

                @Override
                public void run() {
                    if (RlsLbHelper.this.picker != null) {
                        RlsLbHelper.this.updateBalancingState(RlsLbHelper.this.state, RlsLbHelper.this.picker);
                    }
                }
            });
        }
    }
}

