/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.auto.value.AutoValue;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.rls.AutoValue_RlsProtoData_ExtraKeys;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

final class RlsProtoData {
    private RlsProtoData() {
    }

    @AutoValue
    static abstract class ExtraKeys {
        static final ExtraKeys DEFAULT = ExtraKeys.create(null, null, null);

        ExtraKeys() {
        }

        @Nullable
        abstract String host();

        @Nullable
        abstract String service();

        @Nullable
        abstract String method();

        static ExtraKeys create(@Nullable String host, @Nullable String service, @Nullable String method) {
            return new AutoValue_RlsProtoData_ExtraKeys(host, service, method);
        }
    }

    static final class GrpcKeyBuilder {
        private final ImmutableList<Name> names;
        private final ImmutableList<NameMatcher> headers;
        private final ExtraKeys extraKeys;
        private final ImmutableMap<String, String> constantKeys;

        GrpcKeyBuilder(List<Name> names, List<NameMatcher> headers, ExtraKeys extraKeys, Map<String, String> constantKeys) {
            Preconditions.checkState((names != null && !names.isEmpty() ? 1 : 0) != 0, (Object)"names cannot be empty");
            this.names = ImmutableList.copyOf(names);
            this.headers = ImmutableList.copyOf(headers);
            this.extraKeys = (ExtraKeys)Preconditions.checkNotNull((Object)extraKeys, (Object)"extraKeys");
            this.constantKeys = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(constantKeys, (Object)"constantKeys")));
        }

        ImmutableList<Name> getNames() {
            return this.names;
        }

        ImmutableList<NameMatcher> getHeaders() {
            return this.headers;
        }

        ExtraKeys getExtraKeys() {
            return this.extraKeys;
        }

        ImmutableMap<String, String> getConstantKeys() {
            return this.constantKeys;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GrpcKeyBuilder that = (GrpcKeyBuilder)o;
            return com.google.common.base.Objects.equal(this.names, that.names) && com.google.common.base.Objects.equal(this.headers, that.headers) && com.google.common.base.Objects.equal((Object)this.extraKeys, (Object)that.extraKeys) && com.google.common.base.Objects.equal(this.constantKeys, that.constantKeys);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.names, this.headers, this.extraKeys, this.constantKeys});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("names", this.names).add("headers", this.headers).add("extraKeys", (Object)this.extraKeys).add("constantKeys", this.constantKeys).toString();
        }

        static final class Name {
            private final String service;
            @Nullable
            private final String method;

            Name(String service, @Nullable String method) {
                this.service = service;
                this.method = method;
            }

            String getService() {
                return this.service;
            }

            @Nullable
            String getMethod() {
                return this.method;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Name name = (Name)o;
                return com.google.common.base.Objects.equal((Object)this.service, (Object)name.service) && com.google.common.base.Objects.equal((Object)this.method, (Object)name.method);
            }

            public int hashCode() {
                return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.service, this.method});
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("service", (Object)this.service).add("method", (Object)this.method).toString();
            }
        }
    }

    @Immutable
    static final class NameMatcher {
        private final String key;
        private final ImmutableList<String> names;

        NameMatcher(String key, List<String> names) {
            this.key = (String)Preconditions.checkNotNull((Object)key, (Object)"key");
            this.names = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(names, (Object)"names")));
        }

        String getKey() {
            return this.key;
        }

        ImmutableList<String> names() {
            return this.names;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NameMatcher matcher = (NameMatcher)o;
            return Objects.equals(this.key, matcher.key) && Objects.equals(this.names, matcher.names);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.names);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("names", this.names).toString();
        }
    }

    @Immutable
    static final class RouteLookupConfig {
        private final ImmutableList<GrpcKeyBuilder> grpcKeyBuilders;
        private final String lookupService;
        private final long lookupServiceTimeoutInNanos;
        private final long maxAgeInNanos;
        private final long staleAgeInNanos;
        private final long cacheSizeBytes;
        @Nullable
        private final String defaultTarget;

        RouteLookupConfig(List<GrpcKeyBuilder> grpcKeyBuilders, String lookupService, long lookupServiceTimeoutInNanos, long maxAgeInNanos, long staleAgeInNanos, long cacheSizeBytes, @Nullable String defaultTarget) {
            this.grpcKeyBuilders = ImmutableList.copyOf(grpcKeyBuilders);
            this.lookupService = lookupService;
            this.lookupServiceTimeoutInNanos = lookupServiceTimeoutInNanos;
            this.maxAgeInNanos = maxAgeInNanos;
            this.staleAgeInNanos = staleAgeInNanos;
            this.cacheSizeBytes = cacheSizeBytes;
            this.defaultTarget = defaultTarget;
        }

        ImmutableList<GrpcKeyBuilder> getGrpcKeyBuilders() {
            return this.grpcKeyBuilders;
        }

        String getLookupService() {
            return this.lookupService;
        }

        long getLookupServiceTimeoutInNanos() {
            return this.lookupServiceTimeoutInNanos;
        }

        long getMaxAgeInNanos() {
            return this.maxAgeInNanos;
        }

        long getStaleAgeInNanos() {
            return this.staleAgeInNanos;
        }

        long getCacheSizeBytes() {
            return this.cacheSizeBytes;
        }

        @Nullable
        String getDefaultTarget() {
            return this.defaultTarget;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteLookupConfig that = (RouteLookupConfig)o;
            return this.lookupServiceTimeoutInNanos == that.lookupServiceTimeoutInNanos && this.maxAgeInNanos == that.maxAgeInNanos && this.staleAgeInNanos == that.staleAgeInNanos && this.cacheSizeBytes == that.cacheSizeBytes && com.google.common.base.Objects.equal(this.grpcKeyBuilders, that.grpcKeyBuilders) && com.google.common.base.Objects.equal((Object)this.lookupService, (Object)that.lookupService) && com.google.common.base.Objects.equal((Object)this.defaultTarget, (Object)that.defaultTarget);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.grpcKeyBuilders, this.lookupService, this.lookupServiceTimeoutInNanos, this.maxAgeInNanos, this.staleAgeInNanos, this.cacheSizeBytes, this.defaultTarget});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("grpcKeyBuilders", this.grpcKeyBuilders).add("lookupService", (Object)this.lookupService).add("lookupServiceTimeoutInNanos", this.lookupServiceTimeoutInNanos).add("maxAgeInNanos", this.maxAgeInNanos).add("staleAgeInNanos", this.staleAgeInNanos).add("cacheSize", this.cacheSizeBytes).add("defaultTarget", (Object)this.defaultTarget).toString();
        }
    }

    @Immutable
    static final class RouteLookupResponse {
        private final ImmutableList<String> targets;
        private final String headerData;

        RouteLookupResponse(List<String> targets, String headerData) {
            Preconditions.checkState((targets != null && !targets.isEmpty() ? 1 : 0) != 0, (Object)"targets cannot be empty or null");
            this.targets = ImmutableList.copyOf(targets);
            this.headerData = (String)Preconditions.checkNotNull((Object)headerData, (Object)"headerData");
        }

        ImmutableList<String> getTargets() {
            return this.targets;
        }

        String getHeaderData() {
            return this.headerData;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteLookupResponse that = (RouteLookupResponse)o;
            return Objects.equals(this.targets, that.targets) && Objects.equals(this.headerData, that.headerData);
        }

        public int hashCode() {
            return Objects.hash(this.targets, this.headerData);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("targets", this.targets).add("headerData", (Object)this.headerData).toString();
        }
    }

    @Immutable
    static final class RouteLookupRequest {
        private final ImmutableMap<String, String> keyMap;

        RouteLookupRequest(Map<String, String> keyMap) {
            this.keyMap = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(keyMap, (Object)"keyMap")));
        }

        ImmutableMap<String, String> getKeyMap() {
            return this.keyMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteLookupRequest that = (RouteLookupRequest)o;
            return com.google.common.base.Objects.equal(this.keyMap, that.keyMap);
        }

        public int hashCode() {
            return com.google.common.base.Objects.hashCode((Object[])new Object[]{this.keyMap});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("keyMap", this.keyMap).toString();
        }
    }
}

