/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.rls;

import com.google.common.base.Converter;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.internal.JsonUtil;
import io.grpc.lookup.v1.RouteLookupRequest;
import io.grpc.lookup.v1.RouteLookupResponse;
import io.grpc.rls.RlsProtoData;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class RlsProtoConverters {
    private static final long MAX_AGE_NANOS = TimeUnit.MINUTES.toNanos(5L);
    private static final long MAX_CACHE_SIZE = 0x500000L;
    private static final long DEFAULT_LOOKUP_SERVICE_TIMEOUT = TimeUnit.SECONDS.toNanos(10L);
    private static final ImmutableList<String> EXTRA_KEY_NAMES = ImmutableList.of((Object)"host", (Object)"service", (Object)"method");

    private static void checkUniqueKey(List<RlsProtoData.NameMatcher> nameMatchers, Set<String> constantKeys) {
        HashSet<String> keys = new HashSet<String>(constantKeys);
        keys.addAll((Collection<String>)EXTRA_KEY_NAMES);
        for (RlsProtoData.NameMatcher nameMatcher : nameMatchers) {
            keys.add(nameMatcher.getKey());
        }
        if (keys.size() != nameMatchers.size() + constantKeys.size() + EXTRA_KEY_NAMES.size()) {
            throw new IllegalArgumentException("keys in KeyBuilder must be unique");
        }
    }

    private RlsProtoConverters() {
    }

    private static final class GrpcKeyBuilderConverter {
        private GrpcKeyBuilderConverter() {
        }

        public static List<RlsProtoData.GrpcKeyBuilder> covertAll(List<Map<String, ?>> keyBuilders) {
            ArrayList<RlsProtoData.GrpcKeyBuilder> keyBuilderList = new ArrayList<RlsProtoData.GrpcKeyBuilder>();
            for (Map<String, ?> keyBuilder : keyBuilders) {
                keyBuilderList.add(GrpcKeyBuilderConverter.convert(keyBuilder));
            }
            return keyBuilderList;
        }

        static RlsProtoData.GrpcKeyBuilder convert(Map<String, ?> keyBuilder) {
            Map constantKeys;
            List rawRawNames = JsonUtil.getList(keyBuilder, (String)"names");
            Preconditions.checkArgument((rawRawNames != null && !rawRawNames.isEmpty() ? 1 : 0) != 0, (Object)"each keyBuilder must have at least one name");
            List rawNames = JsonUtil.checkObjectList((List)rawRawNames);
            ArrayList<RlsProtoData.GrpcKeyBuilder.Name> names = new ArrayList<RlsProtoData.GrpcKeyBuilder.Name>();
            for (Map rawName : rawNames) {
                String serviceName = JsonUtil.getString((Map)rawName, (String)"service");
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)serviceName) ? 1 : 0) != 0, (Object)"service must not be empty or null");
                names.add(new RlsProtoData.GrpcKeyBuilder.Name(serviceName, JsonUtil.getString((Map)rawName, (String)"method")));
            }
            List rawRawHeaders = JsonUtil.getList(keyBuilder, (String)"headers");
            List rawHeaders = rawRawHeaders == null ? new ArrayList() : JsonUtil.checkObjectList((List)rawRawHeaders);
            ArrayList<RlsProtoData.NameMatcher> nameMatchers = new ArrayList<RlsProtoData.NameMatcher>();
            for (Map rawHeader : rawHeaders) {
                Boolean requiredMatch = JsonUtil.getBoolean((Map)rawHeader, (String)"requiredMatch");
                Preconditions.checkArgument((requiredMatch == null || requiredMatch == false ? 1 : 0) != 0, (Object)"requiredMatch shouldn't be specified for gRPC");
                RlsProtoData.NameMatcher matcher = new RlsProtoData.NameMatcher(JsonUtil.getString((Map)rawHeader, (String)"key"), (List)rawHeader.get("names"));
                nameMatchers.add(matcher);
            }
            RlsProtoData.ExtraKeys extraKeys = RlsProtoData.ExtraKeys.DEFAULT;
            Map rawExtraKeys = JsonUtil.getObject(keyBuilder, (String)"extraKeys");
            if (rawExtraKeys != null) {
                extraKeys = RlsProtoData.ExtraKeys.create((String)rawExtraKeys.get("host"), (String)rawExtraKeys.get("service"), (String)rawExtraKeys.get("method"));
            }
            if ((constantKeys = JsonUtil.getObject(keyBuilder, (String)"constantKeys")) == null) {
                constantKeys = ImmutableMap.of();
            }
            RlsProtoConverters.checkUniqueKey(nameMatchers, constantKeys.keySet());
            return new RlsProtoData.GrpcKeyBuilder(names, nameMatchers, extraKeys, constantKeys);
        }
    }

    static final class RouteLookupConfigConverter
    extends Converter<Map<String, ?>, RlsProtoData.RouteLookupConfig> {
        RouteLookupConfigConverter() {
        }

        protected RlsProtoData.RouteLookupConfig doForward(Map<String, ?> json) {
            List<RlsProtoData.GrpcKeyBuilder> grpcKeyBuilders = GrpcKeyBuilderConverter.covertAll((List)Preconditions.checkNotNull((Object)JsonUtil.getListOfObjects(json, (String)"grpcKeyBuilders"), (Object)"grpcKeyBuilders"));
            Preconditions.checkArgument((!grpcKeyBuilders.isEmpty() ? 1 : 0) != 0, (Object)"must have at least one GrpcKeyBuilder");
            HashSet<RlsProtoData.GrpcKeyBuilder.Name> names = new HashSet<RlsProtoData.GrpcKeyBuilder.Name>();
            for (RlsProtoData.GrpcKeyBuilder keyBuilder : grpcKeyBuilders) {
                for (RlsProtoData.GrpcKeyBuilder.Name name : keyBuilder.getNames()) {
                    Preconditions.checkArgument((boolean)names.add(name), (Object)("duplicate names in grpc_keybuilders: " + name));
                }
            }
            String lookupService = JsonUtil.getString(json, (String)"lookupService");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)lookupService) ? 1 : 0) != 0, (Object)"lookupService must not be empty");
            try {
                new URI(lookupService);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException("The lookupService field is not valid URI: " + lookupService, e);
            }
            long timeout = RouteLookupConfigConverter.orDefault(JsonUtil.getStringAsDuration(json, (String)"lookupServiceTimeout"), DEFAULT_LOOKUP_SERVICE_TIMEOUT);
            Preconditions.checkArgument((timeout > 0L ? 1 : 0) != 0, (Object)"lookupServiceTimeout should be positive");
            Long maxAge = JsonUtil.getStringAsDuration(json, (String)"maxAge");
            Long staleAge = JsonUtil.getStringAsDuration(json, (String)"staleAge");
            if (maxAge == null) {
                Preconditions.checkArgument((staleAge == null ? 1 : 0) != 0, (Object)"to specify staleAge, must have maxAge");
                maxAge = MAX_AGE_NANOS;
            }
            if (staleAge == null) {
                staleAge = MAX_AGE_NANOS;
            }
            maxAge = Math.min(maxAge, MAX_AGE_NANOS);
            staleAge = Math.min(staleAge, maxAge);
            long cacheSize = RouteLookupConfigConverter.orDefault(JsonUtil.getNumberAsLong(json, (String)"cacheSizeBytes"), 0x500000L);
            Preconditions.checkArgument((cacheSize > 0L ? 1 : 0) != 0, (Object)"cacheSize must be positive");
            cacheSize = Math.min(cacheSize, 0x500000L);
            String defaultTarget = Strings.emptyToNull((String)JsonUtil.getString(json, (String)"defaultTarget"));
            return new RlsProtoData.RouteLookupConfig(grpcKeyBuilders, lookupService, timeout, maxAge, staleAge, cacheSize, defaultTarget);
        }

        private static <T> T orDefault(@Nullable T value, T defaultValue) {
            if (value == null) {
                return (T)Preconditions.checkNotNull(defaultValue, (Object)"defaultValue");
            }
            return value;
        }

        protected Map<String, Object> doBackward(RlsProtoData.RouteLookupConfig routeLookupConfig) {
            throw new UnsupportedOperationException();
        }
    }

    static final class RouteLookupResponseConverter
    extends Converter<RouteLookupResponse, RlsProtoData.RouteLookupResponse> {
        RouteLookupResponseConverter() {
        }

        protected RlsProtoData.RouteLookupResponse doForward(RouteLookupResponse routeLookupResponse) {
            return new RlsProtoData.RouteLookupResponse((List<String>)routeLookupResponse.getTargetsList(), routeLookupResponse.getHeaderData());
        }

        protected RouteLookupResponse doBackward(RlsProtoData.RouteLookupResponse routeLookupResponse) {
            return RouteLookupResponse.newBuilder().addAllTargets((Iterable<String>)routeLookupResponse.getTargets()).setHeaderData(routeLookupResponse.getHeaderData()).build();
        }
    }

    static final class RouteLookupRequestConverter
    extends Converter<RouteLookupRequest, RlsProtoData.RouteLookupRequest> {
        RouteLookupRequestConverter() {
        }

        protected RlsProtoData.RouteLookupRequest doForward(RouteLookupRequest routeLookupRequest) {
            return new RlsProtoData.RouteLookupRequest(routeLookupRequest.getKeyMapMap());
        }

        protected RouteLookupRequest doBackward(RlsProtoData.RouteLookupRequest routeLookupRequest) {
            return RouteLookupRequest.newBuilder().setTargetType("grpc").putAllKeyMap((Map<String, String>)routeLookupRequest.getKeyMap()).build();
        }
    }
}

