/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.google.protobuf.Int64Value;
import com.google.protobuf.util.Timestamps;
import io.grpc.ConnectivityState;
import io.grpc.Status;
import io.grpc.channelz.v1.Address;
import io.grpc.channelz.v1.Channel;
import io.grpc.channelz.v1.ChannelData;
import io.grpc.channelz.v1.ChannelRef;
import io.grpc.channelz.v1.GetServersResponse;
import io.grpc.channelz.v1.GetTopChannelsResponse;
import io.grpc.channelz.v1.Server;
import io.grpc.channelz.v1.ServerData;
import io.grpc.channelz.v1.ServerRef;
import io.grpc.channelz.v1.Socket;
import io.grpc.channelz.v1.SocketData;
import io.grpc.channelz.v1.SocketRef;
import io.grpc.channelz.v1.Subchannel;
import io.grpc.channelz.v1.SubchannelRef;
import io.grpc.internal.Channelz;
import io.grpc.internal.Instrumented;
import io.grpc.internal.WithLogId;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.ExecutionException;

final class ChannelzProtoUtil {
    private ChannelzProtoUtil() {
    }

    static ChannelRef toChannelRef(WithLogId obj) {
        return ChannelRef.newBuilder().setChannelId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static SubchannelRef toSubchannelRef(WithLogId obj) {
        return SubchannelRef.newBuilder().setSubchannelId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static ServerRef toServerRef(WithLogId obj) {
        return ServerRef.newBuilder().setServerId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static SocketRef toSocketRef(WithLogId obj) {
        return SocketRef.newBuilder().setSocketId(obj.getLogId().getId()).setName(obj.toString()).build();
    }

    static Server toServer(Instrumented<Channelz.ServerStats> obj) {
        Channelz.ServerStats stats = (Channelz.ServerStats)ChannelzProtoUtil.getFuture(obj.getStats());
        return Server.newBuilder().setRef(ChannelzProtoUtil.toServerRef(obj)).setData(ChannelzProtoUtil.toServerData(stats)).build();
    }

    static ServerData toServerData(Channelz.ServerStats stats) {
        return ServerData.newBuilder().setCallsStarted(stats.callsStarted).setCallsSucceeded(stats.callsSucceeded).setCallsFailed(stats.callsFailed).setLastCallStartedTimestamp(Timestamps.fromMillis((long)stats.lastCallStartedMillis)).build();
    }

    static Socket toSocket(Instrumented<Channelz.SocketStats> obj) {
        Channelz.SocketStats socketStats = (Channelz.SocketStats)ChannelzProtoUtil.getFuture(obj.getStats());
        return Socket.newBuilder().setRef(ChannelzProtoUtil.toSocketRef(obj)).setRemote(ChannelzProtoUtil.toAddress(socketStats.remote)).setLocal(ChannelzProtoUtil.toAddress(socketStats.local)).setData(ChannelzProtoUtil.toSocketData(socketStats.data)).build();
    }

    static Address toAddress(SocketAddress address) {
        Address.Builder builder = Address.newBuilder();
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            builder.setTcpipAddress(Address.TcpIpAddress.newBuilder().setIpAddress(ByteString.copyFrom((byte[])inetAddress.getAddress().getAddress())).build());
        } else if (address.getClass().getName().endsWith("io.netty.channel.unix.DomainSocketAddress")) {
            builder.setUdsAddress(Address.UdsAddress.newBuilder().setFilename(address.toString()).build());
        } else {
            builder.setOtherAddress(Address.OtherAddress.newBuilder().setName(address.toString()).build());
        }
        return builder.build();
    }

    static SocketData toSocketData(Channelz.TransportStats s) {
        return SocketData.newBuilder().setStreamsStarted(s.streamsStarted).setStreamsSucceeded(s.streamsSucceeded).setStreamsFailed(s.streamsFailed).setMessagesSent(s.messagesSent).setMessagesReceived(s.messagesReceived).setKeepAlivesSent(s.keepAlivesSent).setLastLocalStreamCreatedTimestamp(Timestamps.fromNanos((long)s.lastLocalStreamCreatedTimeNanos)).setLastRemoteStreamCreatedTimestamp(Timestamps.fromNanos((long)s.lastRemoteStreamCreatedTimeNanos)).setLastMessageSentTimestamp(Timestamps.fromNanos((long)s.lastMessageSentTimeNanos)).setLastMessageReceivedTimestamp(Timestamps.fromNanos((long)s.lastMessageReceivedTimeNanos)).setLocalFlowControlWindow(Int64Value.newBuilder().setValue(s.localFlowControlWindow).build()).setRemoteFlowControlWindow(Int64Value.newBuilder().setValue(s.remoteFlowControlWindow).build()).build();
    }

    static Channel toChannel(Instrumented<Channelz.ChannelStats> channel) {
        Channelz.ChannelStats stats = (Channelz.ChannelStats)ChannelzProtoUtil.getFuture(channel.getStats());
        Channel.Builder channelBuilder = Channel.newBuilder().setRef(ChannelzProtoUtil.toChannelRef(channel)).setData(ChannelzProtoUtil.extractChannelData(stats));
        for (WithLogId subchannel : stats.subchannels) {
            channelBuilder.addSubchannelRef(ChannelzProtoUtil.toSubchannelRef(subchannel));
        }
        return channelBuilder.build();
    }

    static ChannelData extractChannelData(Channelz.ChannelStats stats) {
        return ChannelData.newBuilder().setTarget(stats.target).setState(ChannelzProtoUtil.toState(stats.state)).setCallsStarted(stats.callsStarted).setCallsSucceeded(stats.callsSucceeded).setCallsFailed(stats.callsFailed).setLastCallStartedTimestamp(Timestamps.fromMillis((long)stats.lastCallStartedMillis)).build();
    }

    static ChannelData.State toState(ConnectivityState state) {
        if (state == null) {
            return ChannelData.State.UNKNOWN;
        }
        try {
            return Enum.valueOf(ChannelData.State.class, state.name());
        }
        catch (IllegalArgumentException e) {
            return ChannelData.State.UNKNOWN;
        }
    }

    static Subchannel toSubchannel(Instrumented<Channelz.ChannelStats> subchannel) {
        Channelz.ChannelStats stats = (Channelz.ChannelStats)ChannelzProtoUtil.getFuture(subchannel.getStats());
        Subchannel.Builder subchannelBuilder = Subchannel.newBuilder().setRef(ChannelzProtoUtil.toSubchannelRef(subchannel)).setData(ChannelzProtoUtil.extractChannelData(stats));
        Preconditions.checkState((stats.sockets.isEmpty() || stats.subchannels.isEmpty() ? 1 : 0) != 0);
        for (WithLogId childSocket : stats.sockets) {
            subchannelBuilder.addSocketRef(ChannelzProtoUtil.toSocketRef(childSocket));
        }
        for (WithLogId childSubchannel : stats.subchannels) {
            subchannelBuilder.addSubchannelRef(ChannelzProtoUtil.toSubchannelRef(childSubchannel));
        }
        return subchannelBuilder.build();
    }

    static GetTopChannelsResponse toGetTopChannelResponse(Channelz.RootChannelList rootChannels) {
        GetTopChannelsResponse.Builder responseBuilder = GetTopChannelsResponse.newBuilder().setEnd(rootChannels.end);
        for (Instrumented c : rootChannels.channels) {
            responseBuilder.addChannel(ChannelzProtoUtil.toChannel((Instrumented<Channelz.ChannelStats>)c));
        }
        return responseBuilder.build();
    }

    static GetServersResponse toGetServersResponse(Channelz.ServerList servers) {
        GetServersResponse.Builder responseBuilder = GetServersResponse.newBuilder().setEnd(servers.end);
        for (Instrumented s : servers.servers) {
            responseBuilder.addServer(ChannelzProtoUtil.toServer((Instrumented<Channelz.ServerStats>)s));
        }
        return responseBuilder.build();
    }

    private static <T> T getFuture(ListenableFuture<T> future) {
        try {
            return (T)future.get();
        }
        catch (InterruptedException e) {
            throw Status.INTERNAL.withCause((Throwable)e).asRuntimeException();
        }
        catch (ExecutionException e) {
            throw Status.INTERNAL.withCause((Throwable)e).asRuntimeException();
        }
    }
}

