/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.ExperimentalApi;
import io.grpc.Status;
import io.grpc.channelz.v1.ChannelzGrpc;
import io.grpc.channelz.v1.GetChannelRequest;
import io.grpc.channelz.v1.GetChannelResponse;
import io.grpc.channelz.v1.GetServerSocketsRequest;
import io.grpc.channelz.v1.GetServerSocketsResponse;
import io.grpc.channelz.v1.GetServersRequest;
import io.grpc.channelz.v1.GetServersResponse;
import io.grpc.channelz.v1.GetSocketRequest;
import io.grpc.channelz.v1.GetSocketResponse;
import io.grpc.channelz.v1.GetSubchannelRequest;
import io.grpc.channelz.v1.GetSubchannelResponse;
import io.grpc.channelz.v1.GetTopChannelsRequest;
import io.grpc.channelz.v1.GetTopChannelsResponse;
import io.grpc.internal.Channelz;
import io.grpc.internal.Instrumented;
import io.grpc.services.ChannelzProtoUtil;
import io.grpc.stub.StreamObserver;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4206")
public final class ChannelzService
extends ChannelzGrpc.ChannelzImplBase {
    private final Channelz channelz;
    private final int maxPageSize;

    public ChannelzService newInstance(int maxPageSize) {
        return new ChannelzService(Channelz.instance(), maxPageSize);
    }

    @VisibleForTesting
    ChannelzService(Channelz channelz, int maxPageSize) {
        this.channelz = channelz;
        this.maxPageSize = maxPageSize;
    }

    @Override
    public void getTopChannels(GetTopChannelsRequest request, StreamObserver<GetTopChannelsResponse> responseObserver) {
        Channelz.RootChannelList rootChannels = this.channelz.getRootChannels(request.getStartChannelId(), this.maxPageSize);
        responseObserver.onNext((Object)ChannelzProtoUtil.toGetTopChannelResponse(rootChannels));
        responseObserver.onCompleted();
    }

    @Override
    public void getChannel(GetChannelRequest request, StreamObserver<GetChannelResponse> responseObserver) {
        Instrumented s = this.channelz.getRootChannel(request.getChannelId());
        if (s == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
            return;
        }
        responseObserver.onNext((Object)GetChannelResponse.newBuilder().setChannel(ChannelzProtoUtil.toChannel((Instrumented<Channelz.ChannelStats>)s)).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getServers(GetServersRequest request, StreamObserver<GetServersResponse> responseObserver) {
        Channelz.ServerList servers = this.channelz.getServers(request.getStartServerId(), this.maxPageSize);
        responseObserver.onNext((Object)ChannelzProtoUtil.toGetServersResponse(servers));
        responseObserver.onCompleted();
    }

    @Override
    public void getSubchannel(GetSubchannelRequest request, StreamObserver<GetSubchannelResponse> responseObserver) {
        Instrumented s = this.channelz.getSubchannel(request.getSubchannelId());
        if (s == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
            return;
        }
        responseObserver.onNext((Object)GetSubchannelResponse.newBuilder().setSubchannel(ChannelzProtoUtil.toSubchannel((Instrumented<Channelz.ChannelStats>)s)).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getSocket(GetSocketRequest request, StreamObserver<GetSocketResponse> responseObserver) {
        Instrumented s = this.channelz.getSocket(request.getSocketId());
        if (s == null) {
            responseObserver.onError((Throwable)Status.NOT_FOUND.asRuntimeException());
            return;
        }
        responseObserver.onNext((Object)GetSocketResponse.newBuilder().setSocket(ChannelzProtoUtil.toSocket((Instrumented<Channelz.SocketStats>)s)).build());
        responseObserver.onCompleted();
    }

    @Override
    public void getServerSockets(GetServerSocketsRequest request, StreamObserver<GetServerSocketsResponse> responseObserver) {
        responseObserver.onError((Throwable)Status.UNIMPLEMENTED.asRuntimeException());
    }
}

