/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import io.grpc.ClientInterceptor;
import io.grpc.ExperimentalApi;
import io.grpc.ServerInterceptor;
import io.grpc.internal.BinaryLogProvider;
import io.grpc.services.BinaryLog;
import io.grpc.services.BinaryLogSink;
import io.grpc.services.BinaryLogSinkProvider;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@ExperimentalApi(value="https://github.com/grpc/grpc-java/issues/4017")
public class BinaryLogProviderImpl
extends BinaryLogProvider {
    private static final Logger logger = Logger.getLogger(BinaryLogProviderImpl.class.getName());
    private final BinaryLog.Factory factory;

    public BinaryLogProviderImpl() {
        this(BinaryLogSinkProvider.provider(), System.getenv("GRPC_BINARY_LOG_CONFIG"));
    }

    BinaryLogProviderImpl(BinaryLogSink sink, String configStr) {
        BinaryLog.FactoryImpl factory = null;
        try {
            factory = new BinaryLog.FactoryImpl(sink, configStr);
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "Caught exception, binary log will be disabled", e);
        }
        catch (Error err) {
            logger.log(Level.SEVERE, "Caught exception, binary log will be disabled", err);
        }
        this.factory = factory;
    }

    @Nullable
    public ServerInterceptor getServerInterceptor(String fullMethodName) {
        return null;
    }

    @Nullable
    public ClientInterceptor getClientInterceptor(String fullMethodName) {
        return null;
    }

    protected int priority() {
        return 5;
    }

    protected boolean isAvailable() {
        return this.factory != null;
    }
}

