/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.services;

import com.google.protobuf.MessageLite;
import io.grpc.services.BinaryLogSink;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

class TempFileSink
implements BinaryLogSink {
    private static final Logger logger = Logger.getLogger(TempFileSink.class.getName());
    private final String outPath;
    private final OutputStream out;
    private boolean closed;

    TempFileSink() throws IOException {
        File outFile = File.createTempFile("BINARY_INFO.", "");
        this.outPath = outFile.getPath();
        logger.log(Level.INFO, "Writing binary logs to to {0}", outFile.getAbsolutePath());
        this.out = new BufferedOutputStream(new FileOutputStream(outFile));
    }

    String getPath() {
        return this.outPath;
    }

    @Override
    public synchronized void write(MessageLite message) {
        if (this.closed) {
            logger.log(Level.FINEST, "Attempt to write after TempFileSink is closed.");
            return;
        }
        try {
            message.writeDelimitedTo(this.out);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Caught exception while writing", e);
            this.closeQuietly();
        }
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            this.out.flush();
        }
        finally {
            this.out.close();
        }
    }

    private synchronized void closeQuietly() {
        try {
            this.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Caught exception while closing", e);
        }
    }
}

