/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;

public class TestUtils {
    public static final String TEST_SERVER_HOST = "foo.test.google.fr";

    public static ServerInterceptor echoRequestHeadersInterceptor(Metadata.Key<?> ... keys) {
        final HashSet keySet = new HashSet(Arrays.asList(keys));
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(MethodDescriptor<ReqT, RespT> method, ServerCall<RespT> call, final Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                return next.startCall(method, (ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<RespT>(call){

                    public void sendHeaders(Metadata responseHeaders) {
                        responseHeaders.merge(requestHeaders, keySet);
                        super.sendHeaders(responseHeaders);
                    }

                    public void close(Status status, Metadata trailers) {
                        trailers.merge(requestHeaders, keySet);
                        super.close(status, trailers);
                    }
                }, requestHeaders);
            }
        };
    }

    public static ServerInterceptor recordRequestHeadersInterceptor(final AtomicReference<Metadata> headersCapture) {
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(MethodDescriptor<ReqT, RespT> method, ServerCall<RespT> call, Metadata requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                headersCapture.set(requestHeaders);
                return next.startCall(method, call, requestHeaders);
            }
        };
    }

    public static int pickUnusedPort() {
        try {
            ServerSocket serverSocket = new ServerSocket(0);
            int port = serverSocket.getLocalPort();
            serverSocket.close();
            return port;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static InetSocketAddress testServerAddress(String host, int port) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            inetAddress = InetAddress.getByAddress(TEST_SERVER_HOST, inetAddress.getAddress());
            return new InetSocketAddress(inetAddress, port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static InetSocketAddress testServerAddress(int port) {
        try {
            InetAddress inetAddress = InetAddress.getByName("localhost");
            inetAddress = InetAddress.getByAddress(TEST_SERVER_HOST, inetAddress.getAddress());
            return new InetSocketAddress(inetAddress, port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<String> preferredTestCiphers() {
        String[] ciphers;
        try {
            ciphers = SSLContext.getDefault().getDefaultSSLParameters().getCipherSuites();
        }
        catch (NoSuchAlgorithmException ex) {
            throw new RuntimeException(ex);
        }
        ArrayList<String> ciphersMinusGcm = new ArrayList<String>();
        for (String cipher : ciphers) {
            if (cipher.contains("_GCM_")) continue;
            ciphersMinusGcm.add(cipher);
        }
        return Collections.unmodifiableList(ciphersMinusGcm);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File loadCert(String name) throws IOException {
        InputStream in = TestUtils.class.getResourceAsStream("/certs/" + name);
        File tmpFile = File.createTempFile(name, "");
        tmpFile.deleteOnExit();
        BufferedWriter writer = new BufferedWriter(new FileWriter(tmpFile));
        try {
            int b;
            while ((b = in.read()) != -1) {
                writer.write(b);
            }
        }
        finally {
            writer.close();
        }
        return tmpFile;
    }

    public static SSLSocketFactory newSslSocketFactoryForCa(File certChainFile) throws Exception {
        FileInputStream is = new FileInputStream(certChainFile);
        try {
            SSLSocketFactory sSLSocketFactory = TestUtils.newSslSocketFactoryForCa(is);
            return sSLSocketFactory;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    public static SSLSocketFactory newSslSocketFactoryForCa(InputStream certChain) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null, null);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new BufferedInputStream(certChain));
        X500Principal principal = cert.getSubjectX500Principal();
        ks.setCertificateEntry(principal.getName("RFC2253"), cert);
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(ks);
        SSLContext context = SSLContext.getInstance("TLS");
        context.init(null, trustManagerFactory.getTrustManagers(), null);
        return context.getSocketFactory();
    }

    private TestUtils() {
    }
}

