/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import io.grpc.internal.ClientTransportFactory;
import io.grpc.testing.TestUtils;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;

@RunWith(value=JUnit4.class)
public abstract class AbstractClientTransportFactoryTest {
    protected abstract ClientTransportFactory newClientTransportFactory();

    @Test
    public void multipleCallsToCloseShouldNotThrow() {
        ClientTransportFactory transportFactory = this.newClientTransportFactory();
        transportFactory.close();
        transportFactory.close();
        transportFactory.close();
    }

    @Test(expected=IllegalStateException.class)
    public void newClientTransportAfterCloseShouldThrow() {
        int port = TestUtils.pickUnusedPort();
        ClientTransportFactory transportFactory = this.newClientTransportFactory();
        transportFactory.close();
        transportFactory.newClientTransport((SocketAddress)new InetSocketAddress("localhost", port), "localhost:" + port);
    }
}

