/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing;

import com.google.common.base.Preconditions;
import com.google.common.truth.ComparableSubject;
import com.google.common.truth.FailureStrategy;
import com.google.common.truth.SubjectFactory;
import io.grpc.Deadline;
import java.math.BigInteger;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class DeadlineSubject
extends ComparableSubject<DeadlineSubject, Deadline> {
    private static final SubjectFactory<DeadlineSubject, Deadline> deadlineFactory = new DeadlineSubjectFactory();

    public static SubjectFactory<DeadlineSubject, Deadline> deadline() {
        return deadlineFactory;
    }

    private DeadlineSubject(FailureStrategy failureStrategy, Deadline subject) {
        super(failureStrategy, (Comparable)subject);
    }

    @CheckReturnValue
    public TolerantDeadlineComparison isWithin(final long delta, final TimeUnit timeUnit) {
        return new TolerantDeadlineComparison(){

            @Override
            public void of(Deadline expected) {
                Deadline actual = (Deadline)DeadlineSubject.this.getSubject();
                Preconditions.checkNotNull((Object)actual, (String)"actual value cannot be null. expected=%s", (Object[])new Object[]{expected});
                BigInteger actualTimeRemaining = BigInteger.valueOf(actual.timeRemaining(TimeUnit.NANOSECONDS));
                BigInteger expectedTimeRemaining = BigInteger.valueOf(expected.timeRemaining(TimeUnit.NANOSECONDS));
                BigInteger deltaNanos = BigInteger.valueOf(timeUnit.toNanos(delta));
                if (actualTimeRemaining.subtract(expectedTimeRemaining).abs().compareTo(deltaNanos) > 0) {
                    DeadlineSubject.this.failWithRawMessage("%s and <%s> should have been within <%sns> of each other", new Object[]{DeadlineSubject.this.getDisplaySubject(), expected, deltaNanos});
                }
            }
        };
    }

    private static final class DeadlineSubjectFactory
    extends SubjectFactory<DeadlineSubject, Deadline> {
        private DeadlineSubjectFactory() {
        }

        public DeadlineSubject getSubject(FailureStrategy fs, Deadline that) {
            return new DeadlineSubject(fs, that);
        }
    }

    public abstract class TolerantDeadlineComparison {
        private TolerantDeadlineComparison() {
        }

        public abstract void of(Deadline var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare deadlines, use .of(Deadline) instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

