/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.testing;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import java.util.Arrays;
import java.util.HashSet;

public class TestUtils {
    public static ServerInterceptor echoRequestHeadersInterceptor(Metadata.Key<?> ... keys) {
        final HashSet keySet = new HashSet(Arrays.asList(keys));
        return new ServerInterceptor(){

            public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(String method, ServerCall<RespT> call, final Metadata.Headers requestHeaders, ServerCallHandler<ReqT, RespT> next) {
                ServerCall.Listener listener = next.startCall(method, (ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<RespT>(call){
                    boolean sentHeaders;

                    public void sendHeaders(Metadata.Headers responseHeaders) {
                        responseHeaders.merge((Metadata)requestHeaders, keySet);
                        super.sendHeaders(responseHeaders);
                        this.sentHeaders = true;
                    }

                    public void sendPayload(RespT payload) {
                        if (!this.sentHeaders) {
                            this.sendHeaders(new Metadata.Headers());
                        }
                        super.sendPayload(payload);
                    }

                    public void close(Status status, Metadata.Trailers trailers) {
                        trailers.merge((Metadata)requestHeaders, keySet);
                        super.close(status, trailers);
                    }
                }, requestHeaders);
                return listener;
            }
        };
    }

    private TestUtils() {
    }
}

