/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import com.google.common.base.Charsets;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import io.grpc.Metadata;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ClientStream;
import io.grpc.internal.ClientStreamListener;
import io.grpc.internal.ClientTransport;
import io.grpc.internal.InternalServer;
import io.grpc.internal.ManagedClientTransport;
import io.grpc.internal.ServerListener;
import io.grpc.internal.ServerStream;
import io.grpc.internal.ServerStreamListener;
import io.grpc.internal.ServerTransport;
import io.grpc.internal.ServerTransportListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.junit.runners.JUnit4;
import org.mockito.ArgumentCaptor;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;

@RunWith(value=JUnit4.class)
public abstract class AbstractTransportTest {
    private static int TIMEOUT_MS = 1000;
    private InternalServer server;
    private ServerTransport serverTransport;
    private ManagedClientTransport client;
    private MethodDescriptor<String, String> methodDescriptor = MethodDescriptor.create((MethodDescriptor.MethodType)MethodDescriptor.MethodType.UNKNOWN, (String)"service/method", (MethodDescriptor.Marshaller)StringMarshaller.INSTANCE, (MethodDescriptor.Marshaller)StringMarshaller.INSTANCE);
    private Metadata.Key<String> asciiKey = Metadata.Key.of((String)"ascii-key", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private Metadata.Key<String> binaryKey = Metadata.Key.of((String)"key-bin", (Metadata.BinaryMarshaller)StringBinaryMarshaller.INSTANCE);
    private ManagedClientTransport.Listener mockClientTransportListener = (ManagedClientTransport.Listener)Mockito.mock(ManagedClientTransport.Listener.class);
    private ClientStreamListener mockClientStreamListener = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
    private MockServerListener serverListener = new MockServerListener();
    private ArgumentCaptor<Status> statusCaptor = ArgumentCaptor.forClass(Status.class);
    private ArgumentCaptor<Throwable> throwableCaptor = ArgumentCaptor.forClass(Throwable.class);
    private ArgumentCaptor<Metadata> metadataCaptor = ArgumentCaptor.forClass(Metadata.class);
    private ArgumentCaptor<InputStream> inputStreamCaptor = ArgumentCaptor.forClass(InputStream.class);
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    protected abstract InternalServer newServer();

    protected abstract InternalServer newServer(InternalServer var1);

    protected abstract ManagedClientTransport newClientTransport(InternalServer var1);

    @Before
    public void setUp() {
        this.server = this.newServer();
    }

    @After
    public void tearDown() throws InterruptedException {
        if (this.client != null) {
            this.client.shutdownNow(Status.UNKNOWN.withDescription("teardown"));
        }
        if (this.serverTransport != null) {
            this.serverTransport.shutdownNow(Status.UNKNOWN.withDescription("teardown"));
        }
        if (this.server != null) {
            this.server.shutdown();
            Assert.assertTrue((boolean)this.serverListener.waitForShutdown(TIMEOUT_MS, TimeUnit.MILLISECONDS));
        }
    }

    @Test
    public void frameAfterRstStreamShouldNotBreakClientChannel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata());
        stream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        stream.flush();
        stream.writeMessage(this.methodDescriptor.streamRequest((Object)"foo"));
        stream.flush();
        stream.cancel(Status.CANCELLED);
        stream.flush();
        serverStreamCreation.stream.writeHeaders(new Metadata());
        serverStreamCreation.stream.flush();
        serverStreamCreation.stream.writeMessage(this.methodDescriptor.streamResponse((Object)"bar"));
        serverStreamCreation.stream.flush();
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)250))).closed((Status)Matchers.eq((Object)Status.CANCELLED), (Metadata)Matchers.any(Metadata.class));
        ClientStreamListener mockClientStreamListener2 = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
        stream = this.client.newStream(this.methodDescriptor, new Metadata());
        stream.start(mockClientStreamListener2);
        serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        serverStreamCreation.stream.writeHeaders(new Metadata());
        serverStreamCreation.stream.flush();
        ((ClientStreamListener)Mockito.verify((Object)mockClientStreamListener2, (VerificationMode)Mockito.timeout((int)250))).headersRead((Metadata)Matchers.any(Metadata.class));
    }

    @Test
    public void serverNotListening() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.server.shutdown();
        Assert.assertTrue((boolean)this.serverListener.waitForShutdown(TIMEOUT_MS, TimeUnit.MILLISECONDS));
        this.server = null;
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockClientTransportListener});
        this.client.start(this.mockClientTransportListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportTerminated();
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportShutdown((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.UNAVAILABLE, (Status)this.statusCaptor.getValue());
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportReady();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void clientStartStop() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockClientTransportListener});
        this.client.start(this.mockClientTransportListener);
        this.client.shutdown();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportTerminated();
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportShutdown((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.UNAVAILABLE, (Status)this.statusCaptor.getValue());
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void clientStartAndStopOnceConnected() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{this.mockClientTransportListener});
        this.client.start(this.mockClientTransportListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportReady();
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.client.shutdown();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportTerminated();
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportShutdown((Status)Matchers.any(Status.class));
        ((ManagedClientTransport.Listener)inOrder.verify((Object)this.mockClientTransportListener)).transportTerminated();
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(TIMEOUT_MS, TimeUnit.MILLISECONDS));
        this.server.shutdown();
        Assert.assertTrue((boolean)this.serverListener.waitForShutdown(TIMEOUT_MS, TimeUnit.MILLISECONDS));
        this.server = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void serverAlreadyListening() throws Exception {
        this.client = null;
        this.server.start((ServerListener)this.serverListener);
        InternalServer server2 = this.newServer(this.server);
        this.thrown.expect(IOException.class);
        server2.start((ServerListener)new MockServerListener());
    }

    @Test
    public void openStreamPreventsTermination() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(this.mockClientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportInUse(true);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        this.client.shutdown();
        this.client = null;
        this.server.shutdown();
        this.serverTransport.shutdown();
        this.serverTransport = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportShutdown((Status)Matchers.any(Status.class));
        Assert.assertTrue((boolean)this.serverListener.waitForShutdown(TIMEOUT_MS, TimeUnit.MILLISECONDS));
        this.serverListener = new MockServerListener();
        this.server = this.newServer(this.server);
        this.server.start((ServerListener)this.serverListener);
        serverStream.writeHeaders(new Metadata());
        clientStream.halfClose();
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).headersRead((Metadata)Matchers.any(Metadata.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).halfClosed();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(false);
        Assert.assertFalse((boolean)serverTransportListener.isTerminated());
        clientStream.cancel(Status.CANCELLED);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportInUse(false);
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(TIMEOUT_MS, TimeUnit.MILLISECONDS));
    }

    @Test
    public void shutdownNowKillsClientStream() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(this.mockClientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportInUse(true);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        Status status = Status.UNKNOWN.withDescription("test shutdownNow");
        this.client.shutdownNow(status);
        this.client = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportShutdown((Status)Matchers.any(Status.class));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportInUse(false);
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(TIMEOUT_MS, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverTransportListener.isTerminated());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)Matchers.same((Object)status), (Metadata)Matchers.any(Metadata.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)Matchers.any(Status.class));
    }

    @Test
    public void shutdownNowKillsServerStream() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(this.mockClientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportInUse(true);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        this.serverTransport.shutdownNow(Status.UNKNOWN.withDescription("test shutdownNow"));
        this.serverTransport = null;
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportShutdown((Status)Matchers.any(Status.class));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportTerminated();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportInUse(false);
        Assert.assertTrue((boolean)serverTransportListener.waitForTermination(TIMEOUT_MS, TimeUnit.MILLISECONDS));
        Assert.assertTrue((boolean)serverTransportListener.isTerminated());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)Matchers.any(Status.class));
    }

    @Test
    public void ping() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        ClientTransport.PingCallback mockPingCallback = (ClientTransport.PingCallback)Mockito.mock(ClientTransport.PingCallback.class);
        try {
            this.client.ping(mockPingCallback, MoreExecutors.directExecutor());
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeTrue((boolean)false);
        }
        ((ClientTransport.PingCallback)Mockito.verify((Object)mockPingCallback, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).onSuccess((long)Matchers.anyInt());
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
    }

    @Test
    public void ping_duringShutdown() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata());
        stream.start(this.mockClientStreamListener);
        this.client.shutdown();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportShutdown((Status)Matchers.any(Status.class));
        ClientTransport.PingCallback mockPingCallback = (ClientTransport.PingCallback)Mockito.mock(ClientTransport.PingCallback.class);
        try {
            this.client.ping(mockPingCallback, MoreExecutors.directExecutor());
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeTrue((boolean)false);
        }
        ((ClientTransport.PingCallback)Mockito.verify((Object)mockPingCallback, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).onSuccess((long)Matchers.anyInt());
        stream.cancel(Status.CANCELLED);
    }

    @Test
    public void ping_afterTermination() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportReady();
        this.client.shutdown();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportTerminated();
        ClientTransport.PingCallback mockPingCallback = (ClientTransport.PingCallback)Mockito.mock(ClientTransport.PingCallback.class);
        try {
            this.client.ping(mockPingCallback, MoreExecutors.directExecutor());
        }
        catch (UnsupportedOperationException ex) {
            Assume.assumeTrue((boolean)false);
        }
        ((ClientTransport.PingCallback)Mockito.verify((Object)mockPingCallback, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).onFailure((Throwable)this.throwableCaptor.capture());
        Status status = Status.fromThrowable((Throwable)((Throwable)this.throwableCaptor.getValue()));
        String stackTrace = "";
        if (Status.UNAVAILABLE.getCode() != status.getCode() && status.getCause() != null) {
            stackTrace = Throwables.getStackTraceAsString((Throwable)status.getCause());
        }
        AbstractTransportTest.assertCodeEquals(stackTrace, Status.UNAVAILABLE, status);
    }

    @Test
    public void newStream_duringShutdown() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata());
        stream.start(this.mockClientStreamListener);
        this.client.shutdown();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportShutdown((Status)Matchers.any(Status.class));
        ClientStream stream2 = this.client.newStream(this.methodDescriptor, new Metadata());
        ClientStreamListener mockClientStreamListener2 = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
        stream2.start(mockClientStreamListener2);
        ((ClientStreamListener)Mockito.verify((Object)mockClientStreamListener2, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        AbstractTransportTest.assertCodeEquals(Status.UNAVAILABLE, (Status)this.statusCaptor.getValue());
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        serverStreamCreation.stream.close(Status.OK, new Metadata());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
    }

    @Test
    public void newStream_afterTermination() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportReady();
        this.client.shutdown();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportTerminated();
        Thread.sleep(100L);
        ClientStream stream = this.client.newStream(this.methodDescriptor, new Metadata());
        stream.start(this.mockClientStreamListener);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(Matchers.anyBoolean());
        AbstractTransportTest.assertCodeEquals(Status.UNAVAILABLE, (Status)this.statusCaptor.getValue());
    }

    @Test
    public void transportInUse_normalClose() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        ClientStream stream1 = this.client.newStream(this.methodDescriptor, new Metadata());
        stream1.start(this.mockClientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportInUse(true);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation1 = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ClientStream stream2 = this.client.newStream(this.methodDescriptor, new Metadata());
        stream2.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation2 = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        stream1.halfClose();
        serverStreamCreation1.stream.close(Status.OK, new Metadata());
        stream2.halfClose();
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(false);
        serverStreamCreation2.stream.close(Status.OK, new Metadata());
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportInUse(false);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(true);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(false);
    }

    @Test
    public void transportInUse_clientCancel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        ClientStream stream1 = this.client.newStream(this.methodDescriptor, new Metadata());
        stream1.start(this.mockClientStreamListener);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportInUse(true);
        ClientStream stream2 = this.client.newStream(this.methodDescriptor, new Metadata());
        stream2.start(this.mockClientStreamListener);
        stream1.cancel(Status.CANCELLED);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.never())).transportInUse(false);
        stream2.cancel(Status.CANCELLED);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).transportInUse(false);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(true);
        ((ManagedClientTransport.Listener)Mockito.verify((Object)this.mockClientTransportListener)).transportInUse(false);
    }

    @Test
    public void basicStream() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        Metadata clientHeaders = new Metadata();
        clientHeaders.put(this.asciiKey, (Object)"client");
        clientHeaders.put(this.asciiKey, (Object)"dupvalue");
        clientHeaders.put(this.asciiKey, (Object)"dupvalue");
        clientHeaders.put(this.binaryKey, (Object)"\u00e4binaryclient");
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, clientHeaders);
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)this.methodDescriptor.getFullMethodName(), (Object)serverStreamCreation.method);
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)clientHeaders.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)serverStreamCreation.headers.getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)clientHeaders.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)serverStreamCreation.headers.getAll(this.binaryKey)));
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        serverStream.request(1);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).onReady();
        Assert.assertTrue((boolean)clientStream.isReady());
        clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)"Hello!"));
        clientStream.flush();
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).messageRead((InputStream)this.inputStreamCaptor.capture());
        Assert.assertEquals((Object)"Hello!", (Object)this.methodDescriptor.parseRequest((InputStream)this.inputStreamCaptor.getValue()));
        ((InputStream)this.inputStreamCaptor.getValue()).close();
        clientStream.halfClose();
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).halfClosed();
        Metadata serverHeaders = new Metadata();
        serverHeaders.put(this.asciiKey, (Object)"server");
        serverHeaders.put(this.asciiKey, (Object)"dupvalue");
        serverHeaders.put(this.asciiKey, (Object)"dupvalue");
        serverHeaders.put(this.binaryKey, (Object)"\u00e4binaryserver");
        serverStream.writeHeaders(serverHeaders);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).headersRead((Metadata)this.metadataCaptor.capture());
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)serverHeaders.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)serverHeaders.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.binaryKey)));
        clientStream.request(1);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).onReady();
        Assert.assertTrue((boolean)serverStream.isReady());
        serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)"Hi. Who are you?"));
        serverStream.flush();
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).messageRead((InputStream)this.inputStreamCaptor.capture());
        Assert.assertEquals((Object)"Hi. Who are you?", (Object)this.methodDescriptor.parseResponse((InputStream)this.inputStreamCaptor.getValue()));
        ((InputStream)this.inputStreamCaptor.getValue()).close();
        Status status = Status.OK.withDescription("That was normal");
        Metadata trailers = new Metadata();
        trailers.put(this.asciiKey, (Object)"trailers");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.binaryKey, (Object)"\u00e4binarytrailers");
        serverStream.close(status, trailers);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture(), (Metadata)this.metadataCaptor.capture());
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)((Status)this.statusCaptor.getValue()).getDescription());
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.binaryKey)));
    }

    @Test
    public void zeroMessageStream() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        clientStream.halfClose();
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).halfClosed();
        serverStream.writeHeaders(new Metadata());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).headersRead((Metadata)Matchers.any(Metadata.class));
        Status status = Status.OK.withDescription("Nice talking to you");
        serverStream.close(status, new Metadata());
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)((Status)this.statusCaptor.getValue()).getDescription());
    }

    @Test
    public void earlyServerClose_withServerHeaders() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        serverStream.writeHeaders(new Metadata());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).headersRead((Metadata)Matchers.any(Metadata.class));
        Status status = Status.OK.withDescription("Hello. Goodbye.").withCause((Throwable)new Exception());
        serverStream.close(status, new Metadata());
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)"Hello. Goodbye.", (Object)((Status)this.statusCaptor.getValue()).getDescription());
        Assert.assertNull((Object)((Status)this.statusCaptor.getValue()).getCause());
    }

    @Test
    public void earlyServerClose_noServerHeaders() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        Status status = Status.OK.withDescription("Hellogoodbye").withCause((Throwable)new Exception());
        Metadata trailers = new Metadata();
        trailers.put(this.asciiKey, (Object)"trailers");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.asciiKey, (Object)"dupvalue");
        trailers.put(this.binaryKey, (Object)"\u00e4binarytrailers");
        serverStream.close(status, trailers);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture(), (Metadata)this.metadataCaptor.capture());
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)"Hellogoodbye", (Object)((Status)this.statusCaptor.getValue()).getDescription());
        Assert.assertNull((Object)((Status)this.statusCaptor.getValue()).getCause());
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.asciiKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.asciiKey)));
        Assert.assertEquals((Object)Lists.newArrayList((Iterable)trailers.getAll(this.binaryKey)), (Object)Lists.newArrayList((Iterable)((Metadata)this.metadataCaptor.getValue()).getAll(this.binaryKey)));
    }

    @Test
    public void earlyServerClose_serverFailure() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        Status status = Status.INTERNAL.withDescription("I'm not listening").withCause((Throwable)new Exception());
        serverStream.close(status, new Metadata());
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)((Status)this.statusCaptor.getValue()).getDescription());
        Assert.assertNull((Object)((Status)this.statusCaptor.getValue()).getCause());
    }

    @Test
    public void clientCancel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        Status status = Status.CANCELLED.withDescription("Nevermind").withCause((Throwable)new Exception());
        clientStream.cancel(status);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)Matchers.same((Object)status), (Metadata)Matchers.any(Metadata.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture());
        Assert.assertNotEquals((Object)Status.Code.OK, (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertNull((Object)((Status)this.statusCaptor.getValue()).getCause());
        Mockito.reset((Object[])new ServerStreamListener[]{mockServerStreamListener});
        Mockito.reset((Object[])new ClientStreamListener[]{this.mockClientStreamListener});
        clientStream.cancel(status);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class));
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
    }

    @Test(timeout=5000L)
    public void clientCancelFromWithinMessageRead() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        final SettableFuture closedCalled = SettableFuture.create();
        final ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(new ClientStreamListener(){

            public void headersRead(Metadata headers) {
            }

            public void closed(Status status, Metadata trailers) {
                Assert.assertEquals((Object)Status.CANCELLED.getCode(), (Object)status.getCode());
                Assert.assertEquals((Object)"nevermind", (Object)status.getDescription());
                closedCalled.set((Object)true);
            }

            public void messageRead(InputStream message) {
                Assert.assertEquals((Object)"foo", (Object)AbstractTransportTest.this.methodDescriptor.parseResponse(message));
                clientStream.cancel(Status.CANCELLED.withDescription("nevermind"));
            }

            public void onReady() {
            }
        });
        clientStream.halfClose();
        clientStream.request(1);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)this.methodDescriptor.getFullMethodName(), (Object)serverStreamCreation.method);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).onReady();
        Assert.assertTrue((boolean)serverStream.isReady());
        serverStream.writeHeaders(new Metadata());
        serverStream.writeMessage(this.methodDescriptor.streamRequest((Object)"foo"));
        serverStream.flush();
        closedCalled.get();
        serverStream.close(Status.OK, new Metadata());
    }

    @Test
    public void serverCancel() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        Status status = Status.DEADLINE_EXCEEDED.withDescription("It was bound to happen").withCause((Throwable)new Exception());
        serverStream.cancel(status);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)Matchers.same((Object)status));
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        AbstractTransportTest.assertCodeEquals(Status.CANCELLED, (Status)this.statusCaptor.getValue());
        Assert.assertNull((Object)((Status)this.statusCaptor.getValue()).getCause());
        Mockito.reset((Object[])new ServerStreamListener[]{mockServerStreamListener});
        Mockito.reset((Object[])new ClientStreamListener[]{this.mockClientStreamListener});
        serverStream.cancel(status);
        this.doPingPong(this.serverListener);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class));
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
    }

    @Test
    public void flowControlPushBack() throws Exception {
        this.server.start((ServerListener)this.serverListener);
        this.client = this.newClientTransport(this.server);
        this.client.start(this.mockClientTransportListener);
        MockServerTransportListener serverTransportListener = this.serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        this.serverTransport = serverTransportListener.transport;
        ClientStream clientStream = this.client.newStream(this.methodDescriptor, new Metadata());
        clientStream.start(this.mockClientStreamListener);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        Assert.assertEquals((Object)this.methodDescriptor.getFullMethodName(), (Object)serverStreamCreation.method);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        serverStream.writeHeaders(new Metadata());
        Answer<Void> closeStream = new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Exception {
                Object[] args = invocation.getArguments();
                ((InputStream)args[0]).close();
                return null;
            }
        };
        int size = 1024;
        StringBuffer sb = new StringBuffer(size);
        for (int i = 0; i < size; ++i) {
            sb.append('a');
        }
        String largeMessage = sb.toString();
        ((ServerStreamListener)Mockito.doAnswer((Answer)closeStream).when((Object)mockServerStreamListener)).messageRead((InputStream)Matchers.any(InputStream.class));
        serverStream.request(1);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).onReady();
        Assert.assertTrue((boolean)clientStream.isReady());
        int maxToSend = 10240;
        int clientSent = 0;
        while (clientStream.isReady()) {
            if (clientSent > 10240) {
                Assert.fail((String)"Too many messages sent before isReady() returned false");
            }
            clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)largeMessage));
            clientStream.flush();
            ++clientSent;
        }
        Assert.assertTrue((clientSent > 0 ? 1 : 0) != 0);
        while (clientSent < 5) {
            clientStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            clientStream.flush();
            ++clientSent;
        }
        this.doPingPong(this.serverListener);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).messageRead((InputStream)Matchers.any(InputStream.class));
        ((ClientStreamListener)Mockito.doAnswer((Answer)closeStream).when((Object)this.mockClientStreamListener)).messageRead((InputStream)Matchers.any(InputStream.class));
        clientStream.request(1);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).onReady();
        Assert.assertTrue((boolean)serverStream.isReady());
        int serverSent = 0;
        while (serverStream.isReady()) {
            if (serverSent > 10240) {
                Assert.fail((String)"Too many messages sent before isReady() returned false");
            }
            serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            serverStream.flush();
            ++serverSent;
        }
        Assert.assertTrue((serverSent > 0 ? 1 : 0) != 0);
        while (serverSent < 5) {
            serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            serverStream.flush();
            ++serverSent;
        }
        this.doPingPong(this.serverListener);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).messageRead((InputStream)Matchers.any(InputStream.class));
        serverStream.request(3);
        clientStream.request(3);
        this.doPingPong(this.serverListener);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(4))).messageRead((InputStream)Matchers.any(InputStream.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(4))).messageRead((InputStream)Matchers.any(InputStream.class));
        serverStream.request(clientSent);
        clientStream.request(serverSent);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(clientSent))).messageRead((InputStream)Matchers.any(InputStream.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(serverSent))).messageRead((InputStream)Matchers.any(InputStream.class));
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(2))).onReady();
        Assert.assertTrue((boolean)clientStream.isReady());
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(2))).onReady();
        Assert.assertTrue((boolean)serverStream.isReady());
        for (int i = 0; i < 5; ++i) {
            clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)largeMessage));
            clientStream.flush();
            serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
            serverStream.flush();
        }
        this.doPingPong(this.serverListener);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(clientSent + 4))).messageRead((InputStream)Matchers.any(InputStream.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(serverSent + 4))).messageRead((InputStream)Matchers.any(InputStream.class));
        serverStream.request(1);
        clientStream.request(1);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(serverSent + 5))).messageRead((InputStream)Matchers.any(InputStream.class));
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(clientSent + 5))).messageRead((InputStream)Matchers.any(InputStream.class));
        clientStream.writeMessage(this.methodDescriptor.streamRequest((Object)largeMessage));
        clientStream.flush();
        clientStream.halfClose();
        this.doPingPong(this.serverListener);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.never())).halfClosed();
        serverStream.request(1);
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(serverSent + 6))).messageRead((InputStream)Matchers.any(InputStream.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).halfClosed();
        serverStream.writeMessage(this.methodDescriptor.streamResponse((Object)largeMessage));
        serverStream.flush();
        Status status = Status.OK.withDescription("... quite a lengthy discussion");
        serverStream.close(status, new Metadata());
        this.doPingPong(this.serverListener);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.never())).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
        clientStream.request(1);
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS).times(clientSent + 6))).messageRead((InputStream)Matchers.any(InputStream.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture());
        AbstractTransportTest.assertCodeEquals(Status.OK, (Status)this.statusCaptor.getValue());
        ((ClientStreamListener)Mockito.verify((Object)this.mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)this.statusCaptor.capture(), (Metadata)Matchers.any(Metadata.class));
        Assert.assertEquals((Object)status.getCode(), (Object)((Status)this.statusCaptor.getValue()).getCode());
        Assert.assertEquals((Object)status.getDescription(), (Object)((Status)this.statusCaptor.getValue()).getDescription());
    }

    private void doPingPong(MockServerListener serverListener) throws InterruptedException {
        ManagedClientTransport client = this.newClientTransport(this.server);
        client.start((ManagedClientTransport.Listener)Mockito.mock(ManagedClientTransport.Listener.class));
        ClientStream clientStream = client.newStream(this.methodDescriptor, new Metadata());
        ClientStreamListener mockClientStreamListener = (ClientStreamListener)Mockito.mock(ClientStreamListener.class);
        clientStream.start(mockClientStreamListener);
        MockServerTransportListener serverTransportListener = serverListener.takeListenerOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        StreamCreation serverStreamCreation = serverTransportListener.takeStreamOrFail(TIMEOUT_MS, TimeUnit.MILLISECONDS);
        ServerStream serverStream = serverStreamCreation.stream;
        ServerStreamListener mockServerStreamListener = serverStreamCreation.listener;
        serverStream.close(Status.OK, new Metadata());
        ((ClientStreamListener)Mockito.verify((Object)mockClientStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)Matchers.any(Status.class), (Metadata)Matchers.any(Metadata.class));
        ((ServerStreamListener)Mockito.verify((Object)mockServerStreamListener, (VerificationMode)Mockito.timeout((int)TIMEOUT_MS))).closed((Status)Matchers.any(Status.class));
        client.shutdown();
    }

    private static void assertCodeEquals(String message, Status expected, Status actual) {
        if (expected == null) {
            Assert.fail((String)"expected should not be null");
        }
        if (actual == null || !expected.getCode().equals((Object)actual.getCode())) {
            Assert.assertEquals((String)message, (Object)expected, (Object)actual);
        }
    }

    private static void assertCodeEquals(Status expected, Status actual) {
        AbstractTransportTest.assertCodeEquals(null, expected, actual);
    }

    private static boolean waitForFuture(Future<?> future, long timeout, TimeUnit unit) throws InterruptedException {
        try {
            future.get(timeout, unit);
        }
        catch (ExecutionException ex) {
            throw new AssertionError((Object)ex);
        }
        catch (TimeoutException ex) {
            return false;
        }
        return true;
    }

    private static class StringBinaryMarshaller
    implements Metadata.BinaryMarshaller<String> {
        public static final StringBinaryMarshaller INSTANCE = new StringBinaryMarshaller();

        private StringBinaryMarshaller() {
        }

        public byte[] toBytes(String value) {
            return value.getBytes(Charsets.UTF_8);
        }

        public String parseBytes(byte[] serialized) {
            return new String(serialized, Charsets.UTF_8);
        }
    }

    private static class StringMarshaller
    implements MethodDescriptor.Marshaller<String> {
        public static final StringMarshaller INSTANCE = new StringMarshaller();

        private StringMarshaller() {
        }

        public InputStream stream(String value) {
            return new ByteArrayInputStream(value.getBytes(Charsets.UTF_8));
        }

        public String parse(InputStream stream) {
            try {
                return new String(ByteStreams.toByteArray((InputStream)stream), Charsets.UTF_8);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private static class StreamCreation {
        public final ServerStream stream;
        public final String method;
        public final Metadata headers;
        public final ServerStreamListener listener;

        public StreamCreation(ServerStream stream, String method, Metadata headers, ServerStreamListener listener) {
            this.stream = stream;
            this.method = method;
            this.headers = headers;
            this.listener = listener;
        }
    }

    private static class MockServerTransportListener
    implements ServerTransportListener {
        public final ServerTransport transport;
        public final BlockingQueue<StreamCreation> streams = new LinkedBlockingQueue<StreamCreation>();
        private final SettableFuture<?> terminated = SettableFuture.create();

        public MockServerTransportListener(ServerTransport transport) {
            this.transport = transport;
        }

        public ServerStreamListener streamCreated(ServerStream stream, String method, Metadata headers) {
            ServerStreamListener listener = (ServerStreamListener)Mockito.mock(ServerStreamListener.class);
            this.streams.add(new StreamCreation(stream, method, headers, listener));
            return listener;
        }

        public void transportTerminated() {
            Assert.assertTrue((boolean)this.terminated.set(null));
        }

        public boolean waitForTermination(long timeout, TimeUnit unit) throws InterruptedException {
            return AbstractTransportTest.waitForFuture(this.terminated, timeout, unit);
        }

        public boolean isTerminated() {
            return this.terminated.isDone();
        }

        public StreamCreation takeStreamOrFail(long timeout, TimeUnit unit) throws InterruptedException {
            StreamCreation stream = this.streams.poll(timeout, unit);
            if (stream == null) {
                Assert.fail((String)"Timed out waiting for server stream");
            }
            return stream;
        }
    }

    private static class MockServerListener
    implements ServerListener {
        public final BlockingQueue<MockServerTransportListener> listeners = new LinkedBlockingQueue<MockServerTransportListener>();
        private final SettableFuture<?> shutdown = SettableFuture.create();

        private MockServerListener() {
        }

        public ServerTransportListener transportCreated(ServerTransport transport) {
            MockServerTransportListener listener = new MockServerTransportListener(transport);
            this.listeners.add(listener);
            return listener;
        }

        public void serverShutdown() {
            Assert.assertTrue((boolean)this.shutdown.set(null));
        }

        public boolean waitForShutdown(long timeout, TimeUnit unit) throws InterruptedException {
            return AbstractTransportTest.waitForFuture(this.shutdown, timeout, unit);
        }

        public MockServerTransportListener takeListenerOrFail(long timeout, TimeUnit unit) throws InterruptedException {
            MockServerTransportListener listener = this.listeners.poll(timeout, unit);
            if (listener == null) {
                Assert.fail((String)"Timed out waiting for server transport");
            }
            return listener;
        }
    }
}

