/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.instrumentation.stats.MeasurementDescriptor;
import com.google.instrumentation.stats.MeasurementMap;
import com.google.instrumentation.stats.MeasurementValue;
import com.google.instrumentation.stats.StatsContext;
import com.google.instrumentation.stats.StatsContextFactory;
import com.google.instrumentation.stats.TagKey;
import com.google.instrumentation.stats.TagValue;
import io.grpc.internal.IoUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class StatsTestUtils {
    public static final TagKey EXTRA_TAG = TagKey.create((String)"/rpc/test/extratag");
    private static final String EXTRA_TAG_HEADER_VALUE_PREFIX = "extratag:";
    private static final String NO_EXTRA_TAG_HEADER_VALUE_PREFIX = "noextratag";

    private StatsTestUtils() {
    }

    private static class FakeStatsContextBuilder
    extends StatsContext.Builder {
        private final ImmutableMap.Builder<TagKey, TagValue> tagsBuilder = ImmutableMap.builder();
        private final FakeStatsContext base;

        private FakeStatsContextBuilder(FakeStatsContext base) {
            this.base = base;
            this.tagsBuilder.putAll((Map)base.tags);
        }

        public StatsContext.Builder set(TagKey key, TagValue value) {
            this.tagsBuilder.put((Object)key, (Object)value);
            return this;
        }

        public StatsContext build() {
            FakeStatsContext context = new FakeStatsContext(this.tagsBuilder.build(), this.base.factory);
            ((FakeStatsContext)this.base).factory.contexts.add(context);
            return context;
        }
    }

    public static class FakeStatsContext
    extends StatsContext {
        private final ImmutableMap<TagKey, TagValue> tags;
        private final FakeStatsContextFactory factory;
        private final BlockingQueue<MetricsRecord> recordSink;

        private FakeStatsContext(ImmutableMap<TagKey, TagValue> tags, FakeStatsContextFactory factory) {
            this.tags = tags;
            this.factory = factory;
            this.recordSink = factory.getCurrentRecordSink();
        }

        public StatsContext.Builder builder() {
            return new FakeStatsContextBuilder(this);
        }

        public StatsContext record(MeasurementMap metrics) {
            this.recordSink.add(new MetricsRecord(this.tags, metrics));
            return this;
        }

        public void serialize(OutputStream os) {
            TagValue extraTagValue = (TagValue)this.tags.get((Object)EXTRA_TAG);
            try {
                if (extraTagValue == null) {
                    os.write(StatsTestUtils.NO_EXTRA_TAG_HEADER_VALUE_PREFIX.getBytes(Charsets.UTF_8));
                } else {
                    os.write((StatsTestUtils.EXTRA_TAG_HEADER_VALUE_PREFIX + extraTagValue.toString()).getBytes(Charsets.UTF_8));
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public String toString() {
            return "[tags=" + this.tags + "]";
        }

        public boolean equals(Object other) {
            if (!(other instanceof FakeStatsContext)) {
                return false;
            }
            FakeStatsContext otherCtx = (FakeStatsContext)((Object)other);
            return this.tags.equals(otherCtx.tags);
        }

        public int hashCode() {
            return this.tags.hashCode();
        }
    }

    public static final class FakeStatsContextFactory
    extends StatsContextFactory {
        private BlockingQueue<MetricsRecord> records;
        public final BlockingQueue<FakeStatsContext> contexts = new LinkedBlockingQueue<FakeStatsContext>();
        private final FakeStatsContext defaultContext;

        public FakeStatsContextFactory() {
            this.rolloverRecords();
            this.defaultContext = new FakeStatsContext(ImmutableMap.of(), this);
            this.rolloverRecords();
        }

        public StatsContext pollContextOrFail() {
            StatsContext cc = (StatsContext)this.contexts.poll();
            return (StatsContext)Preconditions.checkNotNull((Object)cc);
        }

        public MetricsRecord pollRecord() {
            return (MetricsRecord)this.getCurrentRecordSink().poll();
        }

        public MetricsRecord pollRecord(long timeout, TimeUnit unit) throws InterruptedException {
            return this.getCurrentRecordSink().poll(timeout, unit);
        }

        public StatsContext deserialize(InputStream buffer) throws IOException {
            String serializedString;
            try {
                serializedString = new String(IoUtils.toByteArray((InputStream)buffer), Charsets.UTF_8);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (serializedString.startsWith(StatsTestUtils.EXTRA_TAG_HEADER_VALUE_PREFIX)) {
                return this.getDefault().with(EXTRA_TAG, TagValue.create((String)serializedString.substring(StatsTestUtils.EXTRA_TAG_HEADER_VALUE_PREFIX.length())));
            }
            if (serializedString.startsWith(StatsTestUtils.NO_EXTRA_TAG_HEADER_VALUE_PREFIX)) {
                return this.getDefault();
            }
            throw new IOException("Malformed value");
        }

        public FakeStatsContext getDefault() {
            return this.defaultContext;
        }

        public synchronized void rolloverRecords() {
            this.records = new LinkedBlockingQueue<MetricsRecord>();
        }

        private synchronized BlockingQueue<MetricsRecord> getCurrentRecordSink() {
            return this.records;
        }
    }

    public static class MetricsRecord {
        public final ImmutableMap<TagKey, TagValue> tags;
        public final MeasurementMap metrics;

        private MetricsRecord(ImmutableMap<TagKey, TagValue> tags, MeasurementMap metrics) {
            this.tags = tags;
            this.metrics = metrics;
        }

        @Nullable
        public Double getMetric(MeasurementDescriptor metricName) {
            for (MeasurementValue m : this.metrics) {
                if (!m.getMeasurement().equals(metricName)) continue;
                return m.getValue();
            }
            return null;
        }

        public long getMetricAsLongOrFail(MeasurementDescriptor metricName) {
            Double doubleValue = this.getMetric(metricName);
            Preconditions.checkNotNull((Object)doubleValue, (String)"Metric not found: %s", (Object[])new Object[]{metricName.toString()});
            long longValue = (long)(Math.abs(doubleValue) + 1.0E-4);
            if (doubleValue < 0.0) {
                longValue = -longValue;
            }
            return longValue;
        }
    }
}

