/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import io.grpc.ServerCall;
import io.grpc.ServerStreamTracer;
import io.grpc.Status;
import io.grpc.internal.testing.TestStreamTracer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class TestServerStreamTracer
extends ServerStreamTracer
implements TestStreamTracer {
    private final TestStreamTracer.TestBaseStreamTracer delegate = new TestStreamTracer.TestBaseStreamTracer();
    protected final AtomicReference<ServerCall<?, ?>> serverCall = new AtomicReference();

    @Override
    public void await() throws InterruptedException {
        this.delegate.await();
    }

    @Override
    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.delegate.await(timeout, timeUnit);
    }

    public ServerCall<?, ?> getServerCall() {
        return this.serverCall.get();
    }

    @Override
    public int getInboundMessageCount() {
        return this.delegate.getInboundMessageCount();
    }

    @Override
    public Status getStatus() {
        return this.delegate.getStatus();
    }

    @Override
    public long getInboundWireSize() {
        return this.delegate.getInboundWireSize();
    }

    @Override
    public long getInboundUncompressedSize() {
        return this.delegate.getInboundUncompressedSize();
    }

    @Override
    public int getOutboundMessageCount() {
        return this.delegate.getOutboundMessageCount();
    }

    @Override
    public long getOutboundWireSize() {
        return this.delegate.getOutboundWireSize();
    }

    @Override
    public long getOutboundUncompressedSize() {
        return this.delegate.getOutboundUncompressedSize();
    }

    public void outboundWireSize(long bytes) {
        this.delegate.outboundWireSize(bytes);
    }

    public void inboundWireSize(long bytes) {
        this.delegate.inboundWireSize(bytes);
    }

    public void outboundUncompressedSize(long bytes) {
        this.delegate.outboundUncompressedSize(bytes);
    }

    public void inboundUncompressedSize(long bytes) {
        this.delegate.inboundUncompressedSize(bytes);
    }

    public void streamClosed(Status status) {
        this.delegate.streamClosed(status);
    }

    public void inboundMessage() {
        this.delegate.inboundMessage();
    }

    public void outboundMessage() {
        this.delegate.outboundMessage();
    }

    public void serverCallStarted(ServerCall<?, ?> call) {
        if (!this.serverCall.compareAndSet(null, call) && this.delegate.failDuplicateCallbacks.get()) {
            throw new AssertionError((Object)"serverCallStarted called more than once");
        }
    }
}

