/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Duration;
import com.google.protobuf.Struct;
import com.google.protobuf.Value;
import com.google.protobuf.util.Durations;
import io.grpc.Channel;
import io.grpc.InternalLogId;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.stub.StreamObserver;
import io.grpc.xds.LoadStatsStore;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.ClusterStats;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadReportingServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.load_stats.v2.LoadStatsResponse;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
final class LoadReportClient {
    @VisibleForTesting
    static final String TARGET_NAME_METADATA_KEY = "PROXYLESS_CLIENT_HOSTNAME";
    private final XdsLogger logger;
    private final ManagedChannel channel;
    private final Node node;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timerService;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final Stopwatch retryStopwatch;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Map<String, Map<String, LoadStatsStore>> loadStatsStoreMap = new HashMap<String, Map<String, LoadStatsStore>>();
    private boolean started;
    @Nullable
    private BackoffPolicy lrsRpcRetryPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle lrsRpcRetryTimer;
    @Nullable
    private LrsStream lrsStream;
    @Nullable
    private LoadReportCallback callback;

    LoadReportClient(InternalLogId logId, String targetName, ManagedChannel channel, Node node, SynchronizationContext syncContext, ScheduledExecutorService scheduledExecutorService, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier) {
        this.channel = (ManagedChannel)Preconditions.checkNotNull((Object)channel, (Object)"channel");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)syncContext, (Object)"syncContext");
        this.timerService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)scheduledExecutorService, (Object)"timeService");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        this.retryStopwatch = (Stopwatch)stopwatchSupplier.get();
        Preconditions.checkNotNull((Object)targetName, (Object)"targetName");
        Preconditions.checkNotNull((Object)node, (Object)"node");
        Struct metadata = node.getMetadata().toBuilder().putFields(TARGET_NAME_METADATA_KEY, Value.newBuilder().setStringValue(targetName).build()).build();
        this.node = node.toBuilder().setMetadata(metadata).build();
        String logPrefix = ((InternalLogId)Preconditions.checkNotNull((Object)logId, (Object)"logId")).toString().concat("-lrs-client");
        this.logger = XdsLogger.withPrefix(logPrefix);
    }

    void startLoadReporting(LoadReportCallback callback) {
        if (this.started) {
            return;
        }
        this.callback = callback;
        this.started = true;
        this.startLrsRpc();
    }

    void stopLoadReporting() {
        if (!this.started) {
            return;
        }
        if (this.lrsRpcRetryTimer != null) {
            this.lrsRpcRetryTimer.cancel();
        }
        if (this.lrsStream != null) {
            this.lrsStream.close((Exception)Status.CANCELLED.withDescription("stop load reporting").asException());
        }
        this.started = false;
    }

    void addLoadStatsStore(String clusterName, @Nullable String clusterServiceName, LoadStatsStore loadStatsStore) {
        Preconditions.checkState((!this.loadStatsStoreMap.containsKey(clusterName) || !this.loadStatsStoreMap.get(clusterName).containsKey(clusterServiceName) ? 1 : 0) != 0, (String)"load stats for cluster: %s, cluster service: %s already exists", (Object)clusterName, (Object)clusterServiceName);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Add load stats for cluster: {0}, cluster_service: {1}", clusterName, clusterServiceName);
        if (!this.loadStatsStoreMap.containsKey(clusterName)) {
            this.loadStatsStoreMap.put(clusterName, new HashMap());
        }
        Map<String, LoadStatsStore> clusterLoadStatsStores = this.loadStatsStoreMap.get(clusterName);
        clusterLoadStatsStores.put(clusterServiceName, loadStatsStore);
    }

    void removeLoadStatsStore(String clusterName, @Nullable String clusterServiceName) {
        Preconditions.checkState((this.loadStatsStoreMap.containsKey(clusterName) && this.loadStatsStoreMap.get(clusterName).containsKey(clusterServiceName) ? 1 : 0) != 0, (String)"load stats for cluster: %s, cluster service: %s does not exist", (Object)clusterName, (Object)clusterServiceName);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Remove load stats for cluster: {0}, cluster_service: {1}", clusterName, clusterServiceName);
        Map<String, LoadStatsStore> clusterLoadStatsStores = this.loadStatsStoreMap.get(clusterName);
        clusterLoadStatsStores.remove(clusterServiceName);
        if (clusterLoadStatsStores.isEmpty()) {
            this.loadStatsStoreMap.remove(clusterName);
        }
    }

    private void startLrsRpc() {
        Preconditions.checkState((this.lrsStream == null ? 1 : 0) != 0, (Object)"previous lbStream has not been cleared yet");
        LoadReportingServiceGrpc.LoadReportingServiceStub stub = LoadReportingServiceGrpc.newStub((Channel)this.channel);
        this.lrsStream = new LrsStream(stub, (Stopwatch)this.stopwatchSupplier.get());
        this.retryStopwatch.reset().start();
        this.lrsStream.start();
    }

    static interface LoadReportCallback {
        public void onReportResponse(long var1);
    }

    private class LrsStream
    implements StreamObserver<LoadStatsResponse> {
        final Set<String> clusterNames = new HashSet<String>();
        final LoadReportingServiceGrpc.LoadReportingServiceStub stub;
        final Stopwatch reportStopwatch;
        StreamObserver<LoadStatsRequest> lrsRequestWriter;
        boolean initialResponseReceived;
        boolean closed;
        long loadReportIntervalNano = -1L;
        SynchronizationContext.ScheduledHandle loadReportTimer;

        LrsStream(LoadReportingServiceGrpc.LoadReportingServiceStub stub, Stopwatch stopwatch) {
            this.stub = (LoadReportingServiceGrpc.LoadReportingServiceStub)((Object)Preconditions.checkNotNull((Object)((Object)stub), (Object)"stub"));
            this.reportStopwatch = (Stopwatch)Preconditions.checkNotNull((Object)stopwatch, (Object)"stopwatch");
        }

        void start() {
            this.lrsRequestWriter = ((LoadReportingServiceGrpc.LoadReportingServiceStub)this.stub.withWaitForReady()).streamLoadStats(this);
            this.reportStopwatch.reset().start();
            LoadStatsRequest initRequest = LoadStatsRequest.newBuilder().setNode(LoadReportClient.this.node).build();
            this.lrsRequestWriter.onNext((Object)initRequest);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Initial LRS request sent:\n{0}", initRequest);
        }

        public void onNext(final LoadStatsResponse response) {
            LoadReportClient.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LrsStream.this.handleResponse(response);
                }
            });
        }

        public void onError(final Throwable t) {
            LoadReportClient.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LrsStream.this.handleStreamClosed(Status.fromThrowable((Throwable)t));
                }
            });
        }

        public void onCompleted() {
            LoadReportClient.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    LrsStream.this.handleStreamClosed(Status.UNAVAILABLE.withDescription("Closed by server"));
                }
            });
        }

        private void sendLoadReport() {
            long interval = this.reportStopwatch.elapsed(TimeUnit.NANOSECONDS);
            this.reportStopwatch.reset().start();
            LoadStatsRequest.Builder requestBuilder = LoadStatsRequest.newBuilder().setNode(LoadReportClient.this.node);
            for (String name : this.clusterNames) {
                if (!LoadReportClient.this.loadStatsStoreMap.containsKey(name)) continue;
                Map clusterLoadStatsStores = (Map)LoadReportClient.this.loadStatsStoreMap.get(name);
                for (LoadStatsStore statsStore : clusterLoadStatsStores.values()) {
                    ClusterStats report = statsStore.generateLoadReport().toBuilder().setLoadReportInterval(Durations.fromNanos((long)interval)).build();
                    requestBuilder.addClusterStats(report);
                }
            }
            LoadStatsRequest request = requestBuilder.build();
            this.lrsRequestWriter.onNext((Object)request);
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent LoadStatsRequest\n{0}", request);
            this.scheduleNextLoadReport();
        }

        private void scheduleNextLoadReport() {
            if (this.loadReportTimer != null && this.loadReportTimer.isPending()) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (this.loadReportIntervalNano > 0L) {
                this.loadReportTimer = LoadReportClient.this.syncContext.schedule((Runnable)new LoadReportingTask(this), this.loadReportIntervalNano, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void handleResponse(LoadStatsResponse response) {
            if (this.closed) {
                return;
            }
            if (!this.initialResponseReceived) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received LRS initial response:\n{0}", response);
                this.initialResponseReceived = true;
            } else {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received LRS response:\n{0}", response);
            }
            long interval = Durations.toNanos((Duration)response.getLoadReportingInterval());
            if (interval != this.loadReportIntervalNano) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Update load reporting interval to {0} ns", interval);
                this.loadReportIntervalNano = interval;
                LoadReportClient.this.callback.onReportResponse(this.loadReportIntervalNano);
            }
            if (this.clusterNames.size() != response.getClustersCount() || !this.clusterNames.containsAll((Collection<?>)response.getClustersList())) {
                LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Update load reporting clusters to {0}", response.getClustersList());
                this.clusterNames.clear();
                this.clusterNames.addAll((Collection<String>)response.getClustersList());
            }
            this.scheduleNextLoadReport();
        }

        private void handleStreamClosed(Status status) {
            Preconditions.checkArgument((!status.isOk() ? 1 : 0) != 0, (Object)"unexpected OK status");
            if (this.closed) {
                return;
            }
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, "LRS stream closed with status {0}: {1}. Cause: {2}", status.getCode(), status.getDescription(), status.getCause());
            this.closed = true;
            this.cleanUp();
            long delayNanos = 0L;
            if (this.initialResponseReceived || LoadReportClient.this.lrsRpcRetryPolicy == null) {
                LoadReportClient.this.lrsRpcRetryPolicy = LoadReportClient.this.backoffPolicyProvider.get();
            }
            if (!this.initialResponseReceived) {
                delayNanos = LoadReportClient.this.lrsRpcRetryPolicy.nextBackoffNanos() - LoadReportClient.this.retryStopwatch.elapsed(TimeUnit.NANOSECONDS);
            }
            LoadReportClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry LRS stream in {0} ns", delayNanos);
            if (delayNanos <= 0L) {
                LoadReportClient.this.startLrsRpc();
            } else {
                LoadReportClient.this.lrsRpcRetryTimer = LoadReportClient.this.syncContext.schedule((Runnable)new LrsRpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, LoadReportClient.this.timerService);
            }
        }

        private void close(@Nullable Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            if (error == null) {
                this.lrsRequestWriter.onCompleted();
            } else {
                this.lrsRequestWriter.onError((Throwable)error);
            }
        }

        private void cleanUp() {
            if (this.loadReportTimer != null) {
                this.loadReportTimer.cancel();
                this.loadReportTimer = null;
            }
            if (LoadReportClient.this.lrsStream == this) {
                LoadReportClient.this.lrsStream = null;
            }
        }
    }

    @VisibleForTesting
    class LrsRpcRetryTask
    implements Runnable {
        LrsRpcRetryTask() {
        }

        @Override
        public void run() {
            LoadReportClient.this.startLrsRpc();
        }
    }

    @VisibleForTesting
    static class LoadReportingTask
    implements Runnable {
        private final LrsStream stream;

        LoadReportingTask(LrsStream stream) {
            this.stream = stream;
        }

        @Override
        public void run() {
            this.stream.sendLoadReport();
        }
    }
}

