/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.XdsLoadBalancer;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public final class XdsLoadBalancerProvider
extends LoadBalancerProvider {
    static final String XDS_POLICY_NAME = "xds_experimental";
    private static final ServiceConfigUtil.LbConfig DEFAULT_FALLBACK_POLICY = new ServiceConfigUtil.LbConfig("round_robin", (Map)ImmutableMap.of());

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return XDS_POLICY_NAME;
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new XdsLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        return XdsLoadBalancerProvider.parseLoadBalancingConfigPolicy(rawLoadBalancingPolicyConfig, LoadBalancerRegistry.getDefaultRegistry());
    }

    static NameResolver.ConfigOrError parseLoadBalancingConfigPolicy(Map<String, ?> rawLoadBalancingPolicyConfig, LoadBalancerRegistry registry) {
        try {
            String cluster = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"cluster");
            ServiceConfigUtil.LbConfig childPolicy = XdsLoadBalancerProvider.selectChildPolicy(rawLoadBalancingPolicyConfig, registry);
            ServiceConfigUtil.LbConfig fallbackPolicy = XdsLoadBalancerProvider.selectFallbackPolicy(rawLoadBalancingPolicyConfig, registry);
            String edsServiceName = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"edsServiceName");
            String lrsServerName = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"lrsLoadReportingServerName");
            return NameResolver.ConfigOrError.fromConfig((Object)new XdsConfig(cluster, childPolicy, fallbackPolicy, edsServiceName, lrsServerName));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.fromThrowable((Throwable)e).withDescription("Failed to parse XDS LB config: " + rawLoadBalancingPolicyConfig));
        }
    }

    @VisibleForTesting
    static ServiceConfigUtil.LbConfig selectFallbackPolicy(Map<String, ?> rawLoadBalancingPolicyConfig, LoadBalancerRegistry lbRegistry) {
        List fallbackConfigs = ServiceConfigUtil.unwrapLoadBalancingConfigList((List)JsonUtil.getListOfObjects(rawLoadBalancingPolicyConfig, (String)"fallbackPolicy"));
        ServiceConfigUtil.LbConfig fallbackPolicy = XdsLoadBalancerProvider.selectSupportedLbPolicy(fallbackConfigs, lbRegistry);
        return fallbackPolicy == null ? DEFAULT_FALLBACK_POLICY : fallbackPolicy;
    }

    @Nullable
    @VisibleForTesting
    static ServiceConfigUtil.LbConfig selectChildPolicy(Map<String, ?> rawLoadBalancingPolicyConfig, LoadBalancerRegistry lbRegistry) {
        List childConfigs = ServiceConfigUtil.unwrapLoadBalancingConfigList((List)JsonUtil.getListOfObjects(rawLoadBalancingPolicyConfig, (String)"childPolicy"));
        return XdsLoadBalancerProvider.selectSupportedLbPolicy(childConfigs, lbRegistry);
    }

    @Nullable
    private static ServiceConfigUtil.LbConfig selectSupportedLbPolicy(@Nullable List<ServiceConfigUtil.LbConfig> lbConfigs, LoadBalancerRegistry lbRegistry) {
        if (lbConfigs == null) {
            return null;
        }
        for (ServiceConfigUtil.LbConfig lbConfig : lbConfigs) {
            String lbPolicy = lbConfig.getPolicyName();
            if (lbRegistry.getProvider(lbPolicy) == null) continue;
            return lbConfig;
        }
        return null;
    }

    static final class XdsConfig {
        @Nullable
        final String cluster;
        @Nullable
        final ServiceConfigUtil.LbConfig childPolicy;
        @Nullable
        final ServiceConfigUtil.LbConfig fallbackPolicy;
        @Nullable
        final String edsServiceName;
        @Nullable
        final String lrsServerName;

        XdsConfig(@Nullable String cluster, @Nullable ServiceConfigUtil.LbConfig childPolicy, @Nullable ServiceConfigUtil.LbConfig fallbackPolicy, @Nullable String edsServiceName, @Nullable String lrsServerName) {
            this.cluster = cluster;
            this.childPolicy = childPolicy;
            this.fallbackPolicy = fallbackPolicy;
            this.edsServiceName = edsServiceName;
            this.lrsServerName = lrsServerName;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("cluster", (Object)this.cluster).add("childPolicy", (Object)this.childPolicy).add("fallbackPolicy", (Object)this.fallbackPolicy).add("edsServiceName", (Object)this.edsServiceName).add("lrsServerName", (Object)this.lrsServerName).toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof XdsConfig)) {
                return false;
            }
            XdsConfig that = (XdsConfig)obj;
            return Objects.equal((Object)this.cluster, (Object)that.cluster) && Objects.equal((Object)this.childPolicy, (Object)that.childPolicy) && Objects.equal((Object)this.fallbackPolicy, (Object)that.fallbackPolicy) && Objects.equal((Object)this.edsServiceName, (Object)that.edsServiceName) && Objects.equal((Object)this.lrsServerName, (Object)that.lrsServerName);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.cluster, this.childPolicy, this.fallbackPolicy, this.edsServiceName, this.lrsServerName});
        }
    }
}

