/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import io.grpc.Attributes;
import io.grpc.InternalLogId;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.GrpcAttributes;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.JsonParser;
import io.grpc.internal.ObjectPool;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Nullable;

final class XdsNameResolver
extends NameResolver {
    private final XdsLogger logger;
    private final String authority;
    private final XdsClient.XdsChannelFactory channelFactory;
    private final SynchronizationContext syncContext;
    private final ScheduledExecutorService timeService;
    private final NameResolver.ServiceConfigParser serviceConfigParser;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Supplier<Stopwatch> stopwatchSupplier;
    private final Bootstrapper bootstrapper;
    @Nullable
    private ObjectPool<XdsClient> xdsClientPool;
    @Nullable
    private XdsClient xdsClient;

    XdsNameResolver(String name, NameResolver.Args args, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, XdsClient.XdsChannelFactory channelFactory, Bootstrapper bootstrapper) {
        this.authority = GrpcUtil.checkAuthority((String)((String)Preconditions.checkNotNull((Object)name, (Object)"name")));
        this.channelFactory = (XdsClient.XdsChannelFactory)Preconditions.checkNotNull((Object)channelFactory, (Object)"channelFactory");
        this.syncContext = (SynchronizationContext)Preconditions.checkNotNull((Object)args.getSynchronizationContext(), (Object)"syncContext");
        this.timeService = (ScheduledExecutorService)Preconditions.checkNotNull((Object)args.getScheduledExecutorService(), (Object)"timeService");
        this.serviceConfigParser = (NameResolver.ServiceConfigParser)Preconditions.checkNotNull((Object)args.getServiceConfigParser(), (Object)"serviceConfigParser");
        this.backoffPolicyProvider = (BackoffPolicy.Provider)Preconditions.checkNotNull((Object)backoffPolicyProvider, (Object)"backoffPolicyProvider");
        this.stopwatchSupplier = (Supplier)Preconditions.checkNotNull(stopwatchSupplier, (Object)"stopwatchSupplier");
        this.bootstrapper = (Bootstrapper)Preconditions.checkNotNull((Object)bootstrapper, (Object)"bootstrapper");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"xds-resolver", (String)name));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created resolver for {0}", name);
    }

    public String getServiceAuthority() {
        return this.authority;
    }

    public void start(final NameResolver.Listener2 listener) {
        Bootstrapper.BootstrapInfo bootstrapInfo = null;
        try {
            bootstrapInfo = this.bootstrapper.readBootstrap();
        }
        catch (Exception e) {
            listener.onError(Status.UNAVAILABLE.withDescription("Failed to bootstrap").withCause((Throwable)e));
            return;
        }
        final List<Bootstrapper.ServerInfo> serverList = bootstrapInfo.getServers();
        final Node node = bootstrapInfo.getNode();
        if (serverList.isEmpty()) {
            listener.onError(Status.UNAVAILABLE.withDescription("No management server provided by bootstrap"));
            return;
        }
        XdsClient.XdsClientFactory xdsClientFactory = new XdsClient.XdsClientFactory(){

            @Override
            XdsClient createXdsClient() {
                return new XdsClientImpl(XdsNameResolver.this.authority, serverList, XdsNameResolver.this.channelFactory, node, XdsNameResolver.this.syncContext, XdsNameResolver.this.timeService, XdsNameResolver.this.backoffPolicyProvider, (Supplier<Stopwatch>)XdsNameResolver.this.stopwatchSupplier);
            }
        };
        this.xdsClientPool = new XdsClient.RefCountedXdsClientObjectPool(xdsClientFactory);
        this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        this.xdsClient.watchConfigData(this.authority, new XdsClient.ConfigWatcher(){

            @Override
            public void onConfigChanged(XdsClient.ConfigUpdate update) {
                Map config;
                XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received config update from xDS client {0}: cluster_name={1}", XdsNameResolver.this.xdsClient, update.getClusterName());
                String serviceConfig = "{\n  \"loadBalancingConfig\": [\n    {\n      \"cds_experimental\": {\n        \"cluster\": \"" + update.getClusterName() + "\"\n      }\n    }\n  ]\n}";
                try {
                    config = (Map)JsonParser.parse((String)serviceConfig);
                }
                catch (IOException e) {
                    listener.onError(Status.UNKNOWN.withDescription("Invalid service config").withCause((Throwable)e));
                    return;
                }
                XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Generated service config:\n{0}", serviceConfig);
                Attributes attrs = Attributes.newBuilder().set(GrpcAttributes.NAME_RESOLVER_SERVICE_CONFIG, (Object)config).set(XdsAttributes.XDS_CLIENT_POOL, (Object)XdsNameResolver.this.xdsClientPool).build();
                NameResolver.ConfigOrError parsedServiceConfig = XdsNameResolver.this.serviceConfigParser.parseServiceConfig(config);
                NameResolver.ResolutionResult result = NameResolver.ResolutionResult.newBuilder().setAddresses((List)ImmutableList.of()).setAttributes(attrs).setServiceConfig(parsedServiceConfig).build();
                listener.onResult(result);
            }

            @Override
            public void onError(Status error) {
                if (error.getCode().equals((Object)Status.Code.NOT_FOUND)) {
                    XdsNameResolver.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}", XdsNameResolver.this.xdsClient, error.getDescription());
                    listener.onResult(NameResolver.ResolutionResult.newBuilder().build());
                    return;
                }
                listener.onError(Status.UNAVAILABLE.withDescription(error.getDescription()));
            }
        });
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        if (this.xdsClient != null) {
            this.xdsClient = (XdsClient)this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }
}

