/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.shaded.io.envoyproxy.pgv;

import io.grpc.xds.shaded.io.envoyproxy.pgv.ValidationException;
import java.util.Comparator;

public final class ComparativeValidation {
    private ComparativeValidation() {
    }

    public static <T> void lessThan(String field, T value, T limit, Comparator<T> comparator) throws ValidationException {
        if (!ComparativeValidation.lt(comparator.compare(value, limit))) {
            throw new ValidationException(field, value, "must be less than " + limit.toString());
        }
    }

    public static <T> void lessThanOrEqual(String field, T value, T limit, Comparator<T> comparator) throws ValidationException {
        if (!ComparativeValidation.lte(comparator.compare(value, limit))) {
            throw new ValidationException(field, value, "must be less than or equal to " + limit.toString());
        }
    }

    public static <T> void greaterThan(String field, T value, T limit, Comparator<T> comparator) throws ValidationException {
        if (!ComparativeValidation.gt(comparator.compare(value, limit))) {
            throw new ValidationException(field, value, "must be greater than " + limit.toString());
        }
    }

    public static <T> void greaterThanOrEqual(String field, T value, T limit, Comparator<T> comparator) throws ValidationException {
        if (!ComparativeValidation.gte(comparator.compare(value, limit))) {
            throw new ValidationException(field, value, "must be greater than or equal to " + limit.toString());
        }
    }

    public static <T> void range(String field, T value, T lt, T lte, T gt, T gte, Comparator<T> comparator) throws ValidationException {
        boolean gtxInc;
        T ltx = ComparativeValidation.first(lt, lte);
        boolean ltxInc = lte != null;
        T gtx = ComparativeValidation.first(gt, gte);
        boolean bl = gtxInc = gte != null;
        if (ComparativeValidation.lte(comparator.compare(gtx, ltx))) {
            ComparativeValidation.between(field, value, gtx, gtxInc, ltx, ltxInc, comparator);
        } else {
            ComparativeValidation.outside(field, value, ltx, !ltxInc, gtx, !gtxInc, comparator);
        }
    }

    public static <T> void between(String field, T value, T lower, boolean lowerInclusive, T upper, boolean upperInclusive, Comparator<T> comparator) throws ValidationException {
        if (!ComparativeValidation.between(value, lower, lowerInclusive, upper, upperInclusive, comparator)) {
            throw new ValidationException(field, value, "must be in the range " + ComparativeValidation.range(lower, lowerInclusive, upper, upperInclusive));
        }
    }

    public static <T> void outside(String field, T value, T lower, boolean lowerInclusive, T upper, boolean upperInclusive, Comparator<T> comparator) throws ValidationException {
        if (ComparativeValidation.between(value, lower, lowerInclusive, upper, upperInclusive, comparator)) {
            throw new ValidationException(field, value, "must be outside the range " + ComparativeValidation.range(lower, lowerInclusive, upper, upperInclusive));
        }
    }

    private static <T> boolean between(T value, T lower, boolean lowerInclusive, T upper, boolean upperInclusive, Comparator<T> comparator) {
        return (lowerInclusive ? ComparativeValidation.gte(comparator.compare(value, lower)) : ComparativeValidation.gt(comparator.compare(value, lower))) && (upperInclusive ? ComparativeValidation.lte(comparator.compare(value, upper)) : ComparativeValidation.lt(comparator.compare(value, upper)));
    }

    private static <T> String range(T lower, boolean lowerInclusive, T upper, boolean upperInclusive) {
        return (lowerInclusive ? "[" : "(") + lower.toString() + ", " + upper.toString() + (upperInclusive ? "]" : ")");
    }

    private static boolean lt(int comparatorResult) {
        return comparatorResult < 0;
    }

    private static boolean lte(int comparatorResult) {
        return comparatorResult <= 0;
    }

    private static boolean gt(int comparatorResult) {
        return comparatorResult > 0;
    }

    private static boolean gte(int comparatorResult) {
        return comparatorResult >= 0;
    }

    private static <T> T first(T lhs, T rhs) {
        return lhs != null ? lhs : rhs;
    }
}

