/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.shaded.io.envoyproxy.pgv;

import io.grpc.xds.shaded.io.envoyproxy.pgv.Validator;
import io.grpc.xds.shaded.io.envoyproxy.pgv.ValidatorImpl;
import io.grpc.xds.shaded.io.envoyproxy.pgv.ValidatorIndex;
import java.util.concurrent.ConcurrentHashMap;

public final class ReflectiveValidatorIndex
implements ValidatorIndex {
    private final ConcurrentHashMap<Class, Validator> VALIDATOR_INDEX = new ConcurrentHashMap();
    private final ValidatorIndex fallbackIndex;

    public ReflectiveValidatorIndex() {
        this(ValidatorIndex.ALWAYS_VALID);
    }

    public ReflectiveValidatorIndex(ValidatorIndex fallbackIndex) {
        this.fallbackIndex = fallbackIndex;
    }

    @Override
    public <T> Validator<T> validatorFor(Class clazz) {
        return this.VALIDATOR_INDEX.computeIfAbsent(clazz, c -> {
            try {
                return this.reflectiveValidatorFor((Class)c);
            }
            catch (ReflectiveOperationException ex) {
                return this.fallbackIndex.validatorFor(clazz);
            }
        });
    }

    private Validator reflectiveValidatorFor(Class clazz) throws ReflectiveOperationException {
        Class<?> enclosingClass = clazz;
        while (enclosingClass.getEnclosingClass() != null) {
            enclosingClass = enclosingClass.getEnclosingClass();
        }
        String validatorClassName = enclosingClass.getName() + "Validator";
        Class<?> validatorClass = clazz.getClassLoader().loadClass(validatorClassName);
        ValidatorImpl impl = (ValidatorImpl)validatorClass.getDeclaredMethod("validatorFor", Class.class).invoke(null, clazz);
        return proto -> impl.assertValid(proto, this);
    }
}

