/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.shaded.io.envoyproxy.pgv;

import com.google.re2j.Pattern;
import io.grpc.xds.shaded.io.envoyproxy.pgv.ValidationException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.commons.validator.routines.DomainValidator;
import org.apache.commons.validator.routines.EmailValidator;
import org.apache.commons.validator.routines.InetAddressValidator;

public final class StringValidation {
    private static final int UUID_DASH_1 = 8;
    private static final int UUID_DASH_2 = 13;
    private static final int UUID_DASH_3 = 18;
    private static final int UUID_DASH_4 = 23;
    private static final int UUID_LEN = 36;

    private StringValidation() {
    }

    public static void length(String field, String value, int expected) throws ValidationException {
        int actual = value.codePointCount(0, value.length());
        if (actual != expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "length must be " + expected + " but got: " + actual);
        }
    }

    public static void minLength(String field, String value, int expected) throws ValidationException {
        int actual = value.codePointCount(0, value.length());
        if (actual < expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "length must be " + expected + " but got: " + actual);
        }
    }

    public static void maxLength(String field, String value, int expected) throws ValidationException {
        int actual = value.codePointCount(0, value.length());
        if (actual > expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "length must be " + expected + " but got: " + actual);
        }
    }

    public static void lenBytes(String field, String value, int expected) throws ValidationException {
        if (value.getBytes(StandardCharsets.UTF_8).length != expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "bytes length must be " + expected);
        }
    }

    public static void minBytes(String field, String value, int expected) throws ValidationException {
        if (value.getBytes(StandardCharsets.UTF_8).length < expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "bytes length must be at least " + expected);
        }
    }

    public static void maxBytes(String field, String value, int expected) throws ValidationException {
        if (value.getBytes(StandardCharsets.UTF_8).length > expected) {
            throw new ValidationException(field, StringValidation.enquote(value), "bytes length must be at maximum " + expected);
        }
    }

    public static void pattern(String field, String value, Pattern p) throws ValidationException {
        if (!p.matches(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "must match pattern " + p.pattern());
        }
    }

    public static void prefix(String field, String value, String prefix) throws ValidationException {
        if (!value.startsWith(prefix)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should start with " + prefix);
        }
    }

    public static void contains(String field, String value, String contains) throws ValidationException {
        if (!value.contains(contains)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should contain " + contains);
        }
    }

    public static void suffix(String field, String value, String suffix) throws ValidationException {
        if (!value.endsWith(suffix)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should end with " + suffix);
        }
    }

    public static void email(String field, String value) throws ValidationException {
        if (value.charAt(value.length() - 1) == '>') {
            char[] chars = value.toCharArray();
            StringBuilder sb = new StringBuilder();
            boolean insideQuotes = false;
            for (int i = chars.length - 2; i >= 0; --i) {
                char c = chars[i];
                if (c == '<') {
                    if (!insideQuotes) {
                        break;
                    }
                } else if (c == '\"') {
                    insideQuotes = !insideQuotes;
                }
                sb.append(c);
            }
            value = sb.reverse().toString();
        }
        if (!Lazy.EMAIL_VALIDATOR.isValid(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid email");
        }
    }

    public static void address(String field, String value) throws ValidationException {
        boolean validHost = StringValidation.isAscii(value) && DomainValidator.getInstance((boolean)true).isValid(value);
        boolean validIp = InetAddressValidator.getInstance().isValid(value);
        if (!validHost && !validIp) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid host, or an ip address.");
        }
    }

    public static void hostName(String field, String value) throws ValidationException {
        if (!StringValidation.isAscii(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid host containing only ascii characters");
        }
        DomainValidator domainValidator = DomainValidator.getInstance((boolean)true);
        if (!domainValidator.isValid(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid host");
        }
    }

    public static void ip(String field, String value) throws ValidationException {
        InetAddressValidator ipValidator = InetAddressValidator.getInstance();
        if (!ipValidator.isValid(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid ip address");
        }
    }

    public static void ipv4(String field, String value) throws ValidationException {
        InetAddressValidator ipValidator = InetAddressValidator.getInstance();
        if (!ipValidator.isValidInet4Address(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid ipv4 address");
        }
    }

    public static void ipv6(String field, String value) throws ValidationException {
        InetAddressValidator ipValidator = InetAddressValidator.getInstance();
        if (!ipValidator.isValidInet6Address(value)) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid ipv6 address");
        }
    }

    public static void uri(String field, String value) throws ValidationException {
        try {
            URI uri = new URI(value);
            if (!uri.isAbsolute()) {
                throw new ValidationException(field, StringValidation.enquote(value), "should be a valid absolute uri");
            }
        }
        catch (URISyntaxException ex) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid absolute uri");
        }
    }

    public static void uriRef(String field, String value) throws ValidationException {
        try {
            new URI(value);
        }
        catch (URISyntaxException ex) {
            throw new ValidationException(field, StringValidation.enquote(value), "should be a valid absolute uri");
        }
    }

    public static void uuid(String field, String value) throws ValidationException {
        block3: {
            char[] chars = value.toCharArray();
            if (chars.length == 36) {
                for (int i = 0; i < chars.length; ++i) {
                    char c = chars[i];
                    if (!(i == 8 || i == 13 || i == 18 || i == 23 ? c != '-' : !(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F'))) {
                        continue;
                    }
                    break block3;
                }
                return;
            }
        }
        throw new ValidationException(field, StringValidation.enquote(value), "invalid UUID string");
    }

    private static String enquote(String value) {
        return "\"" + value + "\"";
    }

    private static boolean isAscii(String value) {
        for (char c : value.toCharArray()) {
            if (c <= '\u007f') continue;
            return false;
        }
        return true;
    }

    private static class Lazy {
        static final EmailValidator EMAIL_VALIDATOR = EmailValidator.getInstance((boolean)true, (boolean)true);

        private Lazy() {
        }
    }
}

