/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import io.grpc.EquivalentAddressGroup;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.HealthStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.FractionalPercent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class EnvoyProtoData {
    private EnvoyProtoData() {
    }

    static final class DropOverload {
        private final String category;
        private final int dropsPerMillion;

        @VisibleForTesting
        DropOverload(String category, int dropsPerMillion) {
            this.category = category;
            this.dropsPerMillion = dropsPerMillion;
        }

        static DropOverload fromEnvoyProtoDropOverload(ClusterLoadAssignment.Policy.DropOverload proto) {
            FractionalPercent percent = proto.getDropPercentage();
            int numerator = percent.getNumerator();
            FractionalPercent.DenominatorType type = percent.getDenominator();
            switch (type) {
                case TEN_THOUSAND: {
                    numerator *= 100;
                    break;
                }
                case HUNDRED: {
                    numerator *= 10000;
                    break;
                }
                case MILLION: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown denominator type of " + percent);
                }
            }
            if (numerator > 1000000) {
                numerator = 1000000;
            }
            return new DropOverload(proto.getCategory(), numerator);
        }

        String getCategory() {
            return this.category;
        }

        int getDropsPerMillion() {
            return this.dropsPerMillion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DropOverload that = (DropOverload)o;
            return this.dropsPerMillion == that.dropsPerMillion && Objects.equal((Object)this.category, (Object)that.category);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.category, this.dropsPerMillion});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("category", (Object)this.category).add("dropsPerMillion", this.dropsPerMillion).toString();
        }
    }

    static final class LbEndpoint {
        private final EquivalentAddressGroup eag;
        private final int loadBalancingWeight;
        private final boolean isHealthy;

        @VisibleForTesting
        LbEndpoint(String address, int port, int loadBalancingWeight, boolean isHealthy) {
            this(new EquivalentAddressGroup((java.net.SocketAddress)new InetSocketAddress(address, port)), loadBalancingWeight, isHealthy);
        }

        @VisibleForTesting
        LbEndpoint(EquivalentAddressGroup eag, int loadBalancingWeight, boolean isHealthy) {
            this.eag = eag;
            this.loadBalancingWeight = loadBalancingWeight;
            this.isHealthy = isHealthy;
        }

        static LbEndpoint fromEnvoyProtoLbEndpoint(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LbEndpoint proto) {
            SocketAddress socketAddress = proto.getEndpoint().getAddress().getSocketAddress();
            InetSocketAddress addr = new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
            return new LbEndpoint(new EquivalentAddressGroup((List)ImmutableList.of((Object)addr)), proto.getLoadBalancingWeight().getValue(), proto.getHealthStatus() == HealthStatus.HEALTHY || proto.getHealthStatus() == HealthStatus.UNKNOWN);
        }

        EquivalentAddressGroup getAddress() {
            return this.eag;
        }

        int getLoadBalancingWeight() {
            return this.loadBalancingWeight;
        }

        boolean isHealthy() {
            return this.isHealthy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LbEndpoint that = (LbEndpoint)o;
            return this.loadBalancingWeight == that.loadBalancingWeight && Objects.equal((Object)this.eag, (Object)that.eag) && this.isHealthy == that.isHealthy;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.eag, this.loadBalancingWeight, this.isHealthy});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("eag", (Object)this.eag).add("loadBalancingWeight", this.loadBalancingWeight).add("isHealthy", this.isHealthy).toString();
        }
    }

    static final class LocalityLbEndpoints {
        private final List<LbEndpoint> endpoints;
        private final int localityWeight;
        private final int priority;

        @VisibleForTesting
        LocalityLbEndpoints(List<LbEndpoint> endpoints, int localityWeight, int priority) {
            this.endpoints = endpoints;
            this.localityWeight = localityWeight;
            this.priority = priority;
        }

        static LocalityLbEndpoints fromEnvoyProtoLocalityLbEndpoints(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LocalityLbEndpoints proto) {
            ArrayList<LbEndpoint> endpoints = new ArrayList<LbEndpoint>(proto.getLbEndpointsCount());
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LbEndpoint endpoint : proto.getLbEndpointsList()) {
                endpoints.add(LbEndpoint.fromEnvoyProtoLbEndpoint(endpoint));
            }
            return new LocalityLbEndpoints(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority());
        }

        List<LbEndpoint> getEndpoints() {
            return Collections.unmodifiableList(this.endpoints);
        }

        int getLocalityWeight() {
            return this.localityWeight;
        }

        int getPriority() {
            return this.priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalityLbEndpoints that = (LocalityLbEndpoints)o;
            return this.localityWeight == that.localityWeight && this.priority == that.priority && Objects.equal(this.endpoints, that.endpoints);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.endpoints, this.localityWeight, this.priority});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("endpoints", this.endpoints).add("localityWeight", this.localityWeight).add("priority", this.priority).toString();
        }
    }

    static final class Locality {
        private final String region;
        private final String zone;
        private final String subzone;

        @VisibleForTesting
        Locality(String region, String zone, String subzone) {
            this.region = region;
            this.zone = zone;
            this.subzone = subzone;
        }

        static Locality fromEnvoyProtoLocality(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality locality) {
            return new Locality(locality.getRegion(), locality.getZone(), locality.getSubZone());
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality toEnvoyProtoLocality() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality.newBuilder().setRegion(this.region).setZone(this.zone).setSubZone(this.subzone).build();
        }

        String getRegion() {
            return this.region;
        }

        String getZone() {
            return this.zone;
        }

        String getSubzone() {
            return this.subzone;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Locality locality = (Locality)o;
            return Objects.equal((Object)this.region, (Object)locality.region) && Objects.equal((Object)this.zone, (Object)locality.zone) && Objects.equal((Object)this.subzone, (Object)locality.subzone);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.region, this.zone, this.subzone});
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("region", (Object)this.region).add("zone", (Object)this.zone).add("subzone", (Object)this.subzone).toString();
        }
    }
}

