/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.DownstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Address;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

final class EnvoyServerProtoData {
    private EnvoyServerProtoData() {
    }

    static final class Listener {
        private final String name;
        @Nullable
        private final String address;
        private final List<FilterChain> filterChains;

        private Listener(String name, String address, List<FilterChain> filterChains) {
            this.name = name;
            this.address = address;
            this.filterChains = Collections.unmodifiableList(filterChains);
        }

        private static String convertEnvoyAddressToString(Address proto) {
            if (proto.hasSocketAddress()) {
                SocketAddress socketAddress = proto.getSocketAddress();
                String address = socketAddress.getAddress();
                switch (socketAddress.getPortSpecifierCase()) {
                    case NAMED_PORT: {
                        return address + ":" + socketAddress.getNamedPort();
                    }
                    case PORT_VALUE: {
                        return address + ":" + socketAddress.getPortValue();
                    }
                }
                return address;
            }
            return null;
        }

        static Listener fromEnvoyProtoListener(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.Listener proto) {
            ArrayList<FilterChain> filterChains = new ArrayList<FilterChain>(proto.getFilterChainsCount());
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.listener.FilterChain filterChain : proto.getFilterChainsList()) {
                filterChains.add(FilterChain.fromEnvoyProtoFilterChain(filterChain));
            }
            return new Listener(proto.getName(), Listener.convertEnvoyAddressToString(proto.getAddress()), filterChains);
        }

        public String getName() {
            return this.name;
        }

        public String getAddress() {
            return this.address;
        }

        public List<FilterChain> getFilterChains() {
            return this.filterChains;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Listener listener = (Listener)o;
            return Objects.equals(this.name, listener.name) && Objects.equals(this.address, listener.address) && Objects.equals(this.filterChains, listener.filterChains);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.address, this.filterChains);
        }

        public String toString() {
            return "Listener{name='" + this.name + '\'' + ", address='" + this.address + '\'' + ", filterChains=" + this.filterChains + '}';
        }
    }

    static final class FilterChain {
        private final FilterChainMatch filterChainMatch;
        private final DownstreamTlsContext downstreamTlsContext;

        private FilterChain(FilterChainMatch filterChainMatch, DownstreamTlsContext downstreamTlsContext) {
            this.filterChainMatch = filterChainMatch;
            this.downstreamTlsContext = downstreamTlsContext;
        }

        static FilterChain fromEnvoyProtoFilterChain(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.listener.FilterChain proto) {
            return new FilterChain(FilterChainMatch.fromEnvoyProtoFilterChainMatch(proto.getFilterChainMatch()), proto.getTlsContext());
        }

        public FilterChainMatch getFilterChainMatch() {
            return this.filterChainMatch;
        }

        public DownstreamTlsContext getDownstreamTlsContext() {
            return this.downstreamTlsContext;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterChain that = (FilterChain)o;
            return Objects.equals(this.filterChainMatch, that.filterChainMatch) && Objects.equals(this.downstreamTlsContext, that.downstreamTlsContext);
        }

        public int hashCode() {
            return Objects.hash(this.filterChainMatch, this.downstreamTlsContext);
        }

        public String toString() {
            return "FilterChain{filterChainMatch=" + this.filterChainMatch + ", downstreamTlsContext=" + this.downstreamTlsContext + '}';
        }
    }

    static final class FilterChainMatch {
        private final int destinationPort;
        private final List<CidrRange> prefixRanges;
        private final List<String> applicationProtocols;

        private FilterChainMatch(int destinationPort, List<CidrRange> prefixRanges, List<String> applicationProtocols) {
            this.destinationPort = destinationPort;
            this.prefixRanges = Collections.unmodifiableList(prefixRanges);
            this.applicationProtocols = Collections.unmodifiableList(applicationProtocols);
        }

        static FilterChainMatch fromEnvoyProtoFilterChainMatch(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.listener.FilterChainMatch proto) {
            ArrayList<CidrRange> prefixRanges = new ArrayList<CidrRange>();
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.CidrRange range : proto.getPrefixRangesList()) {
                prefixRanges.add(CidrRange.fromEnvoyProtoCidrRange(range));
            }
            ArrayList<String> applicationProtocols = new ArrayList<String>();
            for (String appProtocol : proto.getApplicationProtocolsList()) {
                applicationProtocols.add(appProtocol);
            }
            return new FilterChainMatch(proto.getDestinationPort().getValue(), prefixRanges, applicationProtocols);
        }

        public int getDestinationPort() {
            return this.destinationPort;
        }

        public List<CidrRange> getPrefixRanges() {
            return this.prefixRanges;
        }

        public List<String> getApplicationProtocols() {
            return this.applicationProtocols;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterChainMatch that = (FilterChainMatch)o;
            return this.destinationPort == that.destinationPort && Objects.equals(this.prefixRanges, that.prefixRanges) && Objects.equals(this.applicationProtocols, that.applicationProtocols);
        }

        public int hashCode() {
            return Objects.hash(this.destinationPort, this.prefixRanges, this.applicationProtocols);
        }

        public String toString() {
            return "FilterChainMatch{destinationPort=" + this.destinationPort + ", prefixRanges=" + this.prefixRanges + ", applicationProtocols=" + this.applicationProtocols + '}';
        }
    }

    static final class CidrRange {
        private final String addressPrefix;
        private final int prefixLen;

        @VisibleForTesting
        CidrRange(String addressPrefix, int prefixLen) {
            this.addressPrefix = addressPrefix;
            this.prefixLen = prefixLen;
        }

        static CidrRange fromEnvoyProtoCidrRange(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.CidrRange proto) {
            return new CidrRange(proto.getAddressPrefix(), proto.getPrefixLen().getValue());
        }

        public String getAddressPrefix() {
            return this.addressPrefix;
        }

        public int getPrefixLen() {
            return this.prefixLen;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CidrRange cidrRange = (CidrRange)o;
            return this.prefixLen == cidrRange.prefixLen && Objects.equals(this.addressPrefix, cidrRange.addressPrefix);
        }

        public int hashCode() {
            return Objects.hash(this.addressPrefix, this.prefixLen);
        }

        public String toString() {
            return "CidrRange{addressPrefix='" + this.addressPrefix + '\'' + ", prefixLen=" + this.prefixLen + '}';
        }
    }
}

