/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.grpc.ConnectivityState;
import io.grpc.EquivalentAddressGroup;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.Status;
import io.grpc.internal.ObjectPool;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.CdsLoadBalancerProvider;
import io.grpc.xds.XdsAttributes;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsLoadBalancerProvider;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.TlsContextManager;
import io.grpc.xds.internal.sds.TlsContextManagerImpl;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.UpstreamTlsContext;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public final class CdsLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancerRegistry lbRegistry;
    private final GracefulSwitchLoadBalancer switchingLoadBalancer;
    private final TlsContextManager tlsContextManager;
    @Nullable
    private String clusterName;
    @Nullable
    private ObjectPool<XdsClient> xdsClientPool;
    @Nullable
    private XdsClient xdsClient;

    CdsLoadBalancer(LoadBalancer.Helper helper) {
        this(helper, LoadBalancerRegistry.getDefaultRegistry(), TlsContextManagerImpl.getInstance());
    }

    @VisibleForTesting
    CdsLoadBalancer(LoadBalancer.Helper helper, LoadBalancerRegistry lbRegistry, TlsContextManager tlsContextManager) {
        Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.lbRegistry = lbRegistry;
        this.switchingLoadBalancer = new GracefulSwitchLoadBalancer(helper);
        this.tlsContextManager = tlsContextManager;
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"cds-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        if (this.xdsClientPool == null) {
            this.xdsClientPool = (ObjectPool)resolvedAddresses.getAttributes().get(XdsAttributes.XDS_CLIENT_POOL);
            Preconditions.checkNotNull(this.xdsClientPool, (Object)"missing xDS client pool");
            this.xdsClient = (XdsClient)this.xdsClientPool.getObject();
        }
        Object lbConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull((Object)lbConfig, (Object)"missing CDS lb config");
        CdsLoadBalancerProvider.CdsConfig newCdsConfig = (CdsLoadBalancerProvider.CdsConfig)lbConfig;
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received CDS lb config: cluster={0}", newCdsConfig.name);
        if (!newCdsConfig.name.equals(this.clusterName)) {
            ClusterBalancerFactory clusterBalancerFactory = new ClusterBalancerFactory(newCdsConfig.name);
            this.switchingLoadBalancer.switchTo((LoadBalancer.Factory)clusterBalancerFactory);
        }
        this.switchingLoadBalancer.handleResolvedAddresses(resolvedAddresses);
        this.clusterName = newCdsConfig.name;
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        this.switchingLoadBalancer.handleNameResolutionError(error);
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        this.switchingLoadBalancer.shutdown();
        if (this.xdsClientPool != null) {
            this.xdsClientPool.returnObject((Object)this.xdsClient);
        }
    }

    private final class ClusterWatcherImpl
    implements XdsClient.ClusterWatcher {
        final EdsLoadBalancingHelper helper;
        final LoadBalancer.ResolvedAddresses resolvedAddresses;
        @Nullable
        LoadBalancer edsBalancer;

        ClusterWatcherImpl(LoadBalancer.Helper helper, LoadBalancer.ResolvedAddresses resolvedAddresses) {
            this.helper = new EdsLoadBalancingHelper(helper, new AtomicReference<SslContextProvider<UpstreamTlsContext>>());
            this.resolvedAddresses = resolvedAddresses;
        }

        @Override
        public void onClusterChanged(XdsClient.ClusterUpdate newUpdate) {
            if (CdsLoadBalancer.this.logger.isLoggable(XdsLogger.XdsLogLevel.INFO)) {
                CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Received cluster update from xDS client {0}: cluster_name={1}, eds_service_name={2}, lb_policy={3}, report_load={4}", CdsLoadBalancer.this.xdsClient, newUpdate.getClusterName(), newUpdate.getEdsServiceName(), newUpdate.getLbPolicy(), newUpdate.getLrsServerName() != null);
            }
            Preconditions.checkArgument((boolean)newUpdate.getLbPolicy().equals("round_robin"), (Object)"can only support round_robin policy");
            LoadBalancerProvider lbProvider = CdsLoadBalancer.this.lbRegistry.getProvider(newUpdate.getLbPolicy());
            Object lbConfig = lbProvider.parseLoadBalancingPolicyConfig((Map)ImmutableMap.of()).getConfig();
            XdsLoadBalancerProvider.XdsConfig edsConfig = new XdsLoadBalancerProvider.XdsConfig(newUpdate.getClusterName(), new ServiceConfigUtil.PolicySelection(lbProvider, (Map)ImmutableMap.of(), lbConfig), null, newUpdate.getEdsServiceName(), newUpdate.getLrsServerName());
            this.updateSslContextProvider(newUpdate.getUpstreamTlsContext());
            if (this.edsBalancer == null) {
                this.edsBalancer = CdsLoadBalancer.this.lbRegistry.getProvider("eds_experimental").newLoadBalancer((LoadBalancer.Helper)this.helper);
            }
            this.edsBalancer.handleResolvedAddresses(this.resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig((Object)edsConfig).build());
        }

        private void updateSslContextProvider(UpstreamTlsContext newUpstreamTlsContext) {
            SslContextProvider oldSslContextProvider = (SslContextProvider)this.helper.sslContextProvider.get();
            if (oldSslContextProvider != null) {
                UpstreamTlsContext oldUpstreamTlsContext = (UpstreamTlsContext)oldSslContextProvider.getSource();
                if (oldUpstreamTlsContext.equals(newUpstreamTlsContext)) {
                    return;
                }
                CdsLoadBalancer.this.tlsContextManager.releaseClientSslContextProvider(oldSslContextProvider);
            }
            if (newUpstreamTlsContext != null) {
                SslContextProvider<UpstreamTlsContext> newSslContextProvider = CdsLoadBalancer.this.tlsContextManager.findOrCreateClientSslContextProvider(newUpstreamTlsContext);
                this.helper.sslContextProvider.set(newSslContextProvider);
            } else {
                this.helper.sslContextProvider.set(null);
            }
        }

        @Override
        public void onError(Status error) {
            CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received error from xDS client {0}: {1}: {2}", CdsLoadBalancer.this.xdsClient, error.getCode(), error.getDescription());
            if (this.edsBalancer == null) {
                this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, new XdsSubchannelPickers.ErrorPicker(error));
            }
        }
    }

    private static final class EdsLoadBalancingHelper
    extends ForwardingLoadBalancerHelper {
        private final LoadBalancer.Helper delegate;
        private final AtomicReference<SslContextProvider<UpstreamTlsContext>> sslContextProvider;

        EdsLoadBalancingHelper(LoadBalancer.Helper helper, AtomicReference<SslContextProvider<UpstreamTlsContext>> sslContextProvider) {
            this.delegate = helper;
            this.sslContextProvider = sslContextProvider;
        }

        public LoadBalancer.Subchannel createSubchannel(LoadBalancer.CreateSubchannelArgs createSubchannelArgs) {
            if (this.sslContextProvider.get() != null) {
                createSubchannelArgs = createSubchannelArgs.toBuilder().setAddresses(EdsLoadBalancingHelper.addUpstreamTlsContext(createSubchannelArgs.getAddresses(), this.sslContextProvider.get().getSource())).build();
            }
            return this.delegate.createSubchannel(createSubchannelArgs);
        }

        private static List<EquivalentAddressGroup> addUpstreamTlsContext(List<EquivalentAddressGroup> addresses, UpstreamTlsContext upstreamTlsContext) {
            if (upstreamTlsContext == null || addresses == null) {
                return addresses;
            }
            ArrayList<EquivalentAddressGroup> copyList = new ArrayList<EquivalentAddressGroup>(addresses.size());
            for (EquivalentAddressGroup eag : addresses) {
                EquivalentAddressGroup eagCopy = new EquivalentAddressGroup(eag.getAddresses(), eag.getAttributes().toBuilder().set(XdsAttributes.ATTR_UPSTREAM_TLS_CONTEXT, (Object)upstreamTlsContext).build());
                copyList.add(eagCopy);
            }
            return copyList;
        }

        protected LoadBalancer.Helper delegate() {
            return this.delegate;
        }
    }

    private final class ClusterBalancerFactory
    extends LoadBalancer.Factory {
        final String clusterName;

        ClusterBalancerFactory(String clusterName) {
            this.clusterName = clusterName;
        }

        public boolean equals(Object o) {
            if (!(o instanceof ClusterBalancerFactory)) {
                return false;
            }
            ClusterBalancerFactory that = (ClusterBalancerFactory)((Object)o);
            return this.clusterName.equals(that.clusterName);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.clusterName);
        }

        public LoadBalancer newLoadBalancer(final LoadBalancer.Helper helper) {
            return new LoadBalancer(){
                @Nullable
                ClusterWatcherImpl clusterWatcher;

                public void handleNameResolutionError(Status error) {
                    if (this.clusterWatcher == null || this.clusterWatcher.edsBalancer == null) {
                        helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
                    }
                }

                public boolean canHandleEmptyAddressListFromNameResolution() {
                    return true;
                }

                public void shutdown() {
                    if (this.clusterWatcher != null) {
                        if (this.clusterWatcher.edsBalancer != null) {
                            this.clusterWatcher.edsBalancer.shutdown();
                        }
                        CdsLoadBalancer.this.xdsClient.cancelClusterDataWatch(ClusterBalancerFactory.this.clusterName, this.clusterWatcher);
                        CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Cancelled cluster watcher on {0} with xDS client {1}", ClusterBalancerFactory.this.clusterName, CdsLoadBalancer.this.xdsClient);
                    }
                }

                public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
                    if (this.clusterWatcher == null) {
                        this.clusterWatcher = new ClusterWatcherImpl(helper, resolvedAddresses);
                        CdsLoadBalancer.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Start cluster watcher on {0} with xDS client {1}", ClusterBalancerFactory.this.clusterName, CdsLoadBalancer.this.xdsClient);
                        CdsLoadBalancer.this.xdsClient.watchClusterData(ClusterBalancerFactory.this.clusterName, this.clusterWatcher);
                    }
                }
            };
        }
    }
}

