/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.grpc.EquivalentAddressGroup;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.HealthStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.route.WeightedCluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.FractionalPercent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

final class EnvoyProtoData {
    private EnvoyProtoData() {
    }

    static final class ClusterWeight {
        private final String name;
        private final int weight;

        @VisibleForTesting
        ClusterWeight(String name, int weight) {
            this.name = name;
            this.weight = weight;
        }

        String getName() {
            return this.name;
        }

        int getWeight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterWeight that = (ClusterWeight)o;
            return this.weight == that.weight && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.weight);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("weight", this.weight).toString();
        }

        private static ClusterWeight fromEnvoyProtoClusterWeight(WeightedCluster.ClusterWeight proto) {
            return new ClusterWeight(proto.getName(), proto.getWeight().getValue());
        }
    }

    static final class RouteAction {
        private final String cluster;
        private final String clusterHeader;
        private final List<ClusterWeight> weightedCluster;

        @VisibleForTesting
        RouteAction(String cluster, String clusterHeader, List<ClusterWeight> weightedCluster) {
            this.cluster = cluster;
            this.clusterHeader = clusterHeader;
            this.weightedCluster = Collections.unmodifiableList(weightedCluster);
        }

        String getCluster() {
            return this.cluster;
        }

        String getClusterHeader() {
            return this.clusterHeader;
        }

        List<ClusterWeight> getWeightedCluster() {
            return this.weightedCluster;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteAction that = (RouteAction)o;
            return Objects.equals(this.cluster, that.cluster) && Objects.equals(this.clusterHeader, that.clusterHeader) && Objects.equals(this.weightedCluster, that.weightedCluster);
        }

        public int hashCode() {
            return Objects.hash(this.cluster, this.clusterHeader, this.weightedCluster);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("cluster", (Object)this.cluster).add("clusterHeader", (Object)this.clusterHeader).add("weightedCluster", this.weightedCluster).toString();
        }

        private static RouteAction fromEnvoyProtoRouteAction(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.route.RouteAction proto) {
            ArrayList<ClusterWeight> weightedCluster = new ArrayList<ClusterWeight>();
            List<WeightedCluster.ClusterWeight> clusterWeights = proto.getWeightedClusters().getClustersList();
            for (WeightedCluster.ClusterWeight clusterWeight : clusterWeights) {
                weightedCluster.add(ClusterWeight.fromEnvoyProtoClusterWeight(clusterWeight));
            }
            return new RouteAction(proto.getCluster(), proto.getClusterHeader(), weightedCluster);
        }
    }

    static final class RouteMatch {
        private final String prefix;
        private final String path;
        private final boolean hasRegex;

        @VisibleForTesting
        RouteMatch(String prefix, String path, boolean hasRegex) {
            this.prefix = prefix;
            this.path = path;
            this.hasRegex = hasRegex;
        }

        String getPrefix() {
            return this.prefix;
        }

        String getPath() {
            return this.path;
        }

        boolean hasRegex() {
            return this.hasRegex;
        }

        boolean isDefaultMatcher() {
            if (this.hasRegex) {
                return false;
            }
            if (!this.path.isEmpty()) {
                return false;
            }
            return this.prefix.isEmpty() || this.prefix.equals("/");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteMatch that = (RouteMatch)o;
            return this.hasRegex == that.hasRegex && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.path, that.path);
        }

        public int hashCode() {
            return Objects.hash(this.prefix, this.path, this.hasRegex);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("prefix", (Object)this.prefix).add("path", (Object)this.path).add("hasRegex", this.hasRegex).toString();
        }

        private static RouteMatch fromEnvoyProtoRouteMatch(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.route.RouteMatch proto) {
            return new RouteMatch(proto.getPrefix(), proto.getPath(), !proto.getRegex().isEmpty() || proto.hasSafeRegex());
        }
    }

    static final class Route {
        private final RouteMatch routeMatch;
        @Nullable
        private final RouteAction routeAction;

        @VisibleForTesting
        Route(RouteMatch routeMatch, @Nullable RouteAction routeAction) {
            this.routeMatch = routeMatch;
            this.routeAction = routeAction;
        }

        RouteMatch getRouteMatch() {
            return this.routeMatch;
        }

        @Nullable
        RouteAction getRouteAction() {
            return this.routeAction;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Route route = (Route)o;
            return Objects.equals(this.routeMatch, route.routeMatch) && Objects.equals(this.routeAction, route.routeAction);
        }

        public int hashCode() {
            return Objects.hash(this.routeMatch, this.routeAction);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("routeMatch", (Object)this.routeMatch).add("routeAction", (Object)this.routeAction).toString();
        }

        static Route fromEnvoyProtoRoute(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.route.Route proto) {
            RouteMatch routeMatch = RouteMatch.fromEnvoyProtoRouteMatch(proto.getMatch());
            RouteAction routeAction = null;
            if (proto.hasRoute()) {
                routeAction = RouteAction.fromEnvoyProtoRouteAction(proto.getRoute());
            }
            return new Route(routeMatch, routeAction);
        }
    }

    static final class DropOverload {
        private final String category;
        private final int dropsPerMillion;

        @VisibleForTesting
        DropOverload(String category, int dropsPerMillion) {
            this.category = category;
            this.dropsPerMillion = dropsPerMillion;
        }

        static DropOverload fromEnvoyProtoDropOverload(ClusterLoadAssignment.Policy.DropOverload proto) {
            FractionalPercent percent = proto.getDropPercentage();
            int numerator = percent.getNumerator();
            FractionalPercent.DenominatorType type = percent.getDenominator();
            switch (type) {
                case TEN_THOUSAND: {
                    numerator *= 100;
                    break;
                }
                case HUNDRED: {
                    numerator *= 10000;
                    break;
                }
                case MILLION: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown denominator type of " + percent);
                }
            }
            if (numerator > 1000000) {
                numerator = 1000000;
            }
            return new DropOverload(proto.getCategory(), numerator);
        }

        String getCategory() {
            return this.category;
        }

        int getDropsPerMillion() {
            return this.dropsPerMillion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DropOverload that = (DropOverload)o;
            return this.dropsPerMillion == that.dropsPerMillion && Objects.equals(this.category, that.category);
        }

        public int hashCode() {
            return Objects.hash(this.category, this.dropsPerMillion);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("category", (Object)this.category).add("dropsPerMillion", this.dropsPerMillion).toString();
        }
    }

    static final class LbEndpoint {
        private final EquivalentAddressGroup eag;
        private final int loadBalancingWeight;
        private final boolean isHealthy;

        @VisibleForTesting
        LbEndpoint(String address, int port, int loadBalancingWeight, boolean isHealthy) {
            this(new EquivalentAddressGroup((java.net.SocketAddress)new InetSocketAddress(address, port)), loadBalancingWeight, isHealthy);
        }

        @VisibleForTesting
        LbEndpoint(EquivalentAddressGroup eag, int loadBalancingWeight, boolean isHealthy) {
            this.eag = eag;
            this.loadBalancingWeight = loadBalancingWeight;
            this.isHealthy = isHealthy;
        }

        static LbEndpoint fromEnvoyProtoLbEndpoint(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LbEndpoint proto) {
            SocketAddress socketAddress = proto.getEndpoint().getAddress().getSocketAddress();
            InetSocketAddress addr = new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
            return new LbEndpoint(new EquivalentAddressGroup((List)ImmutableList.of((Object)addr)), proto.getLoadBalancingWeight().getValue(), proto.getHealthStatus() == HealthStatus.HEALTHY || proto.getHealthStatus() == HealthStatus.UNKNOWN);
        }

        EquivalentAddressGroup getAddress() {
            return this.eag;
        }

        int getLoadBalancingWeight() {
            return this.loadBalancingWeight;
        }

        boolean isHealthy() {
            return this.isHealthy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LbEndpoint that = (LbEndpoint)o;
            return this.loadBalancingWeight == that.loadBalancingWeight && Objects.equals(this.eag, that.eag) && this.isHealthy == that.isHealthy;
        }

        public int hashCode() {
            return Objects.hash(this.eag, this.loadBalancingWeight, this.isHealthy);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("eag", (Object)this.eag).add("loadBalancingWeight", this.loadBalancingWeight).add("isHealthy", this.isHealthy).toString();
        }
    }

    static final class LocalityLbEndpoints {
        private final List<LbEndpoint> endpoints;
        private final int localityWeight;
        private final int priority;

        @VisibleForTesting
        LocalityLbEndpoints(List<LbEndpoint> endpoints, int localityWeight, int priority) {
            this.endpoints = endpoints;
            this.localityWeight = localityWeight;
            this.priority = priority;
        }

        static LocalityLbEndpoints fromEnvoyProtoLocalityLbEndpoints(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LocalityLbEndpoints proto) {
            ArrayList<LbEndpoint> endpoints = new ArrayList<LbEndpoint>(proto.getLbEndpointsCount());
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LbEndpoint endpoint : proto.getLbEndpointsList()) {
                endpoints.add(LbEndpoint.fromEnvoyProtoLbEndpoint(endpoint));
            }
            return new LocalityLbEndpoints(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority());
        }

        List<LbEndpoint> getEndpoints() {
            return Collections.unmodifiableList(this.endpoints);
        }

        int getLocalityWeight() {
            return this.localityWeight;
        }

        int getPriority() {
            return this.priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalityLbEndpoints that = (LocalityLbEndpoints)o;
            return this.localityWeight == that.localityWeight && this.priority == that.priority && Objects.equals(this.endpoints, that.endpoints);
        }

        public int hashCode() {
            return Objects.hash(this.endpoints, this.localityWeight, this.priority);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("endpoints", this.endpoints).add("localityWeight", this.localityWeight).add("priority", this.priority).toString();
        }
    }

    static final class Locality {
        private final String region;
        private final String zone;
        private final String subZone;

        Locality(String region, String zone, String subZone) {
            this.region = region;
            this.zone = zone;
            this.subZone = subZone;
        }

        static Locality fromEnvoyProtoLocality(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality locality) {
            return new Locality(locality.getRegion(), locality.getZone(), locality.getSubZone());
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality toEnvoyProtoLocality() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality.newBuilder().setRegion(this.region).setZone(this.zone).setSubZone(this.subZone).build();
        }

        String getRegion() {
            return this.region;
        }

        String getZone() {
            return this.zone;
        }

        String getSubZone() {
            return this.subZone;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Locality locality = (Locality)o;
            return Objects.equals(this.region, locality.region) && Objects.equals(this.zone, locality.zone) && Objects.equals(this.subZone, locality.subZone);
        }

        public int hashCode() {
            return Objects.hash(this.region, this.zone, this.subZone);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("region", (Object)this.region).add("zone", (Object)this.zone).add("subZone", (Object)this.subZone).toString();
        }
    }
}

