/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import io.grpc.ConnectivityState;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancer;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.XdsLoadBalancerProvider;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.List;

final class FallbackLb
extends ForwardingLoadBalancer {
    private final LoadBalancer.Helper fallbackLbHelper;
    private final GracefulSwitchLoadBalancer fallbackPolicyLb;

    FallbackLb(LoadBalancer.Helper fallbackLbHelper) {
        this.fallbackLbHelper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)fallbackLbHelper, (Object)"fallbackLbHelper");
        this.fallbackPolicyLb = new GracefulSwitchLoadBalancer(fallbackLbHelper);
    }

    protected LoadBalancer delegate() {
        return this.fallbackPolicyLb;
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        XdsLoadBalancerProvider.XdsConfig xdsConfig = (XdsLoadBalancerProvider.XdsConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        ServiceConfigUtil.PolicySelection fallbackPolicy = xdsConfig.fallbackPolicy;
        if (fallbackPolicy == null) {
            this.fallbackLbHelper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE.withDescription("Fallback is not supported")));
            return;
        }
        this.fallbackPolicyLb.switchTo((LoadBalancer.Factory)fallbackPolicy.getProvider());
        List servers = resolvedAddresses.getAddresses();
        if (servers.isEmpty() && !this.fallbackPolicyLb.canHandleEmptyAddressListFromNameResolution()) {
            this.fallbackPolicyLb.handleNameResolutionError(Status.UNAVAILABLE.withDescription("NameResolver returned no usable address. addrs=" + resolvedAddresses));
        } else {
            LoadBalancer.ResolvedAddresses fallbackResolvedAddresses = resolvedAddresses.toBuilder().setAddresses(servers).setLoadBalancingPolicyConfig(fallbackPolicy.getConfig()).build();
            this.fallbackPolicyLb.handleResolvedAddresses(fallbackResolvedAddresses);
        }
    }
}

