/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsRoutingLoadBalancerProvider;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class XdsRoutingLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final LoadBalancer.Helper helper;
    private final Map<String, GracefulSwitchLoadBalancer> routeBalancers = new HashMap<String, GracefulSwitchLoadBalancer>();
    private final Map<String, RouteHelper> routeHelpers = new HashMap<String, RouteHelper>();
    private Map<String, ServiceConfigUtil.PolicySelection> actions = ImmutableMap.of();
    private List<XdsRoutingLoadBalancerProvider.Route> routes = ImmutableList.of();

    XdsRoutingLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = (LoadBalancer.Helper)Preconditions.checkNotNull((Object)helper, (Object)"helper");
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"xds-routing-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        XdsRoutingLoadBalancerProvider.XdsRoutingConfig xdsRoutingConfig = (XdsRoutingLoadBalancerProvider.XdsRoutingConfig)resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull((Object)xdsRoutingConfig, (Object)"Missing xds_routing lb config");
        Map<String, ServiceConfigUtil.PolicySelection> newActions = xdsRoutingConfig.actions;
        for (String actionName : newActions.keySet()) {
            ServiceConfigUtil.PolicySelection action = newActions.get(actionName);
            if (!this.actions.containsKey(actionName)) {
                RouteHelper routeHelper = new RouteHelper();
                GracefulSwitchLoadBalancer routeBalancer = new GracefulSwitchLoadBalancer((LoadBalancer.Helper)routeHelper);
                routeBalancer.switchTo((LoadBalancer.Factory)action.getProvider());
                this.routeHelpers.put(actionName, routeHelper);
                this.routeBalancers.put(actionName, routeBalancer);
                continue;
            }
            if (action.getProvider().equals((Object)this.actions.get(actionName).getProvider())) continue;
            this.routeBalancers.get(actionName).switchTo((LoadBalancer.Factory)action.getProvider());
        }
        this.routes = xdsRoutingConfig.routes;
        this.actions = newActions;
        for (String actionName : this.actions.keySet()) {
            this.routeBalancers.get(actionName).handleResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(this.actions.get(actionName).getConfig()).build());
        }
        for (String actionName : this.routeBalancers.keySet()) {
            if (this.actions.containsKey(actionName)) continue;
            this.routeBalancers.get(actionName).shutdown();
        }
        this.routeBalancers.keySet().retainAll(this.actions.keySet());
        this.routeHelpers.keySet().retainAll(this.actions.keySet());
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.routeBalancers.isEmpty()) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
        }
        for (LoadBalancer loadBalancer : this.routeBalancers.values()) {
            loadBalancer.handleNameResolutionError(error);
        }
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        for (LoadBalancer loadBalancer : this.routeBalancers.values()) {
            loadBalancer.shutdown();
        }
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    private void updateOverallBalancingState() {
        ConnectivityState overallState = null;
        LinkedHashMap<XdsRoutingLoadBalancerProvider.MethodName, LoadBalancer.SubchannelPicker> routePickers = new LinkedHashMap<XdsRoutingLoadBalancerProvider.MethodName, LoadBalancer.SubchannelPicker>();
        for (XdsRoutingLoadBalancerProvider.Route route : this.routes) {
            RouteHelper routeHelper = this.routeHelpers.get(route.actionName);
            routePickers.put(route.methodName, routeHelper.currentPicker);
            ConnectivityState routeState = routeHelper.currentState;
            overallState = XdsRoutingLoadBalancer.aggregateState(overallState, routeState);
        }
        if (overallState != null) {
            PathMatchingSubchannelPicker picker = new PathMatchingSubchannelPicker(routePickers);
            this.helper.updateBalancingState(overallState, (LoadBalancer.SubchannelPicker)picker);
        }
    }

    @Nullable
    private static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    private static final class PathMatchingSubchannelPicker
    extends LoadBalancer.SubchannelPicker {
        final Map<XdsRoutingLoadBalancerProvider.MethodName, LoadBalancer.SubchannelPicker> routePickers;

        PathMatchingSubchannelPicker(Map<XdsRoutingLoadBalancerProvider.MethodName, LoadBalancer.SubchannelPicker> routePickers) {
            this.routePickers = routePickers;
        }

        public LoadBalancer.PickResult pickSubchannel(LoadBalancer.PickSubchannelArgs args) {
            for (XdsRoutingLoadBalancerProvider.MethodName methodName : this.routePickers.keySet()) {
                if (!this.match(args.getMethodDescriptor(), methodName)) continue;
                return this.routePickers.get(methodName).pickSubchannel(args);
            }
            throw new IllegalStateException("PathMatchingSubchannelPicker: error in matching path");
        }

        boolean match(MethodDescriptor<?, ?> methodDescriptor, XdsRoutingLoadBalancerProvider.MethodName methodName) {
            if (methodName.service.isEmpty() && methodName.method.isEmpty()) {
                return true;
            }
            if (methodName.method.isEmpty()) {
                return methodName.service.equals(methodDescriptor.getServiceName());
            }
            return (methodName.service + '/' + methodName.method).equals(methodDescriptor.getFullMethodName());
        }
    }

    private final class RouteHelper
    extends ForwardingLoadBalancerHelper {
        ConnectivityState currentState = ConnectivityState.CONNECTING;
        LoadBalancer.SubchannelPicker currentPicker = XdsSubchannelPickers.BUFFER_PICKER;

        private RouteHelper() {
        }

        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.currentState = newState;
            this.currentPicker = newPicker;
            XdsRoutingLoadBalancer.this.updateOverallBalancingState();
        }

        protected LoadBalancer.Helper delegate() {
            return XdsRoutingLoadBalancer.this.helper;
        }
    }
}

