/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.ReferenceCountingSslContextProviderMap;
import io.grpc.xds.internal.sds.SdsSslContextProvider;
import io.grpc.xds.internal.sds.SecretVolumeSslContextProvider;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.DownstreamTlsContext;
import java.io.IOException;
import java.util.concurrent.Executors;

final class ServerSslContextProviderFactory
implements ReferenceCountingSslContextProviderMap.SslContextProviderFactory<DownstreamTlsContext> {
    ServerSslContextProviderFactory() {
    }

    @Override
    public SslContextProvider<DownstreamTlsContext> createSslContextProvider(DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        Preconditions.checkArgument((boolean)downstreamTlsContext.hasCommonTlsContext(), (Object)"downstreamTlsContext should have CommonTlsContext");
        if (CommonTlsContextUtil.hasAllSecretsUsingFilename(downstreamTlsContext.getCommonTlsContext())) {
            return SecretVolumeSslContextProvider.getProviderForServer(downstreamTlsContext);
        }
        if (CommonTlsContextUtil.hasAllSecretsUsingSds(downstreamTlsContext.getCommonTlsContext())) {
            try {
                return SdsSslContextProvider.getProviderForServer(downstreamTlsContext, Bootstrapper.getInstance().readBootstrap().getNode(), Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("server-sds-sslcontext-provider-%d").setDaemon(true).build()), null);
            }
            catch (IOException ioe) {
                throw new RuntimeException(ioe);
            }
        }
        throw new UnsupportedOperationException("DownstreamTlsContext to have all filenames or all SdsConfig");
    }
}

