/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.EdsLoadBalancer;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

@Internal
public class EdsLoadBalancerProvider
extends LoadBalancerProvider {
    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "eds_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new EdsLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawLoadBalancingPolicyConfig) {
        LoadBalancerRegistry registry = LoadBalancerRegistry.getDefaultRegistry();
        try {
            NameResolver.ConfigOrError endpointPickingConfigOrError;
            String cluster = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"cluster");
            if (cluster == null) {
                return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("Cluster name required"));
            }
            String edsServiceName = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"edsServiceName");
            String lrsServerName = JsonUtil.getString(rawLoadBalancingPolicyConfig, (String)"lrsLoadReportingServerName");
            ServiceConfigUtil.LbConfig roundRobinConfig = new ServiceConfigUtil.LbConfig("round_robin", (Map)ImmutableMap.of());
            List<ServiceConfigUtil.LbConfig> endpointPickingPolicy = ServiceConfigUtil.unwrapLoadBalancingConfigList((List)JsonUtil.getListOfObjects(rawLoadBalancingPolicyConfig, (String)"endpointPickingPolicy"));
            if (endpointPickingPolicy == null || endpointPickingPolicy.isEmpty()) {
                endpointPickingPolicy = Collections.singletonList(roundRobinConfig);
            }
            if ((endpointPickingConfigOrError = ServiceConfigUtil.selectLbPolicyFromList(endpointPickingPolicy, (LoadBalancerRegistry)registry)).getError() != null) {
                return endpointPickingConfigOrError;
            }
            ServiceConfigUtil.PolicySelection endpointPickingSelection = (ServiceConfigUtil.PolicySelection)endpointPickingConfigOrError.getConfig();
            return NameResolver.ConfigOrError.fromConfig((Object)new EdsConfig(cluster, edsServiceName, lrsServerName, endpointPickingSelection));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.fromThrowable((Throwable)e).withDescription("Failed to parse EDS LB config: " + rawLoadBalancingPolicyConfig));
        }
    }

    static final class EdsConfig {
        final String clusterName;
        @Nullable
        final String edsServiceName;
        @Nullable
        final String lrsServerName;
        final ServiceConfigUtil.PolicySelection endpointPickingPolicy;

        EdsConfig(String clusterName, @Nullable String edsServiceName, @Nullable String lrsServerName, ServiceConfigUtil.PolicySelection endpointPickingPolicy) {
            this.clusterName = (String)Preconditions.checkNotNull((Object)clusterName, (Object)"clusterName");
            this.edsServiceName = edsServiceName;
            this.lrsServerName = lrsServerName;
            this.endpointPickingPolicy = (ServiceConfigUtil.PolicySelection)Preconditions.checkNotNull((Object)endpointPickingPolicy, (Object)"endpointPickingPolicy");
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("edsServiceName", (Object)this.edsServiceName).add("lrsServerName", (Object)this.lrsServerName).add("endpointPickingPolicy", (Object)this.endpointPickingPolicy).toString();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof EdsConfig)) {
                return false;
            }
            EdsConfig that = (EdsConfig)obj;
            return Objects.equal((Object)this.clusterName, (Object)that.clusterName) && Objects.equal((Object)this.edsServiceName, (Object)that.edsServiceName) && Objects.equal((Object)this.lrsServerName, (Object)that.lrsServerName) && Objects.equal((Object)this.endpointPickingPolicy, (Object)that.endpointPickingPolicy);
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.clusterName, this.edsServiceName, this.lrsServerName, this.endpointPickingPolicy});
        }
    }
}

