/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.Status;
import io.grpc.alts.GoogleDefaultChannelBuilder;
import io.grpc.internal.ObjectPool;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyProtoData;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.LoadStatsStore;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.UpstreamTlsContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

abstract class XdsClient {
    XdsClient() {
    }

    abstract void shutdown();

    void watchConfigData(String targetAuthority, ConfigWatcher watcher) {
    }

    void watchClusterData(String clusterName, ClusterWatcher watcher) {
    }

    void cancelClusterDataWatch(String clusterName, ClusterWatcher watcher) {
    }

    void watchEndpointData(String clusterName, EndpointWatcher watcher) {
    }

    void cancelEndpointDataWatch(String clusterName, EndpointWatcher watcher) {
    }

    void watchListenerData(int port, ListenerWatcher watcher) {
    }

    void reportClientStats(String clusterName, @Nullable String clusterServiceName, LoadStatsStore loadStatsStore) {
        throw new UnsupportedOperationException();
    }

    void cancelClientStatsReport(String clusterName, @Nullable String clusterServiceName) {
    }

    static abstract class XdsChannelFactory {
        private static final XdsChannelFactory DEFAULT_INSTANCE = new XdsChannelFactory(){

            @Override
            ManagedChannel createChannel(List<Bootstrapper.ServerInfo> servers) {
                Preconditions.checkArgument((!servers.isEmpty() ? 1 : 0) != 0, (Object)"No management server provided.");
                XdsLogger logger = XdsLogger.withPrefix("xds-client-channel-factory");
                Bootstrapper.ServerInfo serverInfo = servers.get(0);
                String serverUri = serverInfo.getServerUri();
                logger.log(XdsLogger.XdsLogLevel.INFO, "Creating channel to {0}", serverUri);
                List<Bootstrapper.ChannelCreds> channelCredsList = serverInfo.getChannelCredentials();
                ManagedChannelBuilder channelBuilder = null;
                for (Bootstrapper.ChannelCreds creds : channelCredsList) {
                    if (!creds.getType().equals("google_default")) continue;
                    logger.log(XdsLogger.XdsLogLevel.INFO, "Using channel credentials: google_default");
                    channelBuilder = GoogleDefaultChannelBuilder.forTarget((String)serverUri);
                    break;
                }
                if (channelBuilder == null) {
                    logger.log(XdsLogger.XdsLogLevel.INFO, "Using default channel credentials");
                    channelBuilder = ManagedChannelBuilder.forTarget((String)serverUri);
                }
                return channelBuilder.keepAliveTime(5L, TimeUnit.MINUTES).build();
            }
        };

        XdsChannelFactory() {
        }

        static XdsChannelFactory getInstance() {
            return DEFAULT_INSTANCE;
        }

        abstract ManagedChannel createChannel(List<Bootstrapper.ServerInfo> var1);
    }

    static final class RefCountedXdsClientObjectPool
    implements ObjectPool<XdsClient> {
        private final XdsClientFactory xdsClientFactory;
        @Nullable
        @VisibleForTesting
        XdsClient xdsClient;
        private int refCount;

        RefCountedXdsClientObjectPool(XdsClientFactory xdsClientFactory) {
            this.xdsClientFactory = (XdsClientFactory)Preconditions.checkNotNull((Object)xdsClientFactory, (Object)"xdsClientFactory");
        }

        public synchronized XdsClient getObject() {
            if (this.xdsClient == null) {
                Preconditions.checkState((this.refCount == 0 ? 1 : 0) != 0, (Object)"Bug: refCount should be zero while xdsClient is null");
                this.xdsClient = this.xdsClientFactory.createXdsClient();
            }
            ++this.refCount;
            return this.xdsClient;
        }

        public synchronized XdsClient returnObject(Object object) {
            Preconditions.checkState((object == this.xdsClient ? 1 : 0) != 0, (String)"Bug: the returned object '%s' does not match current XdsClient '%s'", (Object)object, (Object)this.xdsClient);
            --this.refCount;
            Preconditions.checkState((this.refCount >= 0 ? 1 : 0) != 0, (Object)"Bug: refCount of XdsClient less than 0");
            if (this.refCount == 0) {
                this.xdsClient.shutdown();
                this.xdsClient = null;
            }
            return null;
        }
    }

    static abstract class XdsClientFactory {
        XdsClientFactory() {
        }

        abstract XdsClient createXdsClient();
    }

    static interface ListenerWatcher
    extends ResourceWatcher {
        public void onListenerChanged(ListenerUpdate var1);
    }

    static interface EndpointWatcher
    extends ResourceWatcher {
        public void onEndpointChanged(EndpointUpdate var1);
    }

    static interface ClusterWatcher
    extends ResourceWatcher {
        public void onClusterChanged(ClusterUpdate var1);
    }

    static interface ConfigWatcher
    extends ResourceWatcher {
        public void onConfigChanged(ConfigUpdate var1);
    }

    private static interface ResourceWatcher {
        public void onError(Status var1);

        public void onResourceDoesNotExist(String var1);
    }

    static final class ListenerUpdate {
        private final EnvoyServerProtoData.Listener listener;

        private ListenerUpdate(EnvoyServerProtoData.Listener listener) {
            this.listener = listener;
        }

        public EnvoyServerProtoData.Listener getListener() {
            return this.listener;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("listener", (Object)this.listener).toString();
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static final class Builder {
            private EnvoyServerProtoData.Listener listener;

            private Builder() {
            }

            Builder setListener(EnvoyServerProtoData.Listener listener) {
                this.listener = listener;
                return this;
            }

            ListenerUpdate build() {
                Preconditions.checkState((this.listener != null ? 1 : 0) != 0, (Object)"listener is not set");
                return new ListenerUpdate(this.listener);
            }
        }
    }

    static final class EndpointUpdate {
        private final String clusterName;
        private final Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityLbEndpointsMap;
        private final List<EnvoyProtoData.DropOverload> dropPolicies;

        private EndpointUpdate(String clusterName, Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityLbEndpoints, List<EnvoyProtoData.DropOverload> dropPolicies) {
            this.clusterName = clusterName;
            this.localityLbEndpointsMap = localityLbEndpoints;
            this.dropPolicies = dropPolicies;
        }

        static Builder newBuilder() {
            return new Builder();
        }

        String getClusterName() {
            return this.clusterName;
        }

        Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> getLocalityLbEndpointsMap() {
            return Collections.unmodifiableMap(this.localityLbEndpointsMap);
        }

        List<EnvoyProtoData.DropOverload> getDropPolicies() {
            return Collections.unmodifiableList(this.dropPolicies);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointUpdate that = (EndpointUpdate)o;
            return this.clusterName.equals(that.clusterName) && this.localityLbEndpointsMap.equals(that.localityLbEndpointsMap) && this.dropPolicies.equals(that.dropPolicies);
        }

        public int hashCode() {
            return Objects.hash(this.clusterName, this.localityLbEndpointsMap, this.dropPolicies);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("localityLbEndpointsMap", this.localityLbEndpointsMap).add("dropPolicies", this.dropPolicies).toString();
        }

        static final class Builder {
            private String clusterName;
            private Map<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints> localityLbEndpointsMap = new LinkedHashMap<EnvoyProtoData.Locality, EnvoyProtoData.LocalityLbEndpoints>();
            private List<EnvoyProtoData.DropOverload> dropPolicies = new ArrayList<EnvoyProtoData.DropOverload>();

            private Builder() {
            }

            Builder setClusterName(String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            Builder addLocalityLbEndpoints(EnvoyProtoData.Locality locality, EnvoyProtoData.LocalityLbEndpoints info) {
                this.localityLbEndpointsMap.put(locality, info);
                return this;
            }

            Builder addDropPolicy(EnvoyProtoData.DropOverload policy) {
                this.dropPolicies.add(policy);
                return this;
            }

            EndpointUpdate build() {
                Preconditions.checkState((this.clusterName != null ? 1 : 0) != 0, (Object)"clusterName is not set");
                return new EndpointUpdate(this.clusterName, (Map)ImmutableMap.copyOf(this.localityLbEndpointsMap), (List)ImmutableList.copyOf(this.dropPolicies));
            }
        }
    }

    static final class ClusterUpdate {
        private final String clusterName;
        @Nullable
        private final String edsServiceName;
        private final String lbPolicy;
        @Nullable
        private final String lrsServerName;
        private final UpstreamTlsContext upstreamTlsContext;

        private ClusterUpdate(String clusterName, @Nullable String edsServiceName, String lbPolicy, @Nullable String lrsServerName, @Nullable UpstreamTlsContext upstreamTlsContext) {
            this.clusterName = clusterName;
            this.edsServiceName = edsServiceName;
            this.lbPolicy = lbPolicy;
            this.lrsServerName = lrsServerName;
            this.upstreamTlsContext = upstreamTlsContext;
        }

        String getClusterName() {
            return this.clusterName;
        }

        @Nullable
        String getEdsServiceName() {
            return this.edsServiceName;
        }

        String getLbPolicy() {
            return this.lbPolicy;
        }

        @Nullable
        String getLrsServerName() {
            return this.lrsServerName;
        }

        @Nullable
        UpstreamTlsContext getUpstreamTlsContext() {
            return this.upstreamTlsContext;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("clusterName", (Object)this.clusterName).add("edsServiceName", (Object)this.edsServiceName).add("lbPolicy", (Object)this.lbPolicy).add("lrsServerName", (Object)this.lrsServerName).add("upstreamTlsContext", (Object)this.upstreamTlsContext).toString();
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static final class Builder {
            private String clusterName;
            @Nullable
            private String edsServiceName;
            private String lbPolicy;
            @Nullable
            private String lrsServerName;
            @Nullable
            private UpstreamTlsContext upstreamTlsContext;

            private Builder() {
            }

            Builder setClusterName(String clusterName) {
                this.clusterName = clusterName;
                return this;
            }

            Builder setEdsServiceName(String edsServiceName) {
                this.edsServiceName = edsServiceName;
                return this;
            }

            Builder setLbPolicy(String lbPolicy) {
                this.lbPolicy = lbPolicy;
                return this;
            }

            Builder setLrsServerName(String lrsServerName) {
                this.lrsServerName = lrsServerName;
                return this;
            }

            Builder setUpstreamTlsContext(UpstreamTlsContext upstreamTlsContext) {
                this.upstreamTlsContext = upstreamTlsContext;
                return this;
            }

            ClusterUpdate build() {
                Preconditions.checkState((this.clusterName != null ? 1 : 0) != 0, (Object)"clusterName is not set");
                Preconditions.checkState((this.lbPolicy != null ? 1 : 0) != 0, (Object)"lbPolicy is not set");
                return new ClusterUpdate(this.clusterName, this.edsServiceName, this.lbPolicy, this.lrsServerName, this.upstreamTlsContext);
            }
        }
    }

    static final class ConfigUpdate {
        private final List<EnvoyProtoData.Route> routes;

        private ConfigUpdate(List<EnvoyProtoData.Route> routes) {
            this.routes = routes;
        }

        List<EnvoyProtoData.Route> getRoutes() {
            return this.routes;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("routes", this.routes).toString();
        }

        static Builder newBuilder() {
            return new Builder();
        }

        static final class Builder {
            private final List<EnvoyProtoData.Route> routes = new ArrayList<EnvoyProtoData.Route>();

            private Builder() {
            }

            Builder addRoutes(Collection<EnvoyProtoData.Route> route) {
                this.routes.addAll(route);
                return this;
            }

            ConfigUpdate build() {
                Preconditions.checkState((!this.routes.isEmpty() ? 1 : 0) != 0, (Object)"routes is empty");
                return new ConfigUpdate(Collections.unmodifiableList(this.routes));
            }
        }
    }
}

