/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import io.grpc.Internal;
import io.grpc.InternalLogId;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.internal.ExponentialBackoffPolicy;
import io.grpc.internal.GrpcUtil;
import io.grpc.internal.SharedResourceHolder;
import io.grpc.netty.shaded.io.netty.channel.Channel;
import io.grpc.netty.shaded.io.netty.channel.epoll.Epoll;
import io.grpc.netty.shaded.io.netty.channel.epoll.EpollEventLoopGroup;
import io.grpc.netty.shaded.io.netty.util.concurrent.DefaultThreadFactory;
import io.grpc.xds.Bootstrapper;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.XdsClient;
import io.grpc.xds.XdsClientImpl;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.DownstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

@Internal
public final class XdsClientWrapperForServerSds {
    private static final Logger logger = Logger.getLogger(XdsClientWrapperForServerSds.class.getName());
    private static final TimeServiceResource timeServiceResource = new TimeServiceResource("GrpcServerXdsClient");
    private EnvoyServerProtoData.Listener curListener;
    @Nullable
    private XdsClient xdsClient;
    private final int port;
    private ScheduledExecutorService timeService;
    private XdsClient.ListenerWatcher listenerWatcher;

    public XdsClientWrapperForServerSds(int port) {
        this.port = port;
    }

    private SynchronizationContext createSynchronizationContext() {
        final InternalLogId logId = InternalLogId.allocate((String)"XdsClientWrapperForServerSds", (String)Integer.toString(this.port));
        return new SynchronizationContext(new Thread.UncaughtExceptionHandler(){
            private boolean panicMode;

            @Override
            public void uncaughtException(Thread t, Throwable e) {
                logger.log(Level.SEVERE, "[" + logId + "] Uncaught exception in the SynchronizationContext. Panic!", e);
                this.panic(e);
            }

            void panic(Throwable t) {
                if (this.panicMode) {
                    return;
                }
                this.panicMode = true;
                XdsClientWrapperForServerSds.this.shutdown();
            }
        });
    }

    public boolean hasXdsClient() {
        return this.xdsClient != null;
    }

    public void createXdsClientAndStart() {
        List<Bootstrapper.ServerInfo> serverList;
        Bootstrapper.BootstrapInfo bootstrapInfo;
        Preconditions.checkState((this.xdsClient == null ? 1 : 0) != 0, (Object)"start() called more than once");
        try {
            bootstrapInfo = Bootstrapper.getInstance().readBootstrap();
            serverList = bootstrapInfo.getServers();
            if (serverList.isEmpty()) {
                throw new ManagementServerNotFoundException("No management server provided by bootstrap");
            }
        }
        catch (ManagementServerNotFoundException | IOException e) {
            logger.log(Level.FINE, "Exception reading bootstrap", e);
            logger.log(Level.INFO, "Fallback to plaintext for server at port {0}", this.port);
            return;
        }
        Node node = bootstrapInfo.getNode();
        this.timeService = (ScheduledExecutorService)SharedResourceHolder.get((SharedResourceHolder.Resource)timeServiceResource);
        XdsClientImpl xdsClientImpl = new XdsClientImpl("", serverList, XdsClient.XdsChannelFactory.getInstance(), node, this.createSynchronizationContext(), this.timeService, (BackoffPolicy.Provider)new ExponentialBackoffPolicy.Provider(), (Supplier<Stopwatch>)GrpcUtil.STOPWATCH_SUPPLIER);
        this.start(xdsClientImpl);
    }

    @VisibleForTesting
    public void start(XdsClient xdsClient) {
        Preconditions.checkState((this.xdsClient == null ? 1 : 0) != 0, (Object)"start() called more than once");
        Preconditions.checkNotNull((Object)xdsClient, (Object)"xdsClient");
        this.xdsClient = xdsClient;
        this.listenerWatcher = new XdsClient.ListenerWatcher(){

            @Override
            public void onListenerChanged(XdsClient.ListenerUpdate update) {
                logger.log(Level.INFO, "Setting myListener from ConfigUpdate listener: {0}", update.getListener());
                XdsClientWrapperForServerSds.this.curListener = update.getListener();
            }

            @Override
            public void onResourceDoesNotExist(String resourceName) {
                logger.log(Level.INFO, "Resource {0} is unavailable", resourceName);
                XdsClientWrapperForServerSds.this.curListener = null;
            }

            @Override
            public void onError(Status error) {
                logger.log(Level.SEVERE, "ListenerWatcher in XdsClientWrapperForServerSds: {0}", error);
            }
        };
        xdsClient.watchListenerData(this.port, this.listenerWatcher);
    }

    @Nullable
    public DownstreamTlsContext getDownstreamTlsContext(Channel channel) {
        if (this.curListener != null && channel != null) {
            EnvoyServerProtoData.FilterChain bestMatch;
            SocketAddress localAddress = channel.localAddress();
            Preconditions.checkState((boolean)(localAddress instanceof InetSocketAddress), (Object)"Channel localAddress is expected to be InetSocketAddress");
            InetSocketAddress localInetAddr = (InetSocketAddress)localAddress;
            Preconditions.checkState((this.port == localInetAddr.getPort() ? 1 : 0) != 0, (Object)"Channel localAddress port does not match requested listener port");
            List<EnvoyServerProtoData.FilterChain> filterChains = this.curListener.getFilterChains();
            FilterChainComparator comparator = new FilterChainComparator(localInetAddr);
            EnvoyServerProtoData.FilterChain filterChain = bestMatch = filterChains.isEmpty() ? null : Collections.max(filterChains, comparator);
            if (bestMatch != null && comparator.isMatching(bestMatch.getFilterChainMatch())) {
                return bestMatch.getDownstreamTlsContext();
            }
        }
        return null;
    }

    @VisibleForTesting
    XdsClient.ListenerWatcher getListenerWatcher() {
        return this.listenerWatcher;
    }

    public void shutdown() {
        logger.log(Level.FINER, "Shutdown");
        if (this.xdsClient != null) {
            this.xdsClient.shutdown();
            this.xdsClient = null;
        }
        if (this.timeService != null) {
            this.timeService = (ScheduledExecutorService)SharedResourceHolder.release((SharedResourceHolder.Resource)timeServiceResource, (Object)this.timeService);
        }
    }

    private static final class TimeServiceResource
    implements SharedResourceHolder.Resource<ScheduledExecutorService> {
        private final String name;

        TimeServiceResource(String name) {
            this.name = name;
        }

        public ScheduledExecutorService create() {
            DefaultThreadFactory threadFactory = new DefaultThreadFactory(this.name, true);
            if (Epoll.isAvailable()) {
                return new EpollEventLoopGroup(1, (ThreadFactory)threadFactory);
            }
            return Executors.newSingleThreadScheduledExecutor((ThreadFactory)threadFactory);
        }

        public void close(ScheduledExecutorService instance) {
            try {
                if (instance instanceof EpollEventLoopGroup) {
                    ((EpollEventLoopGroup)instance).shutdownGracefully(0L, 0L, TimeUnit.SECONDS).sync();
                } else {
                    instance.shutdown();
                }
            }
            catch (InterruptedException e) {
                logger.log(Level.SEVERE, "Interrupted during shutdown", e);
                Thread.currentThread().interrupt();
            }
        }
    }

    private static final class FilterChainComparator
    implements Comparator<EnvoyServerProtoData.FilterChain> {
        private final InetSocketAddress localAddress;

        private FilterChainComparator(InetSocketAddress localAddress) {
            Preconditions.checkNotNull((Object)localAddress, (Object)"localAddress cannot be null");
            this.localAddress = localAddress;
        }

        @Override
        public int compare(EnvoyServerProtoData.FilterChain first, EnvoyServerProtoData.FilterChain second) {
            Preconditions.checkNotNull((Object)first, (Object)"first arg cannot be null");
            Preconditions.checkNotNull((Object)second, (Object)"second arg cannot be null");
            EnvoyServerProtoData.FilterChainMatch firstMatch = first.getFilterChainMatch();
            EnvoyServerProtoData.FilterChainMatch secondMatch = second.getFilterChainMatch();
            if (firstMatch == null) {
                return secondMatch == null ? 0 : (this.isMatching(secondMatch) ? -1 : 1);
            }
            return secondMatch == null ? (this.isMatching(firstMatch) ? 1 : -1) : this.compare(firstMatch, secondMatch);
        }

        @Override
        private int compare(EnvoyServerProtoData.FilterChainMatch first, EnvoyServerProtoData.FilterChainMatch second) {
            int channelPort = this.localAddress.getPort();
            if (first.getDestinationPort() == channelPort) {
                return second.getDestinationPort() == channelPort ? this.compare(first.getPrefixRanges(), second.getPrefixRanges()) : (this.isInetAddressMatching(first.getPrefixRanges()) ? 1 : 0);
            }
            return second.getDestinationPort() == channelPort ? (this.isInetAddressMatching(second.getPrefixRanges()) ? -1 : 0) : 0;
        }

        @Override
        private int compare(List<EnvoyServerProtoData.CidrRange> first, List<EnvoyServerProtoData.CidrRange> second) {
            return this.getInetAddressMatch(first).ordinal() - this.getInetAddressMatch(second).ordinal();
        }

        private boolean isInetAddressMatching(List<EnvoyServerProtoData.CidrRange> prefixRanges) {
            return this.getInetAddressMatch(prefixRanges).ordinal() > Match.NO_MATCH.ordinal();
        }

        private Match getInetAddressMatch(List<EnvoyServerProtoData.CidrRange> prefixRanges) {
            if (prefixRanges == null || prefixRanges.isEmpty()) {
                return Match.EMPTY_PREFIX_RANGE_MATCH;
            }
            InetAddress localInetAddress = this.localAddress.getAddress();
            for (EnvoyServerProtoData.CidrRange cidrRange : prefixRanges) {
                if (cidrRange.getPrefixLen() != 32) continue;
                try {
                    InetAddress cidrAddr = InetAddress.getByName(cidrRange.getAddressPrefix());
                    if (cidrAddr.isAnyLocalAddress()) {
                        return Match.IPANY_MATCH;
                    }
                    if (!cidrAddr.equals(localInetAddress)) continue;
                    return Match.EXACT_ADDRESS_MATCH;
                }
                catch (UnknownHostException e) {
                    logger.log(Level.WARNING, "cidrRange address parsing", e);
                }
            }
            return Match.NO_MATCH;
        }

        private boolean isMatching(EnvoyServerProtoData.FilterChainMatch filterChainMatch) {
            if (filterChainMatch == null) {
                return true;
            }
            int destPort = filterChainMatch.getDestinationPort();
            if (destPort != this.localAddress.getPort()) {
                return false;
            }
            return this.isInetAddressMatching(filterChainMatch.getPrefixRanges());
        }

        private static enum Match {
            NO_MATCH,
            EMPTY_PREFIX_RANGE_MATCH,
            IPANY_MATCH,
            EXACT_ADDRESS_MATCH;

        }
    }

    public static final class ManagementServerNotFoundException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ManagementServerNotFoundException(String msg) {
            super(msg);
        }
    }
}

