/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.grpc.Internal;
import io.grpc.LoadBalancer;
import io.grpc.LoadBalancerProvider;
import io.grpc.LoadBalancerRegistry;
import io.grpc.NameResolver;
import io.grpc.Status;
import io.grpc.internal.JsonUtil;
import io.grpc.internal.ServiceConfigUtil;
import io.grpc.xds.XdsRoutingLoadBalancer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

@Internal
public final class XdsRoutingLoadBalancerProvider
extends LoadBalancerProvider {
    @Nullable
    private final LoadBalancerRegistry lbRegistry;

    public XdsRoutingLoadBalancerProvider() {
        this(null);
    }

    @VisibleForTesting
    XdsRoutingLoadBalancerProvider(@Nullable LoadBalancerRegistry lbRegistry) {
        this.lbRegistry = lbRegistry;
    }

    public boolean isAvailable() {
        return true;
    }

    public int getPriority() {
        return 5;
    }

    public String getPolicyName() {
        return "xds_routing_experimental";
    }

    public LoadBalancer newLoadBalancer(LoadBalancer.Helper helper) {
        return new XdsRoutingLoadBalancer(helper);
    }

    public NameResolver.ConfigOrError parseLoadBalancingPolicyConfig(Map<String, ?> rawConfig) {
        try {
            Map actions = JsonUtil.getObject(rawConfig, (String)"action");
            if (actions == null || actions.isEmpty()) {
                return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No actions provided for xds_routing LB policy: " + rawConfig));
            }
            LinkedHashMap<String, ServiceConfigUtil.PolicySelection> parsedActions = new LinkedHashMap<String, ServiceConfigUtil.PolicySelection>();
            for (String name : actions.keySet()) {
                Map rawAction = JsonUtil.getObject((Map)actions, (String)name);
                if (rawAction == null) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No config for action " + name + " in xds_routing LB policy: " + rawConfig));
                }
                List childConfigCandidates = ServiceConfigUtil.unwrapLoadBalancingConfigList((List)JsonUtil.getListOfObjects((Map)rawAction, (String)"childPolicy"));
                if (childConfigCandidates == null || childConfigCandidates.isEmpty()) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No child policy for action " + name + " in xds_routing LB policy: " + rawConfig));
                }
                LoadBalancerRegistry lbRegistry = this.lbRegistry == null ? LoadBalancerRegistry.getDefaultRegistry() : this.lbRegistry;
                NameResolver.ConfigOrError selectedConfigOrError = ServiceConfigUtil.selectLbPolicyFromList((List)childConfigCandidates, (LoadBalancerRegistry)lbRegistry);
                if (selectedConfigOrError.getError() != null) {
                    return selectedConfigOrError;
                }
                parsedActions.put(name, (ServiceConfigUtil.PolicySelection)selectedConfigOrError.getConfig());
            }
            List routes = JsonUtil.getListOfObjects(rawConfig, (String)"route");
            if (routes == null || routes.isEmpty()) {
                return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No routes provided for xds_routing LB policy: " + rawConfig));
            }
            ArrayList<Route> parsedRoutes = new ArrayList<Route>();
            HashSet<MethodName> methodNames = new HashSet<MethodName>();
            for (int i = 0; i < routes.size(); ++i) {
                Map route = (Map)routes.get(i);
                String actionName = JsonUtil.getString((Map)route, (String)"action");
                if (actionName == null) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No action name provided for one of the routes in xds_routing LB policy: " + rawConfig));
                }
                if (!parsedActions.containsKey(actionName)) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No action defined for route " + route + " in xds_routing LB policy: " + rawConfig));
                }
                Map methodName = JsonUtil.getObject((Map)route, (String)"methodName");
                if (methodName == null) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No method_name provided for one of the routes in xds_routing LB policy: " + rawConfig));
                }
                String service = JsonUtil.getString((Map)methodName, (String)"service");
                String method = JsonUtil.getString((Map)methodName, (String)"method");
                if (service == null || method == null) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("No service or method provided for one of the routes in xds_routing LB policy: " + rawConfig));
                }
                MethodName parseMethodName = new MethodName(service, method);
                if (i == routes.size() - 1 && !parseMethodName.isDefault()) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("The last route in routes is not the default route in xds_routing LB policy: " + rawConfig));
                }
                if (methodNames.contains(parseMethodName)) {
                    return NameResolver.ConfigOrError.fromError((Status)Status.INTERNAL.withDescription("Duplicate methodName found in routes in xds_routing LB policy: " + rawConfig));
                }
                methodNames.add(parseMethodName);
                parsedRoutes.add(new Route(actionName, parseMethodName));
            }
            return NameResolver.ConfigOrError.fromConfig((Object)new XdsRoutingConfig(parsedRoutes, parsedActions));
        }
        catch (RuntimeException e) {
            return NameResolver.ConfigOrError.fromError((Status)Status.fromThrowable((Throwable)e).withDescription("Failed to parse xds_routing LB config: " + rawConfig));
        }
    }

    static final class MethodName {
        final String service;
        final String method;

        @VisibleForTesting
        MethodName(String service, String method) {
            this.service = service;
            this.method = method;
        }

        boolean isDefault() {
            return this.service.isEmpty() && this.method.isEmpty();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            MethodName that = (MethodName)o;
            return Objects.equals(this.service, that.service) && Objects.equals(this.method, that.method);
        }

        public int hashCode() {
            return Objects.hash(this.service, this.method);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("service", (Object)this.service).add("method", (Object)this.method).toString();
        }
    }

    static final class Route {
        final String actionName;
        final MethodName methodName;

        @VisibleForTesting
        Route(String actionName, MethodName methodName) {
            this.actionName = actionName;
            this.methodName = methodName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Route route = (Route)o;
            return Objects.equals(this.actionName, route.actionName) && Objects.equals(this.methodName, route.methodName);
        }

        public int hashCode() {
            return Objects.hash(this.actionName, this.methodName);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("actionName", (Object)this.actionName).add("methodName", (Object)this.methodName).toString();
        }
    }

    static final class XdsRoutingConfig {
        final List<Route> routes;
        final Map<String, ServiceConfigUtil.PolicySelection> actions;

        @VisibleForTesting
        XdsRoutingConfig(List<Route> routes, Map<String, ServiceConfigUtil.PolicySelection> actions) {
            this.routes = ImmutableList.copyOf(routes);
            this.actions = ImmutableMap.copyOf(actions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XdsRoutingConfig that = (XdsRoutingConfig)o;
            return Objects.equals(this.routes, that.routes) && Objects.equals(this.actions, that.actions);
        }

        public int hashCode() {
            return Objects.hash(this.routes, this.actions);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("routes", this.routes).add("actions", this.actions).toString();
        }
    }
}

