/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.trust.SdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.DownstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.TlsCertificate;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.UpstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.DataSource;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;

final class SecretVolumeSslContextProvider<K>
extends SslContextProvider<K> {
    @Nullable
    private final String privateKey;
    @Nullable
    private final String privateKeyPassword;
    @Nullable
    private final String certificateChain;
    @Nullable
    private final CertificateValidationContext certContext;

    private SecretVolumeSslContextProvider(@Nullable String privateKey, @Nullable String privateKeyPassword, @Nullable String certificateChain, @Nullable CertificateValidationContext certContext, boolean server, K source) {
        super(source, server);
        this.privateKey = privateKey;
        this.privateKeyPassword = privateKeyPassword;
        this.certificateChain = certificateChain;
        this.certContext = certContext;
    }

    @Nullable
    @VisibleForTesting
    static CertificateValidationContext validateCertificateContext(@Nullable CertificateValidationContext certContext, boolean optional) {
        if (certContext == null || !certContext.hasTrustedCa()) {
            Preconditions.checkArgument((boolean)optional, (Object)"certContext is required");
            return null;
        }
        Preconditions.checkArgument((certContext.getTrustedCa().getSpecifierCase() == DataSource.SpecifierCase.FILENAME ? 1 : 0) != 0, (Object)"filename expected");
        return certContext;
    }

    @Nullable
    @VisibleForTesting
    static TlsCertificate validateTlsCertificate(@Nullable TlsCertificate tlsCertificate, boolean optional) {
        if (tlsCertificate == null) {
            Preconditions.checkArgument((boolean)optional, (Object)"tlsCertificate is required");
            return null;
        }
        if (optional && tlsCertificate.getPrivateKey().getSpecifierCase() == DataSource.SpecifierCase.SPECIFIER_NOT_SET && tlsCertificate.getCertificateChain().getSpecifierCase() == DataSource.SpecifierCase.SPECIFIER_NOT_SET) {
            return null;
        }
        Preconditions.checkArgument((tlsCertificate.getPrivateKey().getSpecifierCase() == DataSource.SpecifierCase.FILENAME ? 1 : 0) != 0, (Object)"filename expected");
        Preconditions.checkArgument((tlsCertificate.getCertificateChain().getSpecifierCase() == DataSource.SpecifierCase.FILENAME ? 1 : 0) != 0, (Object)"filename expected");
        return tlsCertificate;
    }

    static SecretVolumeSslContextProvider<DownstreamTlsContext> getProviderForServer(DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        CommonTlsContext commonTlsContext = downstreamTlsContext.getCommonTlsContext();
        TlsCertificate tlsCertificate = null;
        if (commonTlsContext.getTlsCertificatesCount() > 0) {
            tlsCertificate = commonTlsContext.getTlsCertificates(0);
        }
        SecretVolumeSslContextProvider.validateTlsCertificate(tlsCertificate, false);
        CertificateValidationContext certificateValidationContext = SecretVolumeSslContextProvider.getCertificateValidationContext(commonTlsContext);
        if (certificateValidationContext != null) {
            certificateValidationContext = SecretVolumeSslContextProvider.validateCertificateContext(certificateValidationContext, true);
        }
        String privateKeyPassword = tlsCertificate.hasPassword() ? tlsCertificate.getPassword().getInlineString() : null;
        return new SecretVolumeSslContextProvider<DownstreamTlsContext>(tlsCertificate.getPrivateKey().getFilename(), privateKeyPassword, tlsCertificate.getCertificateChain().getFilename(), certificateValidationContext, true, downstreamTlsContext);
    }

    static SecretVolumeSslContextProvider<UpstreamTlsContext> getProviderForClient(UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        CommonTlsContext commonTlsContext = upstreamTlsContext.getCommonTlsContext();
        CertificateValidationContext certificateValidationContext = SecretVolumeSslContextProvider.getCertificateValidationContext(commonTlsContext);
        SecretVolumeSslContextProvider.validateCertificateContext(certificateValidationContext, false);
        TlsCertificate tlsCertificate = null;
        if (commonTlsContext.getTlsCertificatesCount() > 0) {
            tlsCertificate = commonTlsContext.getTlsCertificates(0);
        }
        if (tlsCertificate != null) {
            tlsCertificate = SecretVolumeSslContextProvider.validateTlsCertificate(tlsCertificate, true);
        }
        String privateKey = null;
        String privateKeyPassword = null;
        String certificateChain = null;
        if (tlsCertificate != null) {
            privateKey = tlsCertificate.getPrivateKey().getFilename();
            if (tlsCertificate.hasPassword()) {
                privateKeyPassword = tlsCertificate.getPassword().getInlineString();
            }
            certificateChain = tlsCertificate.getCertificateChain().getFilename();
        }
        return new SecretVolumeSslContextProvider<UpstreamTlsContext>(privateKey, privateKeyPassword, certificateChain, certificateValidationContext, false, upstreamTlsContext);
    }

    private static CertificateValidationContext getCertificateValidationContext(CommonTlsContext commonTlsContext) {
        Preconditions.checkNotNull((Object)commonTlsContext, (Object)"commonTlsContext");
        CommonTlsContext.ValidationContextTypeCase type = commonTlsContext.getValidationContextTypeCase();
        Preconditions.checkState((type == CommonTlsContext.ValidationContextTypeCase.VALIDATION_CONTEXT || type == CommonTlsContext.ValidationContextTypeCase.VALIDATIONCONTEXTTYPE_NOT_SET ? 1 : 0) != 0, (Object)"incorrect ValidationContextTypeCase");
        return type == CommonTlsContext.ValidationContextTypeCase.VALIDATION_CONTEXT ? commonTlsContext.getValidationContext() : null;
    }

    @Override
    public void addCallback(SslContextProvider.Callback callback, Executor executor) {
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.performCallback(new SslContextProvider.SslContextGetter(){

            @Override
            public SslContext get() throws CertificateException, IOException, CertStoreException {
                return SecretVolumeSslContextProvider.this.buildSslContextFromSecrets();
            }
        }, callback, executor);
    }

    @Override
    public void close() {
    }

    @VisibleForTesting
    SslContext buildSslContextFromSecrets() throws IOException, CertificateException, CertStoreException {
        SslContextBuilder sslContextBuilder;
        if (this.server) {
            sslContextBuilder = GrpcSslContexts.forServer((File)new File(this.certificateChain), (File)new File(this.privateKey), (String)this.privateKeyPassword);
            this.setClientAuthValues(sslContextBuilder, this.certContext);
        } else {
            sslContextBuilder = GrpcSslContexts.forClient().trustManager((TrustManagerFactory)((Object)new SdsTrustManagerFactory(this.certContext)));
            if (this.privateKey != null && this.certificateChain != null) {
                sslContextBuilder.keyManager(new File(this.certificateChain), new File(this.privateKey), this.privateKeyPassword);
            }
        }
        return sslContextBuilder.build();
    }
}

