/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.grpc.ConnectivityState;
import io.grpc.InternalLogId;
import io.grpc.LoadBalancer;
import io.grpc.Status;
import io.grpc.util.ForwardingLoadBalancerHelper;
import io.grpc.util.GracefulSwitchLoadBalancer;
import io.grpc.xds.WeightedRandomPicker;
import io.grpc.xds.WeightedTargetLoadBalancerProvider;
import io.grpc.xds.XdsLogger;
import io.grpc.xds.XdsSubchannelPickers;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class WeightedTargetLoadBalancer
extends LoadBalancer {
    private final XdsLogger logger;
    private final Map<String, GracefulSwitchLoadBalancer> childBalancers = new HashMap<String, GracefulSwitchLoadBalancer>();
    private final Map<String, ChildHelper> childHelpers = new HashMap<String, ChildHelper>();
    private final LoadBalancer.Helper helper;
    private Map<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> targets = ImmutableMap.of();

    WeightedTargetLoadBalancer(LoadBalancer.Helper helper) {
        this.helper = helper;
        this.logger = XdsLogger.withLogId(InternalLogId.allocate((String)"weighted-target-lb", (String)helper.getAuthority()));
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    public void handleResolvedAddresses(LoadBalancer.ResolvedAddresses resolvedAddresses) {
        this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received resolution result: {0}", resolvedAddresses);
        Object lbConfig = resolvedAddresses.getLoadBalancingPolicyConfig();
        Preconditions.checkNotNull((Object)lbConfig, (Object)"missing weighted_target lb config");
        WeightedTargetLoadBalancerProvider.WeightedTargetConfig weightedTargetConfig = (WeightedTargetLoadBalancerProvider.WeightedTargetConfig)lbConfig;
        Map<String, WeightedTargetLoadBalancerProvider.WeightedPolicySelection> newTargets = weightedTargetConfig.targets;
        for (String targetName : newTargets.keySet()) {
            WeightedTargetLoadBalancerProvider.WeightedPolicySelection weightedChildLbConfig = newTargets.get(targetName);
            if (!this.targets.containsKey(targetName)) {
                ChildHelper childHelper = new ChildHelper();
                GracefulSwitchLoadBalancer childBalancer = new GracefulSwitchLoadBalancer((LoadBalancer.Helper)childHelper);
                childBalancer.switchTo((LoadBalancer.Factory)weightedChildLbConfig.policySelection.getProvider());
                this.childHelpers.put(targetName, childHelper);
                this.childBalancers.put(targetName, childBalancer);
                continue;
            }
            if (weightedChildLbConfig.policySelection.getProvider().equals((Object)this.targets.get((Object)targetName).policySelection.getProvider())) continue;
            this.childBalancers.get(targetName).switchTo((LoadBalancer.Factory)weightedChildLbConfig.policySelection.getProvider());
        }
        this.targets = newTargets;
        for (String targetName : this.targets.keySet()) {
            this.childBalancers.get(targetName).handleResolvedAddresses(resolvedAddresses.toBuilder().setLoadBalancingPolicyConfig(this.targets.get((Object)targetName).policySelection.getConfig()).build());
        }
        for (String targetName : this.childBalancers.keySet()) {
            if (this.targets.containsKey(targetName)) continue;
            this.childBalancers.get(targetName).shutdown();
        }
        this.childBalancers.keySet().retainAll(this.targets.keySet());
        this.childHelpers.keySet().retainAll(this.targets.keySet());
    }

    public void handleNameResolutionError(Status error) {
        this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Received name resolution error: {0}", error);
        if (this.childBalancers.isEmpty()) {
            this.helper.updateBalancingState(ConnectivityState.TRANSIENT_FAILURE, (LoadBalancer.SubchannelPicker)new XdsSubchannelPickers.ErrorPicker(error));
        }
        for (LoadBalancer loadBalancer : this.childBalancers.values()) {
            loadBalancer.handleNameResolutionError(error);
        }
    }

    public boolean canHandleEmptyAddressListFromNameResolution() {
        return true;
    }

    public void shutdown() {
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutdown");
        for (LoadBalancer loadBalancer : this.childBalancers.values()) {
            loadBalancer.shutdown();
        }
    }

    private void updateOverallBalancingState() {
        ArrayList<WeightedRandomPicker.WeightedChildPicker> childPickers = new ArrayList<WeightedRandomPicker.WeightedChildPicker>();
        ConnectivityState overallState = null;
        for (String name : this.targets.keySet()) {
            ChildHelper childHelper = this.childHelpers.get(name);
            ConnectivityState childState = childHelper.currentState;
            overallState = WeightedTargetLoadBalancer.aggregateState(overallState, childState);
            if (ConnectivityState.READY != childState) continue;
            int weight = this.targets.get((Object)name).weight;
            childPickers.add(new WeightedRandomPicker.WeightedChildPicker(weight, childHelper.currentPicker));
        }
        LoadBalancer.SubchannelPicker picker = childPickers.isEmpty() ? (overallState == ConnectivityState.TRANSIENT_FAILURE ? new XdsSubchannelPickers.ErrorPicker(Status.UNAVAILABLE) : XdsSubchannelPickers.BUFFER_PICKER) : new WeightedRandomPicker(childPickers);
        if (overallState != null) {
            this.helper.updateBalancingState(overallState, picker);
        }
    }

    @Nullable
    private static ConnectivityState aggregateState(@Nullable ConnectivityState overallState, ConnectivityState childState) {
        if (overallState == null) {
            return childState;
        }
        if (overallState == ConnectivityState.READY || childState == ConnectivityState.READY) {
            return ConnectivityState.READY;
        }
        if (overallState == ConnectivityState.CONNECTING || childState == ConnectivityState.CONNECTING) {
            return ConnectivityState.CONNECTING;
        }
        if (overallState == ConnectivityState.IDLE || childState == ConnectivityState.IDLE) {
            return ConnectivityState.IDLE;
        }
        return overallState;
    }

    private final class ChildHelper
    extends ForwardingLoadBalancerHelper {
        ConnectivityState currentState = ConnectivityState.CONNECTING;
        LoadBalancer.SubchannelPicker currentPicker = XdsSubchannelPickers.BUFFER_PICKER;

        private ChildHelper() {
        }

        public void updateBalancingState(ConnectivityState newState, LoadBalancer.SubchannelPicker newPicker) {
            this.currentState = newState;
            this.currentPicker = newPicker;
            WeightedTargetLoadBalancer.this.updateOverallBalancingState();
        }

        protected LoadBalancer.Helper delegate() {
            return WeightedTargetLoadBalancer.this.helper;
        }
    }
}

