/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.netty.handler.ssl.ClientAuth;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.internal.sds.trust.SdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.DownstreamTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.auth.UpstreamTlsContext;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.TrustManagerFactory;

public abstract class SslContextProvider<K> {
    private static final Logger logger = Logger.getLogger(SslContextProvider.class.getName());
    protected final boolean server;
    private final K source;

    protected SslContextProvider(K source, boolean server) {
        if (server) {
            Preconditions.checkArgument((boolean)(source instanceof DownstreamTlsContext), (Object)"expecting DownstreamTlsContext");
        } else {
            Preconditions.checkArgument((boolean)(source instanceof UpstreamTlsContext), (Object)"expecting UpstreamTlsContext");
        }
        this.source = source;
        this.server = server;
    }

    public K getSource() {
        return this.source;
    }

    CommonTlsContext getCommonTlsContext() {
        if (this.source instanceof UpstreamTlsContext) {
            return ((UpstreamTlsContext)this.source).getCommonTlsContext();
        }
        if (this.source instanceof DownstreamTlsContext) {
            return ((DownstreamTlsContext)this.source).getCommonTlsContext();
        }
        return null;
    }

    protected void setClientAuthValues(SslContextBuilder sslContextBuilder, CertificateValidationContext localCertValidationContext) throws CertificateException, IOException, CertStoreException {
        Preconditions.checkState((boolean)this.server, (Object)"server side SslContextProvider expected");
        if (localCertValidationContext != null) {
            sslContextBuilder.trustManager((TrustManagerFactory)((Object)new SdsTrustManagerFactory(localCertValidationContext)));
            DownstreamTlsContext downstreamTlsContext = (DownstreamTlsContext)this.getSource();
            sslContextBuilder.clientAuth(downstreamTlsContext.hasRequireClientCertificate() ? ClientAuth.REQUIRE : ClientAuth.OPTIONAL);
        } else {
            sslContextBuilder.clientAuth(ClientAuth.NONE);
        }
    }

    void close() {
    }

    public abstract void addCallback(Callback var1, Executor var2);

    protected void performCallback(final SslContextGetter sslContextGetter, final Callback callback, Executor executor) {
        Preconditions.checkNotNull((Object)sslContextGetter, (Object)"sslContextGetter");
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    SslContext sslContext = sslContextGetter.get();
                    try {
                        callback.updateSecret(sslContext);
                    }
                    catch (Throwable t) {
                        logger.log(Level.SEVERE, "Exception from callback.updateSecret", t);
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.SEVERE, "Exception from sslContextGetter.get()", e);
                    callback.onException(e);
                }
            }
        });
    }

    protected static interface SslContextGetter {
        public SslContext get() throws Exception;
    }

    public static interface Callback {
        public void updateSecret(SslContext var1);

        public void onException(Throwable var1);
    }
}

