/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.re2j.Pattern;
import io.grpc.xds.ThreadSafeRandom;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;

final class RouteMatch {
    private final PathMatcher pathMatch;
    private final List<HeaderMatcher> headerMatchers;
    @Nullable
    private final FractionMatcher fractionMatch;

    @VisibleForTesting
    RouteMatch(PathMatcher pathMatch, List<HeaderMatcher> headerMatchers, @Nullable FractionMatcher fractionMatch) {
        this.pathMatch = pathMatch;
        this.fractionMatch = fractionMatch;
        this.headerMatchers = headerMatchers;
    }

    RouteMatch(@Nullable String pathPrefixMatch, @Nullable String pathExactMatch) {
        this(new PathMatcher(pathExactMatch, pathPrefixMatch, null), Collections.emptyList(), null);
    }

    boolean matches(String path, Map<String, Iterable<String>> headers) {
        if (!this.pathMatch.matches(path)) {
            return false;
        }
        for (HeaderMatcher headerMatcher : this.headerMatchers) {
            if (headerMatcher.matchesValue(headers.get(headerMatcher.getName()))) continue;
            return false;
        }
        return this.fractionMatch == null || this.fractionMatch.matches();
    }

    PathMatcher getPathMatch() {
        return this.pathMatch;
    }

    List<HeaderMatcher> getHeaderMatchers() {
        return Collections.unmodifiableList(this.headerMatchers);
    }

    @Nullable
    FractionMatcher getFractionMatch() {
        return this.fractionMatch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RouteMatch that = (RouteMatch)o;
        return Objects.equals(this.pathMatch, that.pathMatch) && Objects.equals(this.fractionMatch, that.fractionMatch) && Objects.equals(this.headerMatchers, that.headerMatchers);
    }

    public int hashCode() {
        return Objects.hash(this.pathMatch, this.fractionMatch, this.headerMatchers);
    }

    public String toString() {
        MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("pathMatch", (Object)this.pathMatch);
        if (this.fractionMatch != null) {
            toStringHelper.add("fractionMatch", (Object)this.fractionMatch);
        }
        return toStringHelper.add("headerMatchers", this.headerMatchers).toString();
    }

    static final class FractionMatcher {
        private final int numerator;
        private final int denominator;
        private final ThreadSafeRandom rand;

        FractionMatcher(int numerator, int denominator) {
            this(numerator, denominator, ThreadSafeRandom.ThreadSafeRandomImpl.instance);
        }

        @VisibleForTesting
        FractionMatcher(int numerator, int denominator, ThreadSafeRandom rand) {
            this.numerator = numerator;
            this.denominator = denominator;
            this.rand = rand;
        }

        private boolean matches() {
            return this.rand.nextInt(this.denominator) < this.numerator;
        }

        int getNumerator() {
            return this.numerator;
        }

        int getDenominator() {
            return this.denominator;
        }

        public int hashCode() {
            return Objects.hash(this.numerator, this.denominator);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FractionMatcher that = (FractionMatcher)o;
            return Objects.equals(this.numerator, that.numerator) && Objects.equals(this.denominator, that.denominator);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("numerator", this.numerator).add("denominator", this.denominator).toString();
        }
    }

    static final class HeaderMatcher {
        private final String name;
        @Nullable
        private final String exactMatch;
        @Nullable
        private final Pattern safeRegExMatch;
        @Nullable
        private final Range rangeMatch;
        @Nullable
        private final Boolean presentMatch;
        @Nullable
        private final String prefixMatch;
        @Nullable
        private final String suffixMatch;
        private final boolean isInvertedMatch;

        HeaderMatcher(String name, @Nullable String exactMatch, @Nullable Pattern safeRegExMatch, @Nullable Range rangeMatch, @Nullable Boolean presentMatch, @Nullable String prefixMatch, @Nullable String suffixMatch, boolean isInvertedMatch) {
            this.name = name;
            this.exactMatch = exactMatch;
            this.safeRegExMatch = safeRegExMatch;
            this.rangeMatch = rangeMatch;
            this.presentMatch = presentMatch;
            this.prefixMatch = prefixMatch;
            this.suffixMatch = suffixMatch;
            this.isInvertedMatch = isInvertedMatch;
        }

        private boolean matchesValue(@Nullable Iterable<String> values) {
            boolean baseMatch;
            if (this.presentMatch != null) {
                return values == null == this.presentMatch.equals(this.isInvertedMatch);
            }
            if (values == null) {
                return false;
            }
            String valueStr = Joiner.on((String)",").join(values);
            if (this.exactMatch != null) {
                baseMatch = this.exactMatch.equals(valueStr);
            } else if (this.safeRegExMatch != null) {
                baseMatch = this.safeRegExMatch.matches(valueStr);
            } else if (this.rangeMatch != null) {
                try {
                    long numValue = Long.parseLong(valueStr);
                    baseMatch = this.rangeMatch.contains(numValue);
                }
                catch (NumberFormatException ignored) {
                    baseMatch = false;
                }
            } else {
                baseMatch = this.prefixMatch != null ? valueStr.startsWith(this.prefixMatch) : valueStr.endsWith(this.suffixMatch);
            }
            return baseMatch != this.isInvertedMatch;
        }

        String getName() {
            return this.name;
        }

        String getExactMatch() {
            return this.exactMatch;
        }

        Pattern getRegExMatch() {
            return this.safeRegExMatch;
        }

        Range getRangeMatch() {
            return this.rangeMatch;
        }

        Boolean getPresentMatch() {
            return this.presentMatch;
        }

        String getPrefixMatch() {
            return this.prefixMatch;
        }

        String getSuffixMatch() {
            return this.suffixMatch;
        }

        boolean isInvertedMatch() {
            return this.isInvertedMatch;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            HeaderMatcher that = (HeaderMatcher)o;
            return Objects.equals(this.name, that.name) && Objects.equals(this.exactMatch, that.exactMatch) && Objects.equals(this.safeRegExMatch == null ? null : this.safeRegExMatch.pattern(), that.safeRegExMatch == null ? null : that.safeRegExMatch.pattern()) && Objects.equals(this.rangeMatch, that.rangeMatch) && Objects.equals(this.presentMatch, that.presentMatch) && Objects.equals(this.prefixMatch, that.prefixMatch) && Objects.equals(this.suffixMatch, that.suffixMatch) && Objects.equals(this.isInvertedMatch, that.isInvertedMatch);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.exactMatch, this.safeRegExMatch == null ? null : this.safeRegExMatch.pattern(), this.rangeMatch, this.presentMatch, this.prefixMatch, this.suffixMatch, this.isInvertedMatch);
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name);
            if (this.exactMatch != null) {
                toStringHelper.add("exactMatch", (Object)this.exactMatch);
            }
            if (this.safeRegExMatch != null) {
                toStringHelper.add("safeRegExMatch", (Object)this.safeRegExMatch.pattern());
            }
            if (this.rangeMatch != null) {
                toStringHelper.add("rangeMatch", (Object)this.rangeMatch);
            }
            if (this.presentMatch != null) {
                toStringHelper.add("presentMatch", (Object)this.presentMatch);
            }
            if (this.prefixMatch != null) {
                toStringHelper.add("prefixMatch", (Object)this.prefixMatch);
            }
            if (this.suffixMatch != null) {
                toStringHelper.add("suffixMatch", (Object)this.suffixMatch);
            }
            return toStringHelper.add("isInvertedMatch", this.isInvertedMatch).toString();
        }

        static final class Range {
            private final long start;
            private final long end;

            Range(long start, long end) {
                this.start = start;
                this.end = end;
            }

            boolean contains(long value) {
                return value >= this.start && value < this.end;
            }

            long getStart() {
                return this.start;
            }

            long getEnd() {
                return this.end;
            }

            public int hashCode() {
                return Objects.hash(this.start, this.end);
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                Range that = (Range)o;
                return Objects.equals(this.start, that.start) && Objects.equals(this.end, that.end);
            }

            public String toString() {
                return MoreObjects.toStringHelper((Object)this).add("start", this.start).add("end", this.end).toString();
            }
        }
    }

    static final class PathMatcher {
        @Nullable
        private final String path;
        @Nullable
        private final String prefix;
        @Nullable
        private final Pattern regEx;

        PathMatcher(@Nullable String path, @Nullable String prefix, @Nullable Pattern regEx) {
            this.path = path;
            this.prefix = prefix;
            this.regEx = regEx;
        }

        private boolean matches(String fullMethodName) {
            if (this.path != null) {
                return this.path.equals(fullMethodName);
            }
            if (this.prefix != null) {
                return fullMethodName.startsWith(this.prefix);
            }
            return this.regEx.matches(fullMethodName);
        }

        @Nullable
        String getPath() {
            return this.path;
        }

        @Nullable
        String getPrefix() {
            return this.prefix;
        }

        @Nullable
        Pattern getRegEx() {
            return this.regEx;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathMatcher that = (PathMatcher)o;
            return Objects.equals(this.path, that.path) && Objects.equals(this.prefix, that.prefix) && Objects.equals(this.regEx == null ? null : this.regEx.pattern(), that.regEx == null ? null : that.regEx.pattern());
        }

        public int hashCode() {
            return Objects.hash(this.path, this.prefix, this.regEx == null ? null : this.regEx.pattern());
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            if (this.path != null) {
                toStringHelper.add("path", (Object)this.path);
            }
            if (this.prefix != null) {
                toStringHelper.add("prefix", (Object)this.prefix);
            }
            if (this.regEx != null) {
                toStringHelper.add("regEx", (Object)this.regEx.pattern());
            }
            return toStringHelper.toString();
        }
    }
}

