/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.re2j.Pattern;
import com.google.re2j.PatternSyntaxException;
import io.grpc.EquivalentAddressGroup;
import io.grpc.xds.RouteMatch;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.HealthStatus;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.SocketAddress;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.ClusterLoadAssignment;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.HeaderMatcher;
import io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.WeightedCluster;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.FractionalPercent;
import io.grpc.xds.shaded.io.envoyproxy.envoy.type.v3.FractionalPercent;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;

final class EnvoyProtoData {
    private EnvoyProtoData() {
    }

    static final class ClusterWeight {
        private final String name;
        private final int weight;

        @VisibleForTesting
        ClusterWeight(String name, int weight) {
            this.name = name;
            this.weight = weight;
        }

        String getName() {
            return this.name;
        }

        int getWeight() {
            return this.weight;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ClusterWeight that = (ClusterWeight)o;
            return this.weight == that.weight && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.weight);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("weight", this.weight).toString();
        }

        @VisibleForTesting
        static ClusterWeight fromEnvoyProtoClusterWeight(WeightedCluster.ClusterWeight proto) {
            return new ClusterWeight(proto.getName(), proto.getWeight().getValue());
        }
    }

    static final class RouteAction {
        @Nullable
        private final String cluster;
        @Nullable
        private final List<ClusterWeight> weightedClusters;

        @VisibleForTesting
        RouteAction(@Nullable String cluster, @Nullable List<ClusterWeight> weightedClusters) {
            this.cluster = cluster;
            this.weightedClusters = weightedClusters;
        }

        @Nullable
        String getCluster() {
            return this.cluster;
        }

        @Nullable
        List<ClusterWeight> getWeightedCluster() {
            return this.weightedClusters;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RouteAction that = (RouteAction)o;
            return Objects.equals(this.cluster, that.cluster) && Objects.equals(this.weightedClusters, that.weightedClusters);
        }

        public int hashCode() {
            return Objects.hash(this.cluster, this.weightedClusters);
        }

        public String toString() {
            MoreObjects.ToStringHelper toStringHelper = MoreObjects.toStringHelper((Object)this);
            if (this.cluster != null) {
                toStringHelper.add("cluster", (Object)this.cluster);
            }
            if (this.weightedClusters != null) {
                toStringHelper.add("weightedClusters", this.weightedClusters);
            }
            return toStringHelper.toString();
        }

        @Nullable
        @VisibleForTesting
        static StructOrError<RouteAction> fromEnvoyProtoRouteAction(io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteAction proto) {
            String cluster = null;
            ArrayList<ClusterWeight> weightedClusters = null;
            switch (proto.getClusterSpecifierCase()) {
                case CLUSTER: {
                    cluster = proto.getCluster();
                    break;
                }
                case CLUSTER_HEADER: {
                    return null;
                }
                case WEIGHTED_CLUSTERS: {
                    List<WeightedCluster.ClusterWeight> clusterWeights = proto.getWeightedClusters().getClustersList();
                    weightedClusters = new ArrayList<ClusterWeight>();
                    for (WeightedCluster.ClusterWeight clusterWeight : clusterWeights) {
                        weightedClusters.add(ClusterWeight.fromEnvoyProtoClusterWeight(clusterWeight));
                    }
                    break;
                }
                default: {
                    return StructOrError.fromError("Unknown cluster specifier: " + (Object)((Object)proto.getClusterSpecifierCase()));
                }
            }
            return StructOrError.fromStruct(new RouteAction(cluster, weightedClusters));
        }
    }

    static final class Route {
        private final RouteMatch routeMatch;
        private final RouteAction routeAction;

        @VisibleForTesting
        Route(RouteMatch routeMatch, @Nullable RouteAction routeAction) {
            this.routeMatch = routeMatch;
            this.routeAction = routeAction;
        }

        RouteMatch getRouteMatch() {
            return this.routeMatch;
        }

        RouteAction getRouteAction() {
            return this.routeAction;
        }

        boolean isDefaultRoute() {
            String prefix = this.routeMatch.getPathMatch().getPrefix();
            if (prefix != null) {
                return prefix.isEmpty() || prefix.equals("/");
            }
            return false;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Route route = (Route)o;
            return Objects.equals(this.routeMatch, route.routeMatch) && Objects.equals(this.routeAction, route.routeAction);
        }

        public int hashCode() {
            return Objects.hash(this.routeMatch, this.routeAction);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("routeMatch", (Object)this.routeMatch).add("routeAction", (Object)this.routeAction).toString();
        }

        @Nullable
        static StructOrError<Route> fromEnvoyProtoRoute(io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.Route proto) {
            StructOrError<RouteAction> routeAction;
            StructOrError<RouteMatch> routeMatch = Route.convertEnvoyProtoRouteMatch(proto.getMatch());
            if (routeMatch == null) {
                return null;
            }
            if (routeMatch.getErrorDetail() != null) {
                return StructOrError.fromError("Invalid route [" + proto.getName() + "]: " + routeMatch.getErrorDetail());
            }
            switch (proto.getActionCase()) {
                case ROUTE: {
                    routeAction = RouteAction.fromEnvoyProtoRouteAction(proto.getRoute());
                    break;
                }
                case REDIRECT: {
                    return StructOrError.fromError("Unsupported action type: redirect");
                }
                case DIRECT_RESPONSE: {
                    return StructOrError.fromError("Unsupported action type: direct_response");
                }
                case FILTER_ACTION: {
                    return StructOrError.fromError("Unsupported action type: filter_action");
                }
                default: {
                    return StructOrError.fromError("Unknown action type: " + (Object)((Object)proto.getActionCase()));
                }
            }
            if (routeAction == null) {
                return null;
            }
            if (routeAction.getErrorDetail() != null) {
                return StructOrError.fromError("Invalid route [" + proto.getName() + "]: " + routeAction.getErrorDetail());
            }
            return StructOrError.fromStruct(new Route(routeMatch.getStruct(), routeAction.getStruct()));
        }

        @Nullable
        @VisibleForTesting
        static StructOrError<RouteMatch> convertEnvoyProtoRouteMatch(io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteMatch proto) {
            if (proto.getQueryParametersCount() != 0) {
                return null;
            }
            if (proto.hasCaseSensitive() && !proto.getCaseSensitive().getValue()) {
                return StructOrError.fromError("Unsupported match option: case insensitive");
            }
            StructOrError<RouteMatch.PathMatcher> pathMatch = Route.convertEnvoyProtoPathMatcher(proto);
            if (pathMatch.getErrorDetail() != null) {
                return StructOrError.fromError(pathMatch.getErrorDetail());
            }
            RouteMatch.FractionMatcher fractionMatch = null;
            if (proto.hasRuntimeFraction()) {
                StructOrError<RouteMatch.FractionMatcher> parsedFraction = Route.convertEnvoyProtoFraction(proto.getRuntimeFraction().getDefaultValue());
                if (parsedFraction.getErrorDetail() != null) {
                    return StructOrError.fromError(parsedFraction.getErrorDetail());
                }
                fractionMatch = parsedFraction.getStruct();
            }
            ArrayList<RouteMatch.HeaderMatcher> headerMatchers = new ArrayList<RouteMatch.HeaderMatcher>();
            for (HeaderMatcher hmProto : proto.getHeadersList()) {
                StructOrError<RouteMatch.HeaderMatcher> headerMatcher = Route.convertEnvoyProtoHeaderMatcher(hmProto);
                if (headerMatcher.getErrorDetail() != null) {
                    return StructOrError.fromError(headerMatcher.getErrorDetail());
                }
                headerMatchers.add(headerMatcher.getStruct());
            }
            return StructOrError.fromStruct(new RouteMatch(pathMatch.getStruct(), Collections.unmodifiableList(headerMatchers), fractionMatch));
        }

        private static StructOrError<RouteMatch.PathMatcher> convertEnvoyProtoPathMatcher(io.grpc.xds.shaded.io.envoyproxy.envoy.config.route.v3.RouteMatch proto) {
            String path = null;
            String prefix = null;
            Pattern safeRegEx = null;
            switch (proto.getPathSpecifierCase()) {
                case PREFIX: {
                    prefix = proto.getPrefix();
                    break;
                }
                case PATH: {
                    path = proto.getPath();
                    break;
                }
                case SAFE_REGEX: {
                    String rawPattern = proto.getSafeRegex().getRegex();
                    try {
                        safeRegEx = Pattern.compile((String)rawPattern);
                        break;
                    }
                    catch (PatternSyntaxException e) {
                        return StructOrError.fromError("Malformed safe regex pattern: " + e.getMessage());
                    }
                }
                default: {
                    return StructOrError.fromError("Unknown path match type");
                }
            }
            return StructOrError.fromStruct(new RouteMatch.PathMatcher(path, prefix, safeRegEx));
        }

        private static StructOrError<RouteMatch.FractionMatcher> convertEnvoyProtoFraction(FractionalPercent proto) {
            int numerator = proto.getNumerator();
            int denominator = 0;
            switch (proto.getDenominator()) {
                case HUNDRED: {
                    denominator = 100;
                    break;
                }
                case TEN_THOUSAND: {
                    denominator = 10000;
                    break;
                }
                case MILLION: {
                    denominator = 1000000;
                    break;
                }
                default: {
                    return StructOrError.fromError("Unrecognized fractional percent denominator: " + (Object)((Object)proto.getDenominator()));
                }
            }
            return StructOrError.fromStruct(new RouteMatch.FractionMatcher(numerator, denominator));
        }

        @VisibleForTesting
        static StructOrError<RouteMatch.HeaderMatcher> convertEnvoyProtoHeaderMatcher(HeaderMatcher proto) {
            String exactMatch = null;
            Pattern safeRegExMatch = null;
            RouteMatch.HeaderMatcher.Range rangeMatch = null;
            Boolean presentMatch = null;
            String prefixMatch = null;
            String suffixMatch = null;
            switch (proto.getHeaderMatchSpecifierCase()) {
                case EXACT_MATCH: {
                    exactMatch = proto.getExactMatch();
                    break;
                }
                case SAFE_REGEX_MATCH: {
                    String rawPattern = proto.getSafeRegexMatch().getRegex();
                    try {
                        safeRegExMatch = Pattern.compile((String)rawPattern);
                        break;
                    }
                    catch (PatternSyntaxException e) {
                        return StructOrError.fromError("HeaderMatcher [" + proto.getName() + "] contains malformed safe regex pattern: " + e.getMessage());
                    }
                }
                case RANGE_MATCH: {
                    rangeMatch = new RouteMatch.HeaderMatcher.Range(proto.getRangeMatch().getStart(), proto.getRangeMatch().getEnd());
                    break;
                }
                case PRESENT_MATCH: {
                    presentMatch = proto.getPresentMatch();
                    break;
                }
                case PREFIX_MATCH: {
                    prefixMatch = proto.getPrefixMatch();
                    break;
                }
                case SUFFIX_MATCH: {
                    suffixMatch = proto.getSuffixMatch();
                    break;
                }
                default: {
                    return StructOrError.fromError("Unknown header matcher type");
                }
            }
            return StructOrError.fromStruct(new RouteMatch.HeaderMatcher(proto.getName(), exactMatch, safeRegExMatch, rangeMatch, presentMatch, prefixMatch, suffixMatch, proto.getInvertMatch()));
        }
    }

    static final class DropOverload {
        private final String category;
        private final int dropsPerMillion;

        @VisibleForTesting
        DropOverload(String category, int dropsPerMillion) {
            this.category = category;
            this.dropsPerMillion = dropsPerMillion;
        }

        static DropOverload fromEnvoyProtoDropOverload(ClusterLoadAssignment.Policy.DropOverload proto) {
            FractionalPercent percent = proto.getDropPercentage();
            int numerator = percent.getNumerator();
            FractionalPercent.DenominatorType type = percent.getDenominator();
            switch (type) {
                case TEN_THOUSAND: {
                    numerator *= 100;
                    break;
                }
                case HUNDRED: {
                    numerator *= 10000;
                    break;
                }
                case MILLION: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown denominator type of " + percent);
                }
            }
            if (numerator > 1000000) {
                numerator = 1000000;
            }
            return new DropOverload(proto.getCategory(), numerator);
        }

        @VisibleForTesting
        static DropOverload fromEnvoyProtoDropOverloadV2(ClusterLoadAssignment.Policy.DropOverload proto) {
            io.grpc.xds.shaded.io.envoyproxy.envoy.type.FractionalPercent percent = proto.getDropPercentage();
            int numerator = percent.getNumerator();
            FractionalPercent.DenominatorType type = percent.getDenominator();
            switch (type) {
                case TEN_THOUSAND: {
                    numerator *= 100;
                    break;
                }
                case HUNDRED: {
                    numerator *= 10000;
                    break;
                }
                case MILLION: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown denominator type of " + percent);
                }
            }
            if (numerator > 1000000) {
                numerator = 1000000;
            }
            return new DropOverload(proto.getCategory(), numerator);
        }

        String getCategory() {
            return this.category;
        }

        int getDropsPerMillion() {
            return this.dropsPerMillion;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DropOverload that = (DropOverload)o;
            return this.dropsPerMillion == that.dropsPerMillion && Objects.equals(this.category, that.category);
        }

        public int hashCode() {
            return Objects.hash(this.category, this.dropsPerMillion);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("category", (Object)this.category).add("dropsPerMillion", this.dropsPerMillion).toString();
        }
    }

    static final class LbEndpoint {
        private final EquivalentAddressGroup eag;
        private final int loadBalancingWeight;
        private final boolean isHealthy;

        @VisibleForTesting
        LbEndpoint(String address, int port, int loadBalancingWeight, boolean isHealthy) {
            this(new EquivalentAddressGroup((java.net.SocketAddress)new InetSocketAddress(address, port)), loadBalancingWeight, isHealthy);
        }

        @VisibleForTesting
        LbEndpoint(EquivalentAddressGroup eag, int loadBalancingWeight, boolean isHealthy) {
            this.eag = eag;
            this.loadBalancingWeight = loadBalancingWeight;
            this.isHealthy = isHealthy;
        }

        static LbEndpoint fromEnvoyProtoLbEndpoint(io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint proto) {
            io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.SocketAddress socketAddress = proto.getEndpoint().getAddress().getSocketAddress();
            InetSocketAddress addr = new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
            return new LbEndpoint(new EquivalentAddressGroup((List)ImmutableList.of((Object)addr)), proto.getLoadBalancingWeight().getValue(), proto.getHealthStatus() == io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HealthStatus.HEALTHY || proto.getHealthStatus() == io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.HealthStatus.UNKNOWN);
        }

        private static LbEndpoint fromEnvoyProtoLbEndpointV2(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LbEndpoint proto) {
            SocketAddress socketAddress = proto.getEndpoint().getAddress().getSocketAddress();
            InetSocketAddress addr = new InetSocketAddress(socketAddress.getAddress(), socketAddress.getPortValue());
            return new LbEndpoint(new EquivalentAddressGroup((List)ImmutableList.of((Object)addr)), proto.getLoadBalancingWeight().getValue(), proto.getHealthStatus() == HealthStatus.HEALTHY || proto.getHealthStatus() == HealthStatus.UNKNOWN);
        }

        EquivalentAddressGroup getAddress() {
            return this.eag;
        }

        int getLoadBalancingWeight() {
            return this.loadBalancingWeight;
        }

        boolean isHealthy() {
            return this.isHealthy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LbEndpoint that = (LbEndpoint)o;
            return this.loadBalancingWeight == that.loadBalancingWeight && Objects.equals(this.eag, that.eag) && this.isHealthy == that.isHealthy;
        }

        public int hashCode() {
            return Objects.hash(this.eag, this.loadBalancingWeight, this.isHealthy);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("eag", (Object)this.eag).add("loadBalancingWeight", this.loadBalancingWeight).add("isHealthy", this.isHealthy).toString();
        }
    }

    static final class LocalityLbEndpoints {
        private final List<LbEndpoint> endpoints;
        private final int localityWeight;
        private final int priority;

        @VisibleForTesting
        LocalityLbEndpoints(List<LbEndpoint> endpoints, int localityWeight, int priority) {
            this.endpoints = endpoints;
            this.localityWeight = localityWeight;
            this.priority = priority;
        }

        static LocalityLbEndpoints fromEnvoyProtoLocalityLbEndpoints(io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LocalityLbEndpoints proto) {
            ArrayList<LbEndpoint> endpoints = new ArrayList<LbEndpoint>(proto.getLbEndpointsCount());
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.config.endpoint.v3.LbEndpoint endpoint : proto.getLbEndpointsList()) {
                endpoints.add(LbEndpoint.fromEnvoyProtoLbEndpoint(endpoint));
            }
            return new LocalityLbEndpoints(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority());
        }

        @VisibleForTesting
        static LocalityLbEndpoints fromEnvoyProtoLocalityLbEndpointsV2(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LocalityLbEndpoints proto) {
            ArrayList<LbEndpoint> endpoints = new ArrayList<LbEndpoint>(proto.getLbEndpointsCount());
            for (io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.endpoint.LbEndpoint endpoint : proto.getLbEndpointsList()) {
                endpoints.add(LbEndpoint.fromEnvoyProtoLbEndpointV2(endpoint));
            }
            return new LocalityLbEndpoints(endpoints, proto.getLoadBalancingWeight().getValue(), proto.getPriority());
        }

        List<LbEndpoint> getEndpoints() {
            return Collections.unmodifiableList(this.endpoints);
        }

        int getLocalityWeight() {
            return this.localityWeight;
        }

        int getPriority() {
            return this.priority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LocalityLbEndpoints that = (LocalityLbEndpoints)o;
            return this.localityWeight == that.localityWeight && this.priority == that.priority && Objects.equals(this.endpoints, that.endpoints);
        }

        public int hashCode() {
            return Objects.hash(this.endpoints, this.localityWeight, this.priority);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("endpoints", this.endpoints).add("localityWeight", this.localityWeight).add("priority", this.priority).toString();
        }
    }

    static final class Locality {
        private final String region;
        private final String zone;
        private final String subZone;

        Locality(String region, String zone, String subZone) {
            this.region = region;
            this.zone = zone;
            this.subZone = subZone;
        }

        static Locality fromEnvoyProtoLocality(io.grpc.xds.shaded.io.envoyproxy.envoy.config.core.v3.Locality locality) {
            return new Locality(locality.getRegion(), locality.getZone(), locality.getSubZone());
        }

        @VisibleForTesting
        static Locality fromEnvoyProtoLocalityV2(io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality locality) {
            return new Locality(locality.getRegion(), locality.getZone(), locality.getSubZone());
        }

        io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality toEnvoyProtoLocality() {
            return io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Locality.newBuilder().setRegion(this.region).setZone(this.zone).setSubZone(this.subZone).build();
        }

        String getRegion() {
            return this.region;
        }

        String getZone() {
            return this.zone;
        }

        String getSubZone() {
            return this.subZone;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Locality locality = (Locality)o;
            return Objects.equals(this.region, locality.region) && Objects.equals(this.zone, locality.zone) && Objects.equals(this.subZone, locality.subZone);
        }

        public int hashCode() {
            return Objects.hash(this.region, this.zone, this.subZone);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("region", (Object)this.region).add("zone", (Object)this.zone).add("subZone", (Object)this.subZone).toString();
        }
    }

    static final class StructOrError<T> {
        private final String errorDetail;
        private final T struct;

        static <T> StructOrError<T> fromStruct(T struct) {
            return new StructOrError<T>(struct);
        }

        static <T> StructOrError<T> fromError(String errorDetail) {
            return new StructOrError<T>(errorDetail);
        }

        private StructOrError(T struct) {
            this.struct = Preconditions.checkNotNull(struct, (Object)"struct");
            this.errorDetail = null;
        }

        private StructOrError(String errorDetail) {
            this.struct = null;
            this.errorDetail = (String)Preconditions.checkNotNull((Object)errorDetail, (Object)"errorDetail");
        }

        @Nullable
        public T getStruct() {
            return this.struct;
        }

        @Nullable
        String getErrorDetail() {
            return this.errorDetail;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StructOrError that = (StructOrError)o;
            return Objects.equals(this.errorDetail, that.errorDetail) && Objects.equals(this.struct, that.struct);
        }

        public int hashCode() {
            return Objects.hash(this.errorDetail, this.struct);
        }

        public String toString() {
            if (this.struct != null) {
                return MoreObjects.toStringHelper((Object)this).add("struct", this.struct).toString();
            }
            assert (this.errorDetail != null);
            return MoreObjects.toStringHelper((Object)this).add("error", (Object)this.errorDetail).toString();
        }
    }
}

