/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.internal.sds.trust.SdsTrustManagerFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsCertificate;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import javax.net.ssl.TrustManagerFactory;

final class SecretVolumeClientSslContextProvider
extends SslContextProvider {
    @Nullable
    private final String privateKey;
    @Nullable
    private final String privateKeyPassword;
    @Nullable
    private final String certificateChain;
    @Nullable
    private final CertificateValidationContext certContext;

    private SecretVolumeClientSslContextProvider(@Nullable String privateKey, @Nullable String privateKeyPassword, @Nullable String certificateChain, @Nullable CertificateValidationContext certContext, EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        super(upstreamTlsContext);
        this.privateKey = privateKey;
        this.privateKeyPassword = privateKeyPassword;
        this.certificateChain = certificateChain;
        this.certContext = certContext;
    }

    static SecretVolumeClientSslContextProvider getProvider(EnvoyServerProtoData.UpstreamTlsContext upstreamTlsContext) {
        Preconditions.checkNotNull((Object)upstreamTlsContext, (Object)"upstreamTlsContext");
        CommonTlsContext commonTlsContext = upstreamTlsContext.getCommonTlsContext();
        CertificateValidationContext certificateValidationContext = CommonTlsContextUtil.getCertificateValidationContext(commonTlsContext);
        CommonTlsContextUtil.validateCertificateContext(certificateValidationContext, false);
        TlsCertificate tlsCertificate = null;
        if (commonTlsContext.getTlsCertificatesCount() > 0) {
            tlsCertificate = commonTlsContext.getTlsCertificates(0);
        }
        if (tlsCertificate != null) {
            tlsCertificate = CommonTlsContextUtil.validateTlsCertificate(tlsCertificate, true);
        }
        String privateKey = null;
        String privateKeyPassword = null;
        String certificateChain = null;
        if (tlsCertificate != null) {
            privateKey = tlsCertificate.getPrivateKey().getFilename();
            if (tlsCertificate.hasPassword()) {
                privateKeyPassword = tlsCertificate.getPassword().getInlineString();
            }
            certificateChain = tlsCertificate.getCertificateChain().getFilename();
        }
        return new SecretVolumeClientSslContextProvider(privateKey, privateKeyPassword, certificateChain, certificateValidationContext, upstreamTlsContext);
    }

    @Override
    public void addCallback(SslContextProvider.Callback callback, Executor executor) {
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.performCallback(new SslContextProvider.SslContextGetter(){

            @Override
            public SslContext get() throws CertificateException, IOException, CertStoreException {
                return SecretVolumeClientSslContextProvider.this.buildSslContextFromSecrets();
            }
        }, callback, executor);
    }

    @Override
    public void close() {
    }

    @VisibleForTesting
    SslContext buildSslContextFromSecrets() throws IOException, CertificateException, CertStoreException {
        SslContextBuilder sslContextBuilder = GrpcSslContexts.forClient().trustManager((TrustManagerFactory)((Object)new SdsTrustManagerFactory(this.certContext)));
        if (this.privateKey != null && this.certificateChain != null) {
            sslContextBuilder.keyManager(new File(this.certificateChain), new File(this.privateKey), this.privateKeyPassword);
        }
        return sslContextBuilder.build();
    }
}

