/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.SdsSslContextProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.api.v2.core.Node;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.SdsSecretConfig;
import java.io.IOException;
import java.io.InputStream;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;

final class SdsServerSslContextProvider
extends SdsSslContextProvider {
    private SdsServerSslContextProvider(Node node, SdsSecretConfig certSdsConfig, SdsSecretConfig validationContextSdsConfig, Executor watcherExecutor, Executor channelExecutor, EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        super(node, certSdsConfig, validationContextSdsConfig, null, watcherExecutor, channelExecutor, downstreamTlsContext);
    }

    static SdsServerSslContextProvider getProvider(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext, Node node, Executor watcherExecutor, Executor channelExecutor) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        CommonTlsContext commonTlsContext = downstreamTlsContext.getCommonTlsContext();
        SdsSecretConfig certSdsConfig = null;
        if (commonTlsContext.getTlsCertificateSdsSecretConfigsCount() > 0) {
            certSdsConfig = commonTlsContext.getTlsCertificateSdsSecretConfigs(0);
        }
        SdsSecretConfig validationContextSdsConfig = null;
        if (commonTlsContext.hasValidationContextSdsSecretConfig()) {
            validationContextSdsConfig = commonTlsContext.getValidationContextSdsSecretConfig();
        }
        return new SdsServerSslContextProvider(node, certSdsConfig, validationContextSdsConfig, watcherExecutor, channelExecutor, downstreamTlsContext);
    }

    @Override
    SslContextBuilder getSslContextBuilder(CertificateValidationContext localCertValidationContext) throws CertificateException, IOException, CertStoreException {
        SslContextBuilder sslContextBuilder = GrpcSslContexts.forServer((InputStream)this.tlsCertificate.getCertificateChain().getInlineBytes().newInput(), (InputStream)this.tlsCertificate.getPrivateKey().getInlineBytes().newInput(), this.tlsCertificate.hasPassword() ? this.tlsCertificate.getPassword().getInlineString() : null);
        this.setClientAuthValues(sslContextBuilder, localCertValidationContext);
        return sslContextBuilder;
    }
}

