/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.internal.sds;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.xds.EnvoyServerProtoData;
import io.grpc.xds.internal.sds.CommonTlsContextUtil;
import io.grpc.xds.internal.sds.SslContextProvider;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CertificateValidationContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.CommonTlsContext;
import io.grpc.xds.shaded.io.envoyproxy.envoy.extensions.transport_sockets.tls.v3.TlsCertificate;
import java.io.File;
import java.io.IOException;
import java.security.cert.CertStoreException;
import java.security.cert.CertificateException;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;

final class SecretVolumeServerSslContextProvider
extends SslContextProvider {
    @Nullable
    private final String privateKey;
    @Nullable
    private final String privateKeyPassword;
    @Nullable
    private final String certificateChain;
    @Nullable
    private final CertificateValidationContext certContext;

    private SecretVolumeServerSslContextProvider(@Nullable String privateKey, @Nullable String privateKeyPassword, @Nullable String certificateChain, @Nullable CertificateValidationContext certContext, EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        super(downstreamTlsContext);
        this.privateKey = privateKey;
        this.privateKeyPassword = privateKeyPassword;
        this.certificateChain = certificateChain;
        this.certContext = certContext;
    }

    static SecretVolumeServerSslContextProvider getProvider(EnvoyServerProtoData.DownstreamTlsContext downstreamTlsContext) {
        Preconditions.checkNotNull((Object)downstreamTlsContext, (Object)"downstreamTlsContext");
        CommonTlsContext commonTlsContext = downstreamTlsContext.getCommonTlsContext();
        TlsCertificate tlsCertificate = null;
        if (commonTlsContext.getTlsCertificatesCount() > 0) {
            tlsCertificate = commonTlsContext.getTlsCertificates(0);
        }
        CommonTlsContextUtil.validateTlsCertificate(tlsCertificate, false);
        CertificateValidationContext certificateValidationContext = CommonTlsContextUtil.getCertificateValidationContext(commonTlsContext);
        if (certificateValidationContext != null) {
            certificateValidationContext = CommonTlsContextUtil.validateCertificateContext(certificateValidationContext, true);
        }
        String privateKeyPassword = tlsCertificate.hasPassword() ? tlsCertificate.getPassword().getInlineString() : null;
        return new SecretVolumeServerSslContextProvider(tlsCertificate.getPrivateKey().getFilename(), privateKeyPassword, tlsCertificate.getCertificateChain().getFilename(), certificateValidationContext, downstreamTlsContext);
    }

    @Override
    public void addCallback(SslContextProvider.Callback callback, Executor executor) {
        Preconditions.checkNotNull((Object)callback, (Object)"callback");
        Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.performCallback(new SslContextProvider.SslContextGetter(){

            @Override
            public SslContext get() throws CertificateException, IOException, CertStoreException {
                return SecretVolumeServerSslContextProvider.this.buildSslContextFromSecrets();
            }
        }, callback, executor);
    }

    @Override
    public void close() {
    }

    @VisibleForTesting
    SslContext buildSslContextFromSecrets() throws IOException, CertificateException, CertStoreException {
        SslContextBuilder sslContextBuilder = GrpcSslContexts.forServer((File)new File(this.certificateChain), (File)new File(this.privateKey), (String)this.privateKeyPassword);
        this.setClientAuthValues(sslContextBuilder, this.certContext);
        return sslContextBuilder.build();
    }
}

